<HTML>
<HEAD>
<TITLE>SRC Modula-3: parseparams/src/ParseParams.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>parseparams/src/ParseParams.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> This interface provides simple and robust tools for parsing
   the command line arguments given to a process when it is 
   started (see <CODE>Params</CODE> and <CODE>Process.Create</CODE>). 
   \index{parameters of a process} \index{process!parameters}


<P><PRE>INTERFACE <interface><A HREF="ParseParams.m3">ParseParams</A></interface>;
</PRE> NOTE: Before reading the details, check the usage example at the
   end of this interface. 

<P><PRE>IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

EXCEPTION Error;

TYPE
  <A HREF="ParseParams.m3#T">T</A> &lt;: Public;
    (* A parser for UNIX-style command line arguments. *)

  Public = OBJECT

      arg: REF ARRAY OF TEXT;
        (* Arguments given, including the command name &quot;arg[0]&quot;,
	   but excluding any &quot;@M3&quot; directives. *)

      parsed: REF ARRAY OF BOOLEAN;
        (* Flag &quot;parsed[i]&quot; is &quot;TRUE&quot; if &quot;arg[i]
	   has been parsed. *)
	
      next: CARDINAL;
        (* The next argument to parse is &quot;arg[next]&quot; *)

    METHODS

      init (wr: Wr.T): T;
        (* Allocates the arrays &quot;arg&quot; and &quot;parsed&quot; and
	   initializes them with the parameters of the current
	   process.  Marks &quot;arg[0]&quot; as parsed, all others as unparsed,
	   and sets &quot;next&quot; to 1.  Any subsequent parsing errors
	   will be printed out to &quot;wr&quot;. *)

      keywordPresent (key: TEXT): BOOLEAN;
        (* Looks for the first unparsed argument &quot;arg[i]&quot;
	   that is equal to &quot;key&quot;.  If found, marks it as parsed,
	   sets &quot;next&quot; to &quot;i+1&quot;, and returns &quot;TRUE&quot;.
           Otherwise returns &quot;FALSE&quot; and leaves &quot;next&quot; unchanged. *)
	
      getKeyword (key: TEXT) RAISES {Error};
        (* Same as &quot;keywordPresent&quot;, but raises &quot;Error&quot; if the
	   keyword is not found. *)

      getNext (): TEXT RAISES {Error};
        (* Returns &quot;arg[next]&quot;, marks it as parsed and increments &quot;next&quot;.
	   Raises &quot;Error&quot; if &quot;arg[next]&quot; does not exist or has already
	   been parsed. *)

      testNext (key: TEXT): BOOLEAN RAISES {};
        (* If &quot;arg[next]&quot; exists, is unparsed, and is equal to &quot;key&quot;,
	   marks it as parsed, increments &quot;next&quot; and returns TRUE.
	   Otherwise does none of these things and returns &quot;FALSE&quot;. *)

      getNextInt (
          min:=FIRST(INTEGER); max:=LAST(INTEGER)
	): INTEGER RAISES {Error};
      getNextReal (
          min:=FIRST(REAL); max:=LAST(REAL)
	): REAL RAISES {Error};
      getNextLongReal (
          min:=FIRST(LONGREAL); max:=LAST(LONGREAL)
	): LONGREAL RAISES {Error};
        (* Same as &quot;getNext&quot;, but converts the result to the approriate
	   type (using &quot;Scan.Int&quot;, &quot;Scan.Real&quot;, &quot;Scan.LongReal&quot;).
	   Raises &quot;Error&quot; if the parameter is not a valid literal, or
	   lies outside of the range &quot;[min..max]&quot;.  *)

      error (msg: TEXT) RAISES {Error};
        (* Prints the given message, and raises &quot;Error&quot;. *)

      skipParsed () RAISES {Error};
        (* Points &quot;next&quot; at the first unparsed argument.
	   If there are parsed arguments beyond that one,
	   prints a message and raises &quot;Error&quot;. *)

      finish () RAISES {Error};
        (* Checks if all parameters have been parsed; if not,
	   prints a message and raises &quot;Error&quot;. *)
   END;

END ParseParams.
</PRE><P>
   In some popular operating systems, most programs expect their
   command-line arguments to consist of a string of keywords and
   keyword-labeled arguments (`options', `switches', etc.), followed
   by a list of positional arguments.
<P>
   To help the user, programs generally allow the switches and
   keyword-labeled arguments to be given in any order.  Some of those
   parameters may be optional and/or repeatable, some may be
   mandatory; some may be required or forbidden depending on the
   values of the other parameters.  Furthermore, the value of an
   argument may be just a number or a text string, or may be a cluster
   of two or more values with their own little syntax.
<P>
   This module simplifies the parsing of such command-line parameters,
   by allowing the program to scan the arguments in their <CODE>logical
   order</CODE>.  It also detects automatically many kinds of common
   mistakes---arguments that are missing, repeated, extraneous,
   malformed, or out of range---and prints the appropriate error
   messages.
<P>
   For example, here is how this module could be used by an
   hypothetical program <CODE>prt</CODE> that concatenates a bunch of files and
   prints selected pages ranges, possibly in reverse order, with
   several formatting options.
<P>
   <PRE>
      CONST
           MaxPages = 10000;
         
         VAR (* Arguments from command line: 

   <PRE>|   fontSize: CARDINAL;
   |   landscape: BOOLEAN;
   |   nRanges: CARDINAL := 0;
   |   ini, fin: ARRAY [0..99] OF [1..MaxPages];
   |   rev: ARRAY [0..99] OF BOOLEAN;
   |   files: REF ARRAY OF TEXT;
   |
   | PROCEDURE ParseCommandLine () =
   |   CONST
   |     Usage =
   |       &quot;prt \\\n&quot; &amp;
   |       &quot;  -fontSize &lt;n&gt; \\\n&quot; &amp;
   |       &quot;  [ -landscape | -portrait ] \\\n&quot; &amp;
   |       &quot;  [ -pages &lt;n&gt; &lt;n&gt; [ -reverse ] ]... \\\n&quot; &amp;
   |       &quot;  file...\n&quot;;
   |   BEGIN
   |     WITH
   |       pp = NEW(ParseParams.T).init(Stdio.stderr)
   |     DO
   |       TRY
   |
   |         (* The &quot;-fontSize &quot; parameter is mandatory: *)
   |         pp.getKeyword(&quot;-fontSize&quot;);
   |         fontSize := pp.getNextInt(1,100);
   |
   |         (* Either &quot;-landscape&quot; or &quot;-portrait&quot;, but not both: *)
   |         IF pp.keywordPresent(&quot;-landscape&quot;) THEN
   |           landscape := TRUE
   |         ELSIF pp.keywordPresent(&quot;-portrait&quot;)  THEN
   |           landscape := FALSE
   |         ELSE
   |           (* Default is &quot;-portrait&quot; unless font is too big: *)
   |           landscape := (fontSize &gt; 8)
   |         END;
   |
   |         (* Parse the page ranges: *)
   |         nRanges := 0;
   |         WHILE pp.keywordPresent(&quot;-pages&quot;) DO
   |           IF nRanges &gt; LAST(ini) THEN pp.error(&quot;Too many page ranges&quot;) END;
   |           ini[nRanges] := pp.getNextInt(1,MaxPages);
   |           fin[nRanges] := pp.getNextInt(ini[nRanges],MaxPages);
   |           rev[nRanges] := pp.testNext(&quot;-reverse&quot;);
   |           nRanges := nRanges+1;
   |         END;
   |         IF nRanges = 0 THEN
   |           ini[0] := 1; fin[0] := MaxPages; rev[0] := FALSE;
   |           nRanges := 1
   |         END;
   |
   |         (* Parse the file list: *)
   |         pp.skipParsed();
   |         WITH nFiles = NUMBER(pp.arg^) - pp.next DO
   |           IF nFiles = 0 THEN pp.error(&quot;no files specified&quot;) END;
   |           files := NEW(REF ARRAY OF TEXT, );
   |           FOR i := 0 TO nFiles-1 DO
   |             files[i] := pp.getNext()
   |           END
   |         END;
   |
   |         (* Check for any unparsed parameters: *)
   |         pp.finish();
   |
   |       EXCEPT
   |         ParseParams.Error =&gt;
   |           Wr.PutText(Stdio.stderr, Usage);
   |           Process.Exit(1);
   |       END
   |     END
   |   END ParseCommandLine;

   Note that even though this code parses the parameters in a fixed
   order, the user may give them in any order.
  *)
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
