<HTML>
<HEAD>
<TITLE>SRC Modula-3: parseparams/src/ParseParams.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>parseparams/src/ParseParams.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="ParseParams.i3">ParseParams</A></implements></module>;

IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../fmtlex/src/Scan.i3">Scan</A>, <A HREF="../../fmtlex/src/Lex.i3">Lex</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../params/src/Params.i3">Params</A>, <A HREF="#x1">FloatMode</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      wr: Wr.T; (* Writer for error messages *)
    OVERRIDES
      init := Init;
      keywordPresent := KeywordPresent;
      getKeyword := GetKeyword;
      getNext := GetNext;
      testNext := TestNext;
      getNextInt := GetNextInt;
      getNextReal := GetNextReal;
      getNextLongReal := GetNextLongReal;
      error := PrintError;
      skipParsed := SkipParsed;
      finish := Finish;
    END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(t: T; wr: Wr.T): T =
  BEGIN
    t.wr := wr;
    WITH num = Params.Count DO
      t.arg := NEW(REF ARRAY OF TEXT, num);
      t.parsed := NEW(REF ARRAY OF BOOLEAN, num);
      WITH a = t.arg^, p = t.parsed^ DO
        FOR i := 0 TO num-1 DO
          a[i] := Params.Get(i); p[i] := FALSE
        END;
	p[0] := TRUE;
	t.next := 1
      END;
    END;
    RETURN t
  END Init;

PROCEDURE <A NAME="KeywordPresent"><procedure>KeywordPresent</procedure></A>(t: T; key: TEXT): BOOLEAN =
  BEGIN
    WITH a = t.arg^, p = t.parsed^ DO
      FOR i := 0 TO LAST(a) DO
        IF NOT p[i] AND Text.Equal(key, a[i]) THEN
          t.next := i + 1;
          p[i] := TRUE;
          RETURN TRUE;
        END
      END
    END;
    RETURN FALSE
  END KeywordPresent;

PROCEDURE <A NAME="GetKeyword"><procedure>GetKeyword</procedure></A>(t: T; key: TEXT) RAISES {Error} =
  BEGIN
    IF NOT t.keywordPresent(key) THEN
      t.error(&quot;keyword \&quot;&quot; &amp; key &amp; &quot;\&quot; not found.&quot;);
    END;
  END GetKeyword;

PROCEDURE <A NAME="GetNext"><procedure>GetNext</procedure></A>(t: T): TEXT RAISES {Error} =
  BEGIN
    WITH a = t.arg^, p = t.parsed^ DO
      IF (t.next &gt; LAST(a)) OR p[t.next] THEN
        t.error(&quot;missing argument after argument &quot; &amp;
          Fmt.Int(t.next-1) &amp; &quot; = \&quot;&quot; &amp;
          a[t.next-1] &amp; &quot;\&quot;.&quot;
	)
      END;
      p[t.next] := TRUE;
      INC(t.next);
      RETURN a[t.next-1]
    END;
  END GetNext;

PROCEDURE <A NAME="TestNext"><procedure>TestNext</procedure></A> (t: T; key: TEXT): BOOLEAN RAISES {} =
  BEGIN
    WITH a = t.arg^, p = t.parsed^ DO
      IF (t.next &gt; LAST(a)) OR p[t.next]
      OR NOT Text.Equal(key, a[t.next]) THEN
        RETURN FALSE
      ELSE
        p[t.next] := TRUE;
        INC(t.next);
        RETURN TRUE
      END
    END
  END TestNext;

PROCEDURE <A NAME="GetNextInt"><procedure>GetNextInt</procedure></A>(
    t: T;
    min := FIRST(INTEGER);
    max := LAST(INTEGER)
  ): INTEGER RAISES {Error} =
  VAR nn: INTEGER;
  BEGIN
    WITH txt = t.getNext() DO
      TRY
        nn := Scan.Int(txt);
      EXCEPT
        Lex.Error, FloatMode.Trap =&gt;
          t.error(
	    &quot;parameter &quot; &amp; Fmt.Int(t.next-1) &amp; &quot; = \&quot;&quot; &amp; txt &amp;
	    &quot;\&quot; should be an integer.&quot;
	  )
      END;
      IF (nn &lt; min) OR (nn &gt; max) THEN
        t.error (
	  &quot;parameter &quot; &amp; Fmt.Int(t.next-1) &amp; &quot; = &quot; &amp; Fmt.Int(nn) &amp;
          &quot; should be in [&quot; &amp; Fmt.Int(min) &amp; &quot;..&quot; &amp; Fmt.Int(max) &amp; &quot;].&quot;
	)
      END;
    END;
    RETURN nn
  END GetNextInt;

PROCEDURE <A NAME="GetNextReal"><procedure>GetNextReal</procedure></A>(
    t: T;
    min := FIRST(REAL);
    max := LAST(REAL)
  ): REAL RAISES {Error} =
  VAR x: REAL;
  BEGIN
    WITH txt = t.getNext() DO
      TRY
        x := Scan.Real(txt);
      EXCEPT
        Lex.Error, FloatMode.Trap =&gt;
        t.error(
	  &quot;parameter &quot; &amp; Fmt.Int(t.next-1) &amp; &quot; = \&quot;&quot; &amp; txt &amp;
	  &quot;\&quot; should be a real number.&quot;
	)
      END;
      IF (x &lt; min) OR (x &gt; max) THEN
        t.error (
	  &quot;parameter &quot; &amp; Fmt.Int(t.next-1) &amp; &quot; = &quot; &amp; Fmt.Real(x) &amp;
          &quot; should be in [&quot; &amp; Fmt.Real(min) &amp;
	  &quot; __ &quot; &amp; Fmt.Real(max) &amp; &quot;].&quot;
	)
      END
    END;
    RETURN x
  END GetNextReal;

PROCEDURE <A NAME="GetNextLongReal"><procedure>GetNextLongReal</procedure></A>(
    t: T;
    min := FIRST(LONGREAL);
    max := LAST(LONGREAL)
  ): LONGREAL RAISES {Error} =
  VAR x: LONGREAL;
  BEGIN
    WITH txt = t.getNext() DO
      TRY
        x := Scan.LongReal(txt);
      EXCEPT
        Lex.Error, FloatMode.Trap =&gt;
        t.error(
	  &quot;parameter &quot; &amp; Fmt.Int(t.next-1) &amp; &quot; = \&quot;&quot; &amp; txt &amp;
	  &quot;\&quot; should be a real number.&quot;
	)
      END;
      IF (x &lt; min) OR (x &gt; max) THEN
        t.error (
	  &quot;parameter &quot; &amp; Fmt.Int(t.next-1) &amp; &quot; = &quot; &amp; Fmt.LongReal(x) &amp;
          &quot; should be in [&quot; &amp; Fmt.LongReal(min) &amp;
	  &quot; __ &quot; &amp; Fmt.LongReal(max) &amp; &quot;].&quot;
	)
      END
    END;
    RETURN x
  END GetNextLongReal;

PROCEDURE <A NAME="SkipParsed"><procedure>SkipParsed</procedure></A>(t: T) RAISES {Error} =
  CONST MaxBogus = 5;
  VAR bogus: CARDINAL := 0;
  BEGIN
    WITH a = t.arg^, p = t.parsed^ DO
      t.next := NUMBER(a);
      WHILE (t.next &gt; 0) AND NOT p[t.next-1] DO DEC(t.next) END;
      (* Check for unparsed arguments: *)
      FOR i := 0 TO t.next-1 DO
        IF NOT p[i] THEN
          INC (bogus);
          IF bogus &lt;= 5 THEN
            Message(
	      t.wr,
	      &quot;parameter &quot; &amp; Fmt.Int(i) &amp; &quot; = \&quot;&quot; &amp; a[i] &amp;
	      &quot;\&quot; extraneous or misplaced.&quot;
	    );
          END;
        END;
      END;
      IF bogus &gt; MaxBogus THEN
        Message(t.wr, &quot;(and &quot; &amp; Fmt.Int (bogus - MaxBogus) &amp; &quot; more).&quot;);
      END;
      IF bogus &gt; 0 THEN RAISE Error END;
    END
  END SkipParsed;

PROCEDURE <A NAME="Finish"><procedure>Finish</procedure></A>(t: T) RAISES {Error} =
  CONST MaxBogus = 5;
  VAR bogus: CARDINAL := 0;
  BEGIN
    WITH a = t.arg^, p = t.parsed^ DO
      FOR i := 0 TO LAST(a) DO
        IF NOT p[i] THEN
          INC (bogus);
          IF bogus &lt;= 5 THEN
            Message(
	      t.wr,
	      &quot;parameter &quot; &amp; Fmt.Int(i) &amp; &quot; = \&quot;&quot; &amp; a[i] &amp;
	      &quot;\&quot; extraneous or misplaced.&quot;
	    );
          END;
        END;
      END;
      IF bogus &gt; MaxBogus THEN
        Message(t.wr, &quot;(and &quot; &amp; Fmt.Int (bogus - MaxBogus) &amp; &quot; more).&quot;);
      END;
      t.parsed := NIL;
      t.arg := NIL;
      t.wr := NIL;
      IF bogus &gt; 0 THEN RAISE Error END;
    END
  END Finish;

PROCEDURE <A NAME="Message"><procedure>Message</procedure></A>(wr: Wr.T; msg: TEXT) =
  &lt;*FATAL Wr.Failure, Thread.Alerted*&gt;
  BEGIN
    IF (wr # NIL) THEN
      Wr.PutText(wr, &quot;ParseParams: &quot;);
      Wr.PutText(wr, msg);
      Wr.PutChar(wr, '\n');
      Wr.Flush(wr);
    END
  END Message;

PROCEDURE <A NAME="PrintError"><procedure>PrintError</procedure></A> (t: T; msg: TEXT) RAISES {Error} =
  BEGIN
    Message(t.wr, msg);
    RAISE Error
  END PrintError;

BEGIN
END ParseParams.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
