<HTML>
<HEAD>
<TITLE>SRC Modula-3: pkgobj/derived/PackageObj_Ship_v1.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>pkgobj/derived/PackageObj_Ship_v1.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>PackageObj_Ship_v1</module> EXPORTS <A HREF="../src/Common/PackageObj.i3"><implements>PackageObj</A></implements>, <A HREF="PackageObj_Ship_v1.i3"><implements>PackageObj_Ship_v1</A></implements>;

IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../src/Common/PackageObj.i3">PackageObj</A>,
       <A HREF="../src/Common/PkgErr.i3">PkgErr</A>;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {pullFile, commit, prepare};
      ReturnCodes = {OK, PackageObj_SourceOutOfDate, PkgErr_E};

  PROCEDURE <A NAME="Surrogate_prepare"><procedure>Surrogate_prepare</procedure></A>(
      self: PackageObj.Ship;
      source_arg: PackageObj.Source;
      siblings_arg: PackageObj.Siblings;
      monitor_arg: PackageObj.Monitor) RAISES {PackageObj.SourceOutOfDate,
      NetObj.Error, PkgErr.E, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.prepare));
          StubLib.OutRef(c, source_arg);
          StubLib.OutRef(c, siblings_arg);
          StubLib.OutRef(c, monitor_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            reuse := TRUE;
          | ORD(ReturnCodes.PackageObj_SourceOutOfDate) =&gt;
            VAR arg: TextList.T;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(TextList.T));
              reuse := TRUE;
              RAISE PackageObj.SourceOutOfDate(arg);

            END;
          | ORD(ReturnCodes.PkgErr_E) =&gt;
            VAR arg: AtomList.T;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(AtomList.T));
              reuse := TRUE;
              RAISE PkgErr.E(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_prepare;

  PROCEDURE <A NAME="Surrogate_commit"><procedure>Surrogate_commit</procedure></A>(
      self: PackageObj.Ship;
      version_arg: PackageObj.Version) RAISES {NetObj.Error, PkgErr.E,
      Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.commit));
          dataPresent := TRUE;
          StubLib.OutBoolean(c, dataPresent);
          IF dataPresent THEN
            StubLib.OutInteger(c, version_arg.t);
            StubLib.OutInteger(c, version_arg.vn);
            END;
            rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            reuse := TRUE;
          | ORD(ReturnCodes.PkgErr_E) =&gt;
            VAR arg: AtomList.T;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(AtomList.T));
              reuse := TRUE;
              RAISE PkgErr.E(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_commit;

  PROCEDURE <A NAME="Surrogate_pullFile"><procedure>Surrogate_pullFile</procedure></A>(
      self: PackageObj.Ship;
      path_arg: TextList.T;
      date_arg: LONGREAL;
      length_arg: CARDINAL): Rd.T RAISES {NetObj.Error, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: Rd.T;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.pullFile));
          StubLib.OutRef(c, path_arg);
          StubLib.OutLongreal(c, date_arg);
          StubLib.OutInteger(c, length_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(Rd.T));
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_pullFile;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, PackageObj.Ship);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InInt32(c, rep) OF
      | ORD(Methods.prepare) =&gt; Stub_prepare(t, c, rep);
      | ORD(Methods.commit) =&gt; Stub_commit(t, c, rep);
      | ORD(Methods.pullFile) =&gt; Stub_pullFile(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    | PkgErr.E(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.PkgErr_E));
        StubLib.OutRef(c, arg);

    | PackageObj.SourceOutOfDate(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.PackageObj_SourceOutOfDate));
        StubLib.OutRef(c, arg);
    END;
  END Invoke;

PROCEDURE <A NAME="Stub_prepare"><procedure>Stub_prepare</procedure></A>(
    self: PackageObj.Ship;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, PackageObj.SourceOutOfDate, PkgErr.E}=
  VAR source_arg: PackageObj.Source;
      siblings_arg: PackageObj.Siblings;
      monitor_arg: PackageObj.Monitor;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    source_arg := StubLib.InRef(c, rep, TYPECODE(PackageObj.Source));
    siblings_arg := StubLib.InRef(c, rep, TYPECODE(PackageObj.Siblings));
    monitor_arg := StubLib.InRef(c, rep, TYPECODE(PackageObj.Monitor));
    self.prepare(source_arg, siblings_arg, monitor_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));

  END Stub_prepare;

PROCEDURE <A NAME="Stub_commit"><procedure>Stub_commit</procedure></A>(
    self: PackageObj.Ship;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, PkgErr.E}=
  VAR version_arg: PackageObj.Version;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    dataPresent := StubLib.InBoolean(c);
    IF dataPresent THEN
      version_arg.t := StubLib.InInteger(c, rep, -2147483647, 2147483647);
      version_arg.vn := StubLib.InInteger(c, rep, -2147483647, 2147483647);
      END;
      self.commit(version_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));

  END Stub_commit;

PROCEDURE <A NAME="Stub_pullFile"><procedure>Stub_pullFile</procedure></A>(
    self: PackageObj.Ship;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR path_arg: TextList.T;
      date_arg: LONGREAL;
      length_arg: CARDINAL;
      res: Rd.T;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    path_arg := StubLib.InRef(c, rep, TYPECODE(TextList.T));
    date_arg := StubLib.InLongreal(c, rep);
    length_arg := StubLib.InInteger(c, rep, 0, 2147483647);
    res := self.pullFile(path_arg, date_arg, length_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_pullFile;

BEGIN
  StubLib.Register(TYPECODE(PackageObj.Ship), 1, TYPECODE(Surrogate_PackageObj_Ship), Invoke);
END PackageObj_Ship_v1.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
