<HTML>
<HEAD>
<TITLE>SRC Modula-3: pkgobj/derived/PackageObj_Source_v1.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>pkgobj/derived/PackageObj_Source_v1.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>PackageObj_Source_v1</module> EXPORTS <A HREF="../src/Common/PackageObj.i3"><implements>PackageObj</A></implements>, <A HREF="PackageObj_Source_v1.i3"><implements>PackageObj_Source_v1</A></implements>;

IMPORT <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>,
       <A HREF="../src/Common/PackageObj.i3">PackageObj</A>, <A HREF="../src/Common/PkgErr.i3">PkgErr</A>;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {links, pullFile, enum};
      ReturnCodes = {OK, PkgErr_E};

  PROCEDURE <A NAME="Surrogate_enum"><procedure>Surrogate_enum</procedure></A>(self: PackageObj.Source): PackageObj.Enum
       RAISES {NetObj.Error, PkgErr.E, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: PackageObj.Enum;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.enum));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res.ts := StubLib.InLongreal(c, rep);
            res.dir := StubLib.InRef(c, rep, TYPECODE(RefList.T));
            res.fill := StubLib.InRef(c, rep, -1);
            reuse := TRUE;
          | ORD(ReturnCodes.PkgErr_E) =&gt;
            VAR arg: AtomList.T;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(AtomList.T));
              reuse := TRUE;
              RAISE PkgErr.E(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_enum;

  PROCEDURE <A NAME="Surrogate_pullFile"><procedure>Surrogate_pullFile</procedure></A>(
      self: PackageObj.Source;
      path_arg: TextList.T): Rd.T RAISES {NetObj.Error, PkgErr.E,
      Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: Rd.T;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.pullFile));
          StubLib.OutRef(c, path_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(Rd.T));
            reuse := TRUE;
          | ORD(ReturnCodes.PkgErr_E) =&gt;
            VAR arg: AtomList.T;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(AtomList.T));
              reuse := TRUE;
              RAISE PkgErr.E(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_pullFile;

  PROCEDURE <A NAME="Surrogate_links"><procedure>Surrogate_links</procedure></A>(self: PackageObj.Source)
      : PackageObj.ExportLinks RAISES {NetObj.Error, PkgErr.E,
      Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: PackageObj.ExportLinks;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.links));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(PackageObj.ExportLinks));
            reuse := TRUE;
          | ORD(ReturnCodes.PkgErr_E) =&gt;
            VAR arg: AtomList.T;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(AtomList.T));
              reuse := TRUE;
              RAISE PkgErr.E(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_links;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, PackageObj.Source);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InInt32(c, rep) OF
      | ORD(Methods.enum) =&gt; Stub_enum(t, c, rep);
      | ORD(Methods.pullFile) =&gt; Stub_pullFile(t, c, rep);
      | ORD(Methods.links) =&gt; Stub_links(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    | PkgErr.E(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.PkgErr_E));
        StubLib.OutRef(c, arg);
    END;
  END Invoke;

PROCEDURE <A NAME="Stub_enum"><procedure>Stub_enum</procedure></A>(
    self: PackageObj.Source;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, PkgErr.E}=
  VAR res: PackageObj.Enum;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    res := self.enum();
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutLongreal(c, res.ts);
    StubLib.OutRef(c, res.dir);
    StubLib.OutRef(c, res.fill);

  END Stub_enum;

PROCEDURE <A NAME="Stub_pullFile"><procedure>Stub_pullFile</procedure></A>(
    self: PackageObj.Source;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, PkgErr.E}=
  VAR path_arg: TextList.T;
      res: Rd.T;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    path_arg := StubLib.InRef(c, rep, TYPECODE(TextList.T));
    res := self.pullFile(path_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_pullFile;

PROCEDURE <A NAME="Stub_links"><procedure>Stub_links</procedure></A>(
    self: PackageObj.Source;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, PkgErr.E}=
  VAR res: PackageObj.ExportLinks;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    res := self.links();
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_links;

BEGIN
  StubLib.Register(TYPECODE(PackageObj.Source), 1, TYPECODE(Surrogate_PackageObj_Source), Invoke);
END PackageObj_Source_v1.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
