<HTML>
<HEAD>
<TITLE>SRC Modula-3: pkgobj/derived/PackageObj_T_v1.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>pkgobj/derived/PackageObj_T_v1.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>PackageObj_T_v1</module> EXPORTS <A HREF="../src/Common/PackageObj.i3"><implements>PackageObj</A></implements>, <A HREF="PackageObj_T_v1.i3"><implements>PackageObj_T_v1</A></implements>;

IMPORT <A HREF="../src/Common/NetPath.i3">NetPath</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>,
       <A HREF="../src/Common/PackageObj.i3">PackageObj</A>, <A HREF="../src/Common/PkgErr.i3">PkgErr</A>;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {status, checkDir, removeBackup, vcommit, newShip,
        newSource, version};
      ReturnCodes = {OK, PkgErr_E};

  PROCEDURE <A NAME="Surrogate_version"><procedure>Surrogate_version</procedure></A>(self: PackageObj.T; package_arg: NetPath.PN)
      : PackageObj.Version RAISES {NetObj.Error, PkgErr.E, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: PackageObj.Version;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.version));
          dataPresent := TRUE;
          StubLib.OutBoolean(c, dataPresent);
          IF dataPresent THEN
            StubLib.OutRef(c, package_arg.dir);
            StubLib.OutRef(c, package_arg.arc);
            END;
            rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res.t := StubLib.InInteger(c, rep, -2147483647, 2147483647);
            res.vn := StubLib.InInteger(c, rep, -2147483647, 2147483647);
            reuse := TRUE;
          | ORD(ReturnCodes.PkgErr_E) =&gt;
            VAR arg: AtomList.T;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(AtomList.T));
              reuse := TRUE;
              RAISE PkgErr.E(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_version;

  PROCEDURE <A NAME="Surrogate_newSource"><procedure>Surrogate_newSource</procedure></A>(
      self: PackageObj.T;
      auth_arg: TEXT;
      package_arg: NetPath.PN;
      VAR OUTversion_arg: PackageObj.Version): PackageObj.Source
       RAISES {NetObj.Error, PkgErr.E, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: PackageObj.Source;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.newSource));
          StubLib.OutRef(c, auth_arg);
          dataPresent := TRUE;
          StubLib.OutBoolean(c, dataPresent);
          IF dataPresent THEN
            StubLib.OutRef(c, package_arg.dir);
            StubLib.OutRef(c, package_arg.arc);
            END;
            dataPresent := TRUE;
          StubLib.OutBoolean(c, dataPresent);
          IF dataPresent THEN
            StubLib.OutInteger(c, OUTversion_arg.t);
            StubLib.OutInteger(c, OUTversion_arg.vn);
            END;
            rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            OUTversion_arg.t := StubLib.InInteger(c, rep, -2147483647, 2147483647);
            OUTversion_arg.vn := StubLib.InInteger(c, rep, -2147483647, 2147483647);
            res := StubLib.InRef(c, rep, TYPECODE(PackageObj.Source));
            reuse := TRUE;
          | ORD(ReturnCodes.PkgErr_E) =&gt;
            VAR arg: AtomList.T;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(AtomList.T));
              reuse := TRUE;
              RAISE PkgErr.E(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_newSource;

  PROCEDURE <A NAME="Surrogate_newShip"><procedure>Surrogate_newShip</procedure></A>(
      self: PackageObj.T;
      auth_arg: TEXT;
      package_arg: NetPath.PN;
      options_arg: PackageObj.ShipOptions): PackageObj.Ship
       RAISES {NetObj.Error, PkgErr.E, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: PackageObj.Ship;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.newShip));
          StubLib.OutRef(c, auth_arg);
          dataPresent := TRUE;
          StubLib.OutBoolean(c, dataPresent);
          IF dataPresent THEN
            StubLib.OutRef(c, package_arg.dir);
            StubLib.OutRef(c, package_arg.arc);
            END;
            dataPresent := TRUE;
          StubLib.OutBoolean(c, dataPresent);
          IF dataPresent THEN
            StubLib.OutInteger(c, ORD(options_arg.keepBackup));
            StubLib.OutInteger(c, ORD(options_arg.purgeLinks));
            StubLib.OutInteger(c, ORD(options_arg.forceDateMatch));
            END;
            rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(PackageObj.Ship));
            reuse := TRUE;
          | ORD(ReturnCodes.PkgErr_E) =&gt;
            VAR arg: AtomList.T;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(AtomList.T));
              reuse := TRUE;
              RAISE PkgErr.E(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_newShip;

  PROCEDURE <A NAME="Surrogate_vcommit"><procedure>Surrogate_vcommit</procedure></A>(
      self: PackageObj.T;
      auth_arg: TEXT;
      package_arg: NetPath.PN;
      version_arg: PackageObj.Version;
      prevVersion_arg: PackageObj.Version): BOOLEAN RAISES {NetObj.Error,
      PkgErr.E, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: BOOLEAN;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.vcommit));
          StubLib.OutRef(c, auth_arg);
          dataPresent := TRUE;
          StubLib.OutBoolean(c, dataPresent);
          IF dataPresent THEN
            StubLib.OutRef(c, package_arg.dir);
            StubLib.OutRef(c, package_arg.arc);
            END;
            dataPresent := TRUE;
          StubLib.OutBoolean(c, dataPresent);
          IF dataPresent THEN
            StubLib.OutInteger(c, version_arg.t);
            StubLib.OutInteger(c, version_arg.vn);
            END;
            dataPresent := TRUE;
          StubLib.OutBoolean(c, dataPresent);
          IF dataPresent THEN
            StubLib.OutInteger(c, prevVersion_arg.t);
            StubLib.OutInteger(c, prevVersion_arg.vn);
            END;
            rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
            reuse := TRUE;
          | ORD(ReturnCodes.PkgErr_E) =&gt;
            VAR arg: AtomList.T;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(AtomList.T));
              reuse := TRUE;
              RAISE PkgErr.E(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_vcommit;

  PROCEDURE <A NAME="Surrogate_removeBackup"><procedure>Surrogate_removeBackup</procedure></A>(
      self: PackageObj.T;
      auth_arg: TEXT;
      package_arg: NetPath.PN) RAISES {NetObj.Error, PkgErr.E,
      Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.removeBackup));
          StubLib.OutRef(c, auth_arg);
          dataPresent := TRUE;
          StubLib.OutBoolean(c, dataPresent);
          IF dataPresent THEN
            StubLib.OutRef(c, package_arg.dir);
            StubLib.OutRef(c, package_arg.arc);
            END;
            rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            reuse := TRUE;
          | ORD(ReturnCodes.PkgErr_E) =&gt;
            VAR arg: AtomList.T;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(AtomList.T));
              reuse := TRUE;
              RAISE PkgErr.E(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_removeBackup;

  PROCEDURE <A NAME="Surrogate_checkDir"><procedure>Surrogate_checkDir</procedure></A>(
      self: PackageObj.T;
      dir_arg: TextList.T;
      child_arg: TEXT) RAISES {NetObj.Error, PkgErr.E, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.checkDir));
          StubLib.OutRef(c, dir_arg);
          StubLib.OutRef(c, child_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            reuse := TRUE;
          | ORD(ReturnCodes.PkgErr_E) =&gt;
            VAR arg: AtomList.T;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(AtomList.T));
              reuse := TRUE;
              RAISE PkgErr.E(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_checkDir;

  PROCEDURE <A NAME="Surrogate_status"><procedure>Surrogate_status</procedure></A>(self: PackageObj.T): TEXT
       RAISES {NetObj.Error, Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: TEXT;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.status));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, -1);
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_status;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, PackageObj.T);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InInt32(c, rep) OF
      | ORD(Methods.version) =&gt; Stub_version(t, c, rep);
      | ORD(Methods.newSource) =&gt; Stub_newSource(t, c, rep);
      | ORD(Methods.newShip) =&gt; Stub_newShip(t, c, rep);
      | ORD(Methods.vcommit) =&gt; Stub_vcommit(t, c, rep);
      | ORD(Methods.removeBackup) =&gt; Stub_removeBackup(t, c, rep);
      | ORD(Methods.checkDir) =&gt; Stub_checkDir(t, c, rep);
      | ORD(Methods.status) =&gt; Stub_status(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    | PkgErr.E(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.PkgErr_E));
        StubLib.OutRef(c, arg);
    END;
  END Invoke;

PROCEDURE <A NAME="Stub_version"><procedure>Stub_version</procedure></A>(
    self: PackageObj.T;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, PkgErr.E}=
  VAR package_arg: NetPath.PN;
      res: PackageObj.Version;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    dataPresent := StubLib.InBoolean(c);
    IF dataPresent THEN
      package_arg.dir := StubLib.InRef(c, rep, TYPECODE(TextList.T));
      package_arg.arc := StubLib.InRef(c, rep, -1);
      END;
      res := self.version(package_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutInteger(c, res.t);
    StubLib.OutInteger(c, res.vn);

  END Stub_version;

PROCEDURE <A NAME="Stub_newSource"><procedure>Stub_newSource</procedure></A>(
    self: PackageObj.T;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, PkgErr.E}=
  VAR auth_arg: TEXT;
      package_arg: NetPath.PN;
      OUTversion_arg: PackageObj.Version;
      res: PackageObj.Source;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    auth_arg := StubLib.InRef(c, rep, -1);
    dataPresent := StubLib.InBoolean(c);
    IF dataPresent THEN
      package_arg.dir := StubLib.InRef(c, rep, TYPECODE(TextList.T));
      package_arg.arc := StubLib.InRef(c, rep, -1);
      END;
      dataPresent := StubLib.InBoolean(c);
    IF dataPresent THEN
      OUTversion_arg.t := StubLib.InInteger(c, rep, -2147483647, 2147483647);
      OUTversion_arg.vn := StubLib.InInteger(c, rep, -2147483647, 2147483647);
      END;
      res := self.newSource(auth_arg, package_arg, OUTversion_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutInteger(c, OUTversion_arg.t);
    StubLib.OutInteger(c, OUTversion_arg.vn);
    StubLib.OutRef(c, res);

  END Stub_newSource;

PROCEDURE <A NAME="Stub_newShip"><procedure>Stub_newShip</procedure></A>(
    self: PackageObj.T;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, PkgErr.E}=
  VAR auth_arg: TEXT;
      package_arg: NetPath.PN;
      options_arg: PackageObj.ShipOptions;
      res: PackageObj.Ship;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    auth_arg := StubLib.InRef(c, rep, -1);
    dataPresent := StubLib.InBoolean(c);
    IF dataPresent THEN
      package_arg.dir := StubLib.InRef(c, rep, TYPECODE(TextList.T));
      package_arg.arc := StubLib.InRef(c, rep, -1);
      END;
      dataPresent := StubLib.InBoolean(c);
    IF dataPresent THEN
      options_arg.keepBackup := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
      options_arg.purgeLinks := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
      options_arg.forceDateMatch := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
      END;
      res := self.newShip(auth_arg, package_arg, options_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_newShip;

PROCEDURE <A NAME="Stub_vcommit"><procedure>Stub_vcommit</procedure></A>(
    self: PackageObj.T;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, PkgErr.E}=
  VAR auth_arg: TEXT;
      package_arg: NetPath.PN;
      version_arg: PackageObj.Version;
      prevVersion_arg: PackageObj.Version;
      res: BOOLEAN;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    auth_arg := StubLib.InRef(c, rep, -1);
    dataPresent := StubLib.InBoolean(c);
    IF dataPresent THEN
      package_arg.dir := StubLib.InRef(c, rep, TYPECODE(TextList.T));
      package_arg.arc := StubLib.InRef(c, rep, -1);
      END;
      dataPresent := StubLib.InBoolean(c);
    IF dataPresent THEN
      version_arg.t := StubLib.InInteger(c, rep, -2147483647, 2147483647);
      version_arg.vn := StubLib.InInteger(c, rep, -2147483647, 2147483647);
      END;
      dataPresent := StubLib.InBoolean(c);
    IF dataPresent THEN
      prevVersion_arg.t := StubLib.InInteger(c, rep, -2147483647, 2147483647);
      prevVersion_arg.vn := StubLib.InInteger(c, rep, -2147483647, 2147483647);
      END;
      res := self.vcommit(auth_arg, package_arg, version_arg, prevVersion_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutInteger(c, ORD(res));

  END Stub_vcommit;

PROCEDURE <A NAME="Stub_removeBackup"><procedure>Stub_removeBackup</procedure></A>(
    self: PackageObj.T;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, PkgErr.E}=
  VAR auth_arg: TEXT;
      package_arg: NetPath.PN;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    auth_arg := StubLib.InRef(c, rep, -1);
    dataPresent := StubLib.InBoolean(c);
    IF dataPresent THEN
      package_arg.dir := StubLib.InRef(c, rep, TYPECODE(TextList.T));
      package_arg.arc := StubLib.InRef(c, rep, -1);
      END;
      self.removeBackup(auth_arg, package_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));

  END Stub_removeBackup;

PROCEDURE <A NAME="Stub_checkDir"><procedure>Stub_checkDir</procedure></A>(
    self: PackageObj.T;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, PkgErr.E}=
  VAR dir_arg: TextList.T;
      child_arg: TEXT;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    dir_arg := StubLib.InRef(c, rep, TYPECODE(TextList.T));
    child_arg := StubLib.InRef(c, rep, -1);
    self.checkDir(dir_arg, child_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));

  END Stub_checkDir;

PROCEDURE <A NAME="Stub_status"><procedure>Stub_status</procedure></A>(
    self: PackageObj.T;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR res: TEXT;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    res := self.status();
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_status;

BEGIN
  StubLib.Register(TYPECODE(PackageObj.T), 1, TYPECODE(Surrogate_PackageObj_T), Invoke);
END PackageObj_T_v1.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
