<HTML>
<HEAD>
<TITLE>SRC Modula-3: pkgobj/derived/SiteObj_ST_v1.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>pkgobj/derived/SiteObj_ST_v1.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>SiteObj_ST_v1</module> EXPORTS <A HREF="../src/Common/SiteObj.i3"><implements>SiteObj</A></implements>, <A HREF="SiteObj_ST_v1.i3"><implements>SiteObj_ST_v1</A></implements>;

IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../src/Common/SiteObj.i3">SiteObj</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../src/Common/Site.i3">Site</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {get};
      ReturnCodes = {OK};

  PROCEDURE <A NAME="Surrogate_get"><procedure>Surrogate_get</procedure></A>(self: SiteObj.ST): Site.T RAISES {NetObj.Error,
      Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: Site.T;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.get));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(Site.T));
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_get;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, SiteObj.ST);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InInt32(c, rep) OF
      | ORD(Methods.get) =&gt; Stub_get(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    END;
  END Invoke;

PROCEDURE <A NAME="Stub_get"><procedure>Stub_get</procedure></A>(
    self: SiteObj.ST;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR res: Site.T;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    res := self.get();
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_get;

BEGIN
  StubLib.Register(TYPECODE(SiteObj.ST), 1, TYPECODE(Surrogate_SiteObj_ST), Invoke);
END SiteObj_ST_v1.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
