<HTML>
<HEAD>
<TITLE>SRC Modula-3: pkgobj/src/Common/LockOps.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>pkgobj/src/Common/LockOps.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> LockOps.m3 </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="LockOps.i3">LockOps</A></implements></module>;
</PRE><BLOCKQUOTE><EM><P>
   This is the package locking interface which the local lock server
   presents to its packagetool clients.  This interface does not
   depend on the existence of packagetool siphons, but it does
   provide consistent semantics if one or more siphons do exist.
   Locks may either be managed by the local site, in which case the
   actual lock key is held in the local database, or managed remotely,
   in which case the local database contains a pointer to the managing
   site.
</EM></BLOCKQUOTE><PRE>

IMPORT <A HREF="LockMethods.i3">LockMethods</A>, <A HREF="Site.i3">Site</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
IMPORT <A HREF="../../../fingerprint/src/Fingerprint.i3">Fingerprint</A>, <A HREF="../../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../../tcp/src/common/IP.i3">IP</A>, <A HREF="../../../tcpnetobj/src/TCPNetObj.i3">TCPNetObj</A>, <A HREF="PkgProt.i3">PkgProt</A>, <A HREF="PkgErr.i3">PkgErr</A>;
FROM <A HREF="PkgErr.i3">PkgErr</A> IMPORT Aborted, LockServerDown;

VAR
  default: T := NIL;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (): T RAISES {PkgErr.E} =
  VAR siteT: Site.T;
  VAR obj: NetObj.T;
      addr: IP.Address;
  BEGIN
    TRY
      IF default # NIL THEN RETURN default; END;
      siteT := Site.Get();
      IF siteT.ipPort = IP.NullPort THEN
        obj := NetObj.Import(
          PkgProt.LockExportName, NetObj.Locate(siteT.lockserver));
      ELSE
        IF NOT IP.GetHostByName(siteT.lockserver, addr) THEN
          PkgErr.Raise(LockServerDown);
        END;
        obj := NetObj.Import(
          PkgProt.LockExportName,
          TCPNetObj.Locate(IP.Endpoint{addr, siteT.ipPort}));
      END;
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | IP.Error(ipErr) =&gt;
        PkgErr.Raise(LockServerDown, ipErr);
    | NetObj.Invalid =&gt;
        PkgErr.Raise(LockServerDown);
    | NetObj.Error(ec) =&gt;
        PkgErr.Raise(LockServerDown, ec);
    END;
    IF (obj = NIL) OR NOT ISTYPE(obj, T) THEN
      PkgErr.Raise(LockServerDown);
    END;
    RETURN NARROW(obj, T);
  END New;

PROCEDURE <A NAME="SetServerT"><procedure>SetServerT</procedure></A>(t: T) =
  BEGIN
    default := t;
  END SetServerT;

PROCEDURE <A NAME="Create"><procedure>Create</procedure></A>
  (auth: Auth; pn: PN; initialKey: Text.T;
   version: Version := Version{0,InitialVN};
   remoteCheck: BOOLEAN := TRUE; t: T := NIL) RAISES {PkgErr.E} =
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      t.create (auth, pn, initialKey, version, remoteCheck);
    EXCEPT
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    END;
  END Create;

PROCEDURE <A NAME="Remove"><procedure>Remove</procedure></A>
  (auth: Auth; pn: PN; key: Text.T; reship: BOOLEAN := TRUE;
   t: T := NIL) RAISES {PkgErr.E, CommitFailed, LockConflict} =
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      t.remove(auth, pn, key, reship);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
  END Remove;

PROCEDURE <A NAME="Lock"><procedure>Lock</procedure></A>
  (auth: Auth; pn: PN; version: Version; key: Text.T;
   keySite: SiteName := NIL; t: T := NIL): Version
   RAISES {PkgErr.E, LockConflict} =
  VAR v: Version;
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
       v := t.lock (auth, pn, version, key, keySite);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
    RETURN v;
  END Lock;

PROCEDURE <A NAME="Unlock"><procedure>Unlock</procedure></A>
  (auth: Auth; pn: PN; version: Version; key: Text.T;
   keySite: SiteName := NIL; breakRights: BreakRights := BreakRights.OwnerOnly;
   forceVersion: BOOLEAN := FALSE; t: T := NIL)
   RAISES {PkgErr.E, CommitFailed, LockConflict, SynchVersions} =
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      t.unlock (auth, pn, version,
                key, keySite, breakRights, forceVersion);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
  END Unlock;

PROCEDURE <A NAME="AssignVersion"><procedure>AssignVersion</procedure></A>
  (auth: Auth; pn: PN; key: Text.T; keySite: SiteName := NIL;
   t: T := NIL): Version RAISES {PkgErr.E, LockConflict} =
  VAR v: Version;
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      v := t.assign (auth, pn, key, keySite);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
    RETURN v;
  END AssignVersion;

PROCEDURE <A NAME="Commit"><procedure>Commit</procedure></A>
  (auth: Auth; pn: PN; version: Version;
   VAR ships: ShipArray; reship: BOOLEAN := TRUE; t: T := NIL): CommitFailures
   RAISES {CommitFailed, PkgErr.E} =
  VAR res: CommitFailures;
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      res := t.commit (auth, pn, version, ships, reship);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
    RETURN res;
  END Commit;
</PRE> lock enumeration 

<P><PRE>PROCEDURE <A NAME="Enumerate"><procedure>Enumerate</procedure></A>
  (dir: Dir; site: SiteName := NIL; locksOnly: BOOLEAN := TRUE;
   localOnly: BOOLEAN := TRUE; pendingOnly: BOOLEAN := FALSE;
   t: T := NIL) : EnumList RAISES {PkgErr.E} =
  VAR res: EnumList;
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      res := t.enumerate (dir, site, locksOnly, localOnly, pendingOnly);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
    RETURN res;
  END Enumerate;

PROCEDURE <A NAME="GetEntry"><procedure>GetEntry</procedure></A>
  (pn: PN; goRemote: BOOLEAN := FALSE; t: T := NIL) : RefEntry
   RAISES {PkgErr.E} =
  VAR e: RefEntry;
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      e := t.getEntry (pn, goRemote);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
    RETURN e;
 END GetEntry;
</PRE> the following two procedures are administrative tools 
 they apply only to the database at the target machine 

<P><PRE>PROCEDURE <A NAME="SetEntry"><procedure>SetEntry</procedure></A> (auth: Auth; pn: PN; entry: RefEntry; t: T := NIL)
   RAISES {PkgErr.E} =
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      t.setEntry (auth, pn, entry);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
  END SetEntry;

PROCEDURE <A NAME="SetFingerprint"><procedure>SetFingerprint</procedure></A>
  (auth: Auth; pn: PN; version: Version; fp: Fingerprint.T; t: T := NIL)
   RAISES {PkgErr.E} =
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      t.setFingerprint (auth, pn, version, fp);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
  END SetFingerprint;
</PRE> the following two procedures are called only through siphon ops 
 they apply only to the database at the target machine 

<P><PRE>PROCEDURE <A NAME="CreateCheck"><procedure>CreateCheck</procedure></A>(pn: PN; t: T := NIL) RAISES {PkgErr.E} =
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      t.createCheck (pn);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
  END CreateCheck;

PROCEDURE <A NAME="CreateForeign"><procedure>CreateForeign</procedure></A>
  (auth: Auth; pn: PN; owningSite: SiteName; instance: Instance;
   t: T := NIL) RAISES {PkgErr.E} =
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      t.createForeign (auth, pn, owningSite, instance);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
  END CreateForeign;
</PRE>***********************
 new public procedures 
***********************

<P><PRE>PROCEDURE <A NAME="CreateDir"><procedure>CreateDir</procedure></A>
  (auth: Auth; dir: Dir; t: T := NIL) RAISES {PkgErr.E} =
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      t.createDir (auth, dir);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
  END CreateDir;

PROCEDURE <A NAME="RemoveDir"><procedure>RemoveDir</procedure></A>
  (auth: Auth; dir: Dir; t: T := NIL) RAISES {PkgErr.E} =
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      t.removeDir (auth, dir);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
  END RemoveDir;

PROCEDURE <A NAME="CheckDir"><procedure>CheckDir</procedure></A> (name: Dir; t: T := NIL) RAISES {PkgErr.E} =
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      t.checkDir (name);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
  END CheckDir;

PROCEDURE <A NAME="EnumerateDirs"><procedure>EnumerateDirs</procedure></A>
  (site: SiteName := NIL; t: T := NIL): DirList RAISES {PkgErr.E} =
  VAR res: DirList;
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      res := t.enumerateDirs (site);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
    RETURN res;
  END EnumerateDirs;

PROCEDURE <A NAME="RemoveForeign"><procedure>RemoveForeign</procedure></A>
  (auth: Auth; pn: PN; t: T := NIL) RAISES {PkgErr.E, CommitFailed} =
  BEGIN
    IF t = NIL THEN t := New ();  END;
    TRY
      t.removeForeign (auth, pn);
    EXCEPT
    | Thread.Alerted =&gt; PkgErr.Raise(Aborted);
    | NetObj.Error(ec) =&gt; PkgErr.Raise(LockServerDown, ec);
    END;
  END RemoveForeign;

BEGIN
END LockOps.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
