<HTML>
<HEAD>
<TITLE>SRC Modula-3: pkgobj/src/Common/NetPath.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>pkgobj/src/Common/NetPath.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> NetPath.i3                                                </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="NetPath.m3">NetPath</A></interface>;

  (* network representation of pathnames *)

IMPORT <A HREF="../../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

CONST
  Brand = &quot;NetPath.T&quot;;

TYPE
  T = TextList.T;
     (* A &quot;NetPath.T&quot; represents a relative pathname.  All such pathnames
        have component arc paths which are non-empty.  Path arcs have no
        machine-specific separator characters, and require a character
        set and maximum length allowing for architecture independence.
        The value &quot;NIL&quot; is a legal &quot;NetPath.T&quot;. *)

  Dir = T;
  PN = RECORD dir: Dir; arc: TEXT; END;
     (* A &quot;PN&quot; names a package.  It consists of a &quot;dir&quot; which
        is interpreted relative to the target package server's
        directory structure, and an &quot;arc&quot; which names an immediate
        child of &quot;dir&quot;.  The &quot;arc&quot; field of a &quot;PN&quot; must be non-NIL. *)

  Referent = TEXT;
     (* There are only symbolic links in Unix, therefore we use the
        Unix representation for link referents. *)

EXCEPTION Invalid;
</PRE> for generics 

<P><PRE>PROCEDURE <A HREF="NetPath.m3#Equal">Equal</A>(t1, t2: T) : BOOLEAN;
PROCEDURE <A HREF="NetPath.m3#Hash">Hash</A>(t: T) : Word.T;
PROCEDURE <A HREF="NetPath.m3#Compare">Compare</A>(t1, t2: T) : [-1..1];
</PRE> utilities ... validate type safety 

<P><PRE>PROCEDURE <A HREF="NetPath.m3#Check">Check</A>(t: T) : BOOLEAN;
PROCEDURE <A HREF="NetPath.m3#CheckArc">CheckArc</A>(arc: TEXT) : BOOLEAN;
</PRE> conversions 

<P><PRE>PROCEDURE <A HREF="NetPath.m3#ToText">ToText</A>(t: T) : TEXT;
            (* result is a non-NIL relative pathname *)

PROCEDURE <A HREF="NetPath.m3#FromText">FromText</A>(text: TEXT) : T RAISES {Invalid};
            (* expects a relative path name *)
            (* for backward compatibility .. single
               character absolute root names (e.g. &quot;/&quot;) will be stripped *)

PROCEDURE <A HREF="NetPath.m3#ToRelFN">ToRelFN</A>(t: T) : TEXT;
            (* result is a non-NIL relative pathname *)

PROCEDURE <A HREF="NetPath.m3#FromRelFN">FromRelFN</A>(text: TEXT) : T RAISES {Invalid};
            (* expects a relative path name *)
            (* for backward compatibility .. single
               character absolute root names (e.g. &quot;/&quot;) will be stripped *)

PROCEDURE <A HREF="NetPath.m3#Parent">Parent</A>(t: T) : T;
            (* returns a copy of &quot;t&quot; minus the tail element, or NIL *)
</PRE> package names 

<P><PRE>PROCEDURE <A HREF="NetPath.m3#EqualPN">EqualPN</A>(pn1, pn2: PN) : BOOLEAN;
PROCEDURE <A HREF="NetPath.m3#PNToText">PNToText</A>(pn: PN) : TEXT;
PROCEDURE <A HREF="NetPath.m3#PNFromText">PNFromText</A>(text: TEXT) : PN RAISES {Invalid};

END NetPath.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
