<HTML>
<HEAD>
<TITLE>SRC Modula-3: pkgobj/src/Common/Siphon.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>pkgobj/src/Common/Siphon.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Siphon.m3 </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="Siphon.i3">Siphon</A></implements></module>;

IMPORT <A HREF="Site.i3">Site</A>, <A HREF="PkgErr.i3">PkgErr</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
IMPORT <A HREF="../../../tcp/src/common/IP.i3">IP</A>, <A HREF="../../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../../tcpnetobj/src/TCPNetObj.i3">TCPNetObj</A>;

FROM <A HREF="LockOps.i3">LockOps</A> IMPORT SiteName;
FROM <A HREF="PkgErr.i3">PkgErr</A> IMPORT ImportError;

VAR
  default: T := NIL;
  defaultSite: SiteName := NIL;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (site: SiteName): T
    RAISES {PkgErr.E, NetObj.Error, Thread.Alerted} =
  VAR rem: Site.Remote;
  VAR obj: NetObj.T;
      siteT: Site.T;
      loc: NetObj.Address;
      addr: IP.Address;
  BEGIN
    IF (site = NIL) OR Text.Empty(site) THEN
      IF default # NIL THEN RETURN default; END;
    ELSE
      IF (default # NIL) AND Text.Equal(site, defaultSite) THEN
        RETURN default;
      END;
    END;
    TRY
      siteT := Site.Get();
      IF (site = NIL) OR Text.Empty(site) OR Text.Equal(site, siteT.name) THEN
        IF siteT.ipPort = IP.NullPort THEN
          loc := NetObj.Locate(siteT.siphonserver);
        ELSE
          IF NOT IP.GetHostByName(siteT.siphonserver, addr) THEN
            PkgErr.Raise(ImportError);
          END;
          loc := TCPNetObj.Locate(IP.Endpoint{addr, siteT.ipPort});
        END;
      ELSE
        IF NOT Site.FindRemote(site, rem) THEN
          PkgErr.Raise(PkgErr.NoSuchSite);
        END;
        IF rem.ipPort = IP.NullPort THEN
          loc := NetObj.Locate(rem.siphonserver);
        ELSE
          IF NOT IP.GetHostByName(rem.siphonserver, addr) THEN
            PkgErr.Raise(ImportError);
          END;
          loc := TCPNetObj.Locate(IP.Endpoint{addr, rem.ipPort});
        END;
      END;
      obj := NetObj.Import(SiphonExportName, loc);
    EXCEPT
    | IP.Error(ipErr) =&gt; PkgErr.Raise(ImportError, ipErr);
    | NetObj.Invalid =&gt; PkgErr.Raise(ImportError);
    END;
    IF (obj = NIL) OR NOT ISTYPE(obj, T) THEN
      PkgErr.Raise(ImportError);
    END;
    RETURN NARROW(obj, T);
  END New;

PROCEDURE <A NAME="SetServerT"><procedure>SetServerT</procedure></A>(t: T; site: SiteName) =
  BEGIN
    default := t;
    defaultSite := site;
  END SetServerT;

BEGIN
END Siphon.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
