<HTML>
<HEAD>
<TITLE>SRC Modula-3: pkgobj/src/Common/Site.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>pkgobj/src/Common/Site.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Site.i3 </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="Site.m3">Site</A></interface>;

IMPORT <A HREF="../../../tcp/src/common/IP.i3">IP</A>, <A HREF="NetPath.i3">NetPath</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;

TYPE Int32  = BITS 32 FOR [-16_7FFFFFFF-1..16_7FFFFFFF];

TYPE
  T = REF RECORD
    name: TEXT;
    lockserver: TEXT;
    siphonserver: TEXT;
    ipPort: BITS 32 FOR IP.Port;
       (* if not IP.NullPort, then servers in this site
          will listen on the named well-known IP port ...
          server names must map into IP addresses by the
          standard Unix gethostbyname trick. *)
       (* otherwise, depend on the NetObj runtime to decide
          upon a transport and how to map names to addresses *)
    padding: Int32;  (* for pickle weirdness *)
    replicas: REF ARRAY OF TEXT;
    backupHosts: REF ARRAY OF TEXT;
    owner: TEXT;
    defaultRepository: NetPath.T;
    foreignSites: REF ARRAY OF Remote;
  END;

  Remote = RECORD
    name: TEXT;
    siphonserver: TEXT;
    ipPort: BITS 32 FOR IP.Port;
    padding: Int32;  (* for pickle weirdness *)
    route: REF ARRAY OF TEXT;
    (* if non-NIL, &quot;route&quot; specifies set of sites through
       which one gets to the destination site *)
  END;

CONST EnvVarName = &quot;SIPHON_SITE&quot;;
   (* This environment variable is used to specify how the packagetools
      find configuration information.  Each siphon and packageserver
      export an object from which such information can be obtained.
      The environment variable names the network address where a
      site info object might be found.

      (Package and siphon servers always read from a configuration
      file and therefore this environment variable has no effect
      upon them.)

      The recognized formats for the environment string are as follows:

            hostname          (e.g. aspen or aspen.pa.dec.com)
            hostname:tcpport  (e.g. aspen.pa.dec.com:5555)

      The former directs the Network Object runtime to interpret
      &quot;hostname&quot; according to the specification of NetObj.Locate.
      The latter indicates that hostname is an Internet host name
      and that the TCP transport should be used to a well-known
      port. *)

TYPE EC = {
   MissingEnvVariable,
   InfoServerUnavailable,
   BadInfoServerSpec,
   BadIPPortSpec
 };

EXCEPTION Error(EC);

PROCEDURE <A HREF="Site.m3#Init">Init</A>() : T RAISES {Error, Thread.Alerted};
    (* init must be called first, error code indicates problem *)

PROCEDURE <A HREF="Site.m3#Get">Get</A>(cacheOK: BOOLEAN := TRUE): T;

PROCEDURE <A HREF="Site.m3#FindRemote">FindRemote</A>(
      site: TEXT;
      VAR (*OUT*) remote: Remote;
      cacheOK: BOOLEAN := FALSE) : (*found*) BOOLEAN;
      (* returns FALSE if the argument site doesn't exist. *)

PROCEDURE <A HREF="Site.m3#ErrMsg">ErrMsg</A>(ec: EC) : TEXT;

END Site.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
