<HTML>
<HEAD>
<TITLE>SRC Modula-3: pkgobj/src/POSIX/osf/FileSysExtra.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>pkgobj/src/POSIX/osf/FileSysExtra.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> FileSysExtra.m3 </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module>FileSysExtra</module> EXPORTS <A HREF="../../Common/FileSys.i3"><implements>FileSys</A></implements>;

IMPORT <A HREF="../../../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="../../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../../os/src/POSIX/OSErrorPosix.i3">OSErrorPosix</A>, <A HREF="Umount.i3">Umount</A>;

FROM <A HREF="../../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int;

PROCEDURE <A NAME="FreeDiskSpace"><procedure>FreeDiskSpace</procedure></A>(fn: FN) : CARDINAL RAISES {OSError.E} =
  VAR
    status: int;
    p := M3toC.TtoS(fn);
    fs: Umount.struct_statfs;
  BEGIN
    status := Umount.statfs (
      p, LOOPHOLE(ADR(fs), Umount.struct_statfs_star), BYTESIZE(fs));
    IF status = -1 THEN OSErrorPosix.Raise(); END;
    RETURN MAX(fs.f_bfree, 0);
  END FreeDiskSpace;

BEGIN
END FileSysExtra.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
