<HTML>
<HEAD>
<TITLE>SRC Modula-3: pqueue/src/PQueue.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>pqueue/src/PQueue.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>PQueue</CODE> is a generic interface defining priority queues. A priority queue
   is a multiset of elements. If <CODE>pq</CODE> is a priority queue, we denote its
   multiset by <CODE>mset(pq)</CODE>. The basic priority queue operations are to insert a
   new element into the queue and to delete one of its elements with minimal
   priority value. 

<P><PRE>GENERIC INTERFACE <genericInterface><A HREF="PQueue.mg">PQueue</A></genericInterface>(Priority);
</PRE><BLOCKQUOTE><EM> Where <CODE>Priority.T</CODE> is a type that is not an open array type, and the
   <CODE>Priority</CODE> interface contains:
<P>
<PRE>
      CONST Brand = &lt;text-constant&gt;;
      PROCEDURE Compare(p1, p2: T): [-1..1]
</PRE>
   <CODE>Brand</CODE> must be a text constant. It will be used to construct a brand for
   the opaque types <CODE>PQueue.Elt</CODE> and <CODE>PQueue.Default</CODE>, and any generic types
   instantiated with the <CODE>PQueue</CODE> interface. For a non-generic interface, we
   recommend choosing the name of the interface.
<P>
   <CODE>Compare</CODE> must be a total order. <CODE>Compare</CODE> may be declared with a parameter
   mode of either <CODE>VALUE</CODE> or <CODE>READONLY</CODE>, but not <CODE>VAR</CODE>. </EM></BLOCKQUOTE><PRE>

CONST
  EltBrand = &quot;(PQueueElt &quot; &amp; Priority.Brand &amp; &quot;)&quot;;
  (* The type &quot;PQueue.Elt&quot; is revealed to have the brand &quot;EltBrand&quot;. *)

TYPE
  <A HREF="PQueue.mg#Elt">Elt</A> &lt;: OBJECT
    priority: Priority.T
  END;
</PRE> A <CODE>PQueue.Elt</CODE> is an {\it element\/} of a priority queue. Every element
   <CODE>elt</CODE> has a priority <CODE>elt.priority</CODE>. 

<P><PRE>EXCEPTION Empty; NotInQueue;
</PRE> The <CODE>Empty</CODE> exception is raised when <CODE>mset(pq)</CODE> is empty. The <CODE>NotInQueue</CODE>
   exception is raised if the element to delete or change is not currently in
   the queue. 

<P><PRE>CONST
  Brand = &quot;(PQueue &quot; &amp; Priority.Brand &amp; &quot;)&quot;;
  DefaultBrand = &quot;(Default &quot; &amp; Brand &amp; &quot;)&quot;;
  (* The type &quot;PQueue.Default&quot; is revealed to have the brand &quot;DefaultBrand&quot;. *)

TYPE
  T = OBJECT METHODS
    insert(READONLY elt: Elt);
    delete(elt: Elt) RAISES {NotInQueue};
    size(): CARDINAL;
    min(): Elt RAISES {Empty};
    deleteMin(): Elt RAISES {Empty};
    change(elt: Elt; newP: Priority.T) RAISES {NotInQueue};
  END;
</PRE> Do not instantiate a <CODE>T</CODE>; instead, instantiate one of its subtypes, such as
   the <CODE>Default</CODE> implementation below. The methods have the following
   specifications:
<P>
   The call <CODE>pq.insert(elt)</CODE> adds <CODE>elt</CODE> to <CODE>mset(pq)</CODE>.
<P>
   The call <CODE>pq.delete(elt)</CODE> removes element <CODE>elt</CODE> from the queue.
<P>
   The call <CODE>pq.size()</CODE> returns the number of elements in the queue.
<P>
   The call <CODE>pq.min()</CODE> returns an element in the queue with minimal priority
   value.
<P>
   The assignment <CODE>elt := pq.deleteMin()</CODE> is equivalent to the code
<P>
<PRE>
         elt := pq.min(); pq.delete(elt)
</PRE>
   However, <CODE>deleteMin</CODE> can be implemented more efficiently than by simply
   composing the <CODE>min</CODE> and <CODE>delete</CODE> operations.
<P>
   The call <CODE>pq.change(elt, newP)</CODE> changes the priority of the element <CODE>elt</CODE>
   to <CODE>newP</CODE>. It is equivalent to:
<P>
<PRE>
         pq.delete(elt);
         elt.priority := newP;
         pq.insert(elt)
</PRE>
   However, <CODE>change</CODE> can be implemented more efficiently than by simply
   composing the <CODE>delete</CODE> and <CODE>insert</CODE> operations. 

<P>  <PRE><A HREF="PQueue.mg#Default">Default</A> &lt;: DefaultPub;
  DefaultPub = T OBJECT METHODS
    init(sizeHint: CARDINAL := 10): Default;
    fromArray(READONLY e: ARRAY OF Elt): Default;
    pCompare(READONLY p1, p2: Priority.T): [-1..1]
  END;
</PRE> The type <CODE>PQueue.Default</CODE> is an implementation of priority queues that
   uses a heap represented by an array. This implementation guarantees that
   the <CODE>insert</CODE>, <CODE>delete</CODE>, <CODE>deleteMin</CODE>, and <CODE>change</CODE> operations will take
   <CODE>O(log n)</CODE> time (where <CODE>n</CODE> is the number of elements in the queue), and
   that the <CODE>size</CODE> and <CODE>min</CODE> operations will take <CODE>O(1)</CODE> time.
<P>
   The call <CODE>NEW(PQueue.Default).init(sizeHint)</CODE> creates a new, empty priority
   queue. The <CODE>init</CODE> method resets <CODE>mset(pq)</CODE> of an existing priority queue
   <CODE>pq</CODE> to the empty set.
<P>
   The call <CODE>NEW(PQueue.Default).fromArray(elts)</CODE> creates a new priority
   queue containing the elements <CODE>elts[FIRST(elts)], ..., elts[LAST(elts)]</CODE>.
   Initializing a priority queue in this way takes linear time, whereas
   creating an empty queue and adding the elements to it one at a time takes
   <CODE>O(n log n)</CODE> time in the worst case.
<P>
   By default, the method call <CODE>pq.pCompare(p1, p2)</CODE> returns the result of the
   call <CODE>Priority.Compare(p1, p2)</CODE>. Clients are free to override the
   <CODE>pCompare</CODE> method to change the total order on priorities.
<P>
   For efficiency, a <CODE>PQueue.Default</CODE> is unmonitored: it is up to clients to
   avoid illegal concurrent accesses on its methods. The readonly methods are
   <CODE>size</CODE> and <CODE>min</CODE>. 

<P><PRE>END PQueue.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
