<HTML>
<HEAD>
<TITLE>SRC Modula-3: pqueue/src/PQueue.mg</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>pqueue/src/PQueue.mg</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

GENERIC MODULE <genericModule><A HREF="PQueue.ig">PQueue</A></genericModule>(Priority, PQ, PQRep);
</PRE><BLOCKQUOTE><EM> where <CODE>PQ = PQueue(Priority)</CODE> and <CODE>PQRep = PQueueRep(PQ)</CODE>. </EM></BLOCKQUOTE><PRE>

TYPE
  EltPub = OBJECT
    priority: Priority.T;
  END;

REVEAL
  <A NAME="Elt">Elt</A> = EltPub BRANDED PQ.EltBrand OBJECT
    i: INTEGER := -1;              (* index in heap array; -1 =&gt; not in heap *)
  END;

REVEAL
  PQ.<A NAME="Default">Default</A> = PQRep.DefaultPub BRANDED PQ.DefaultBrand OBJECT
  OVERRIDES
    init := Init;
    fromArray := FromArray;
    insert := Insert;
    delete := Delete;
    size := Size;
    min := Min;
    deleteMin := DeleteMin;
    change := Change;
    pCompare := PCompare;
  END;

PROCEDURE <A NAME="UpHeap"><procedure>UpHeap</procedure></A>(pq: Default; start: Elt) =
  VAR curr := start.i; BEGIN
    WHILE
      curr &gt; 1 AND
      pq.pCompare(start.priority, pq.heap[curr DIV 2].priority) = -1
    DO
      pq.heap[curr] := pq.heap[curr DIV 2];
      pq.heap[curr].i := curr;
      curr := curr DIV 2
    END;
    IF curr # start.i THEN
      pq.heap[curr] := start;
      start.i := curr
    END
  END UpHeap;

PROCEDURE <A NAME="DownHeap"><procedure>DownHeap</procedure></A>(pq: Default; start: Elt) =
  VAR
    curr := start.i;			 (* current array index *)
    startP := start.priority;		 (* priority of filtered element *)
    min: CARDINAL;			 (* index of smallest child *)
    lastInternal := pq.sz DIV 2;	 (* index of last node with children *)
    hp := pq.heap;
  BEGIN
    WHILE curr &lt;= lastInternal DO
      (* set &quot;min&quot; to index of largest child *)
      min := curr * 2;
      IF min &lt; pq.sz AND
         pq.pCompare(hp[min+1].priority, hp[min].priority) = -1
      THEN
        INC(min)
      END;
      (* exit if current node is smaller than smallest child *)
      IF pq.pCompare(startP, hp[min].priority) = -1 THEN EXIT END;
      (* bubble min element up *)
      hp[curr] := hp[min];
      hp[curr].i := curr;
      curr := min
    END;
    hp[curr] := start;
    start.i := curr
  END DownHeap;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(pq: Default; sizeHint: CARDINAL := 10): Default =
  BEGIN
    IF pq.heap = NIL OR sizeHint &gt; LAST(pq.heap^)
      THEN pq.heap := NEW(REF ARRAY OF Elt, sizeHint + 1)
      ELSE FOR i := 1 TO pq.sz DO pq.heap[i] := NIL END
    END;
    pq.sz := 0;
    RETURN pq
  END Init;

PROCEDURE <A NAME="FromArray"><procedure>FromArray</procedure></A>(pq: Default; READONLY e: ARRAY OF Elt): Default =
</PRE><BLOCKQUOTE><EM> Build heap bottom-up. This takes <CODE>O(n)</CODE> time, where <CODE>n</CODE> is <CODE>NUMBER(e)</CODE>. </EM></BLOCKQUOTE><PRE>
  VAR newSz := NUMBER(e); BEGIN
    IF pq.heap = NIL OR newSz &gt; LAST(pq.heap^)
      THEN pq.heap := NEW(REF ARRAY OF Elt, newSz + 1)
      ELSE FOR i := newSz + 1 TO pq.sz DO pq.heap[i] := NIL END;
    END;
    pq.sz := newSz;
    SUBARRAY(pq.heap^, 1, newSz) := e;
    WITH heap = pq.heap DO
      FOR i := 1 TO newSz DO heap[i].i := i END;
      FOR i := (newSz DIV 2) TO 1 BY -1 DO DownHeap(pq, heap[i]) END
    END;
    RETURN pq
  END FromArray;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A>(pq: Default; READONLY elt: Elt) =
  BEGIN
    INC(pq.sz);
    IF pq.sz &gt; LAST(pq.heap^) THEN
      VAR new := NEW(REF ARRAY OF Elt, NUMBER(pq.heap^) * 2); BEGIN
        SUBARRAY(new^, 0, NUMBER(pq.heap^)) := pq.heap^;
        pq.heap := new
      END
    END;
    pq.heap[pq.sz] := elt;
    elt.i := pq.sz;
    UpHeap(pq, elt)
  END Insert;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A>(pq: Default; elt: Elt) RAISES {NotInQueue} =
  BEGIN
    IF elt.i = -1 THEN RAISE NotInQueue END;
    VAR last := pq.heap[pq.sz]; BEGIN
      pq.heap[pq.sz] := NIL; (* to prevent storage leak *)
      DEC(pq.sz);
      IF last # elt THEN
      	pq.heap[elt.i] := last;
      	last.i := elt.i;
      	CASE pq.pCompare(elt.priority, last.priority) OF
      	 -1 =&gt; DownHeap(pq, last)
      	| 0 =&gt; (* SKIP *)
      	| 1 =&gt; UpHeap(pq, last)
      	END
      END
    END;
    elt.i := -1
  END Delete;

PROCEDURE <A NAME="Size"><procedure>Size</procedure></A>(pq: Default): CARDINAL =
  BEGIN RETURN pq.sz END Size;

PROCEDURE <A NAME="Min"><procedure>Min</procedure></A>(pq: Default): Elt RAISES {Empty} =
  BEGIN
    IF pq.sz = 0 THEN RAISE Empty END;
    RETURN pq.heap[1]
  END Min;

PROCEDURE <A NAME="DeleteMin"><procedure>DeleteMin</procedure></A>(pq: Default): Elt RAISES {Empty} =
  VAR res: Elt; BEGIN
    IF pq.sz = 0 THEN RAISE Empty END;
    res := pq.heap[1];
    res.i := -1;
    VAR last := pq.heap[pq.sz]; BEGIN
      pq.heap[pq.sz] := NIL; (* to prevent storage leak *)
      DEC(pq.sz);
      IF pq.sz &gt; 0 THEN
      	pq.heap[1] := last;
      	last.i := 1;
      	DownHeap(pq, last)
      END
    END;
    RETURN res
  END DeleteMin;

PROCEDURE <A NAME="Change"><procedure>Change</procedure></A>(pq: Default; elt: Elt; newP: Priority.T) RAISES {NotInQueue} =
  BEGIN
    IF elt.i = -1 THEN RAISE NotInQueue END;
    VAR oldP := elt.priority; BEGIN
      elt.priority := newP;
      CASE pq.pCompare(oldP, newP) OF
       -1 =&gt; DownHeap(pq, elt)
      | 0 =&gt; (* SKIP *)
      | 1 =&gt; UpHeap(pq, elt)
      END
    END
  END Change;

PROCEDURE <A NAME="PCompare"><procedure>PCompare</procedure></A>(&lt;*UNUSED*&gt; pq: Default; READONLY p1, p2: Priority.T)
  : [-1..1] =
  BEGIN RETURN Priority.Compare(p1, p2) END PCompare;

BEGIN
END PQueue.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
