<HTML>
<HEAD>
<TITLE>SRC Modula-3: pqueue/src/PQueueRep.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>pqueue/src/PQueueRep.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

GENERIC INTERFACE <genericInterface>PQueueRep</genericInterface>(PQ);
</PRE><BLOCKQUOTE><EM> where <CODE>PQ = PQueue(Priority)</CODE>. </EM></BLOCKQUOTE><PRE>

REVEAL PQ.Default &lt;: DefaultPub;

TYPE
  EltsArray = REF ARRAY OF PQ.Elt;

  DefaultPub = PQ.DefaultPub OBJECT
    sz: CARDINAL := 0;                   (* number of elements in heap *)
    heap: EltsArray := NIL;      (* elements stored in heap[1..sz] *)
  END;

END PQueueRep.
</PRE> A <CODE>PQueue.Default</CODE> is represented by a data structure called a {\it heap}.
   A heap is a complete binary tree in which each node has a priority at least
   that of its parent. Hence, the root of the tree has minimal priority.
<P>
   A priority queue <CODE>pq: PQueue.Default</CODE> is {\it valid} (written <CODE>Valid(pq)</CODE>)
   iff <CODE>pq.heap # NIL</CODE>. The methods <CODE>init(pq, sizeHint)</CODE> and <CODE>fromArray(pq,
   e)</CODE> establish <CODE>Valid(pq)</CODE>, and all of the other methods beside <CODE>pCompare</CODE>
   require <CODE>Valid(pq)</CODE>.
<P>
   A valid priority queue <CODE>pq: PQueue.Default</CODE> satisfies the following
   invariants:
<P>
   1. 0 &lt;= pq.sz &lt;= LAST(pq.heap^)
<P>
   2. (forall i: 1 &lt; i &lt;= sz: pq.pCompare(pq.heap[i DIV 2], pq.heap[i]) &lt; 1)
<P>
   The heap is represented by an array <CODE>pq.heap</CODE>, and a count <CODE>pq.size</CODE> of the
   number of elements in the heap. The <CODE>pq.size</CODE> elements are stored in the
   array entries <CODE>pq.heap[1]</CODE> through <CODE>pq.heap[pq.size]</CODE>. The element
   <CODE>pq.heap[1]</CODE> is the root of the heap, and the parent of element <CODE>i</CODE> is the
   element <CODE>i DIV 2</CODE>. The second invariant is the heap invariant: the priority
   of a non-root element is at least that of its parent.
<P>
   For a complete description of priority queues, see <CODE>Algorithms in
   Modula-3</CODE>, Robert Sedgewick, Addison-Wesley Publishing Company, 1993,
   Chapter 11.


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
