<HTML>
<HEAD>
<TITLE>SRC Modula-3: property/src/MProperty.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>property/src/MProperty.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>MProperty</module> EXPORTS <A HREF="MProperty.i3"><implements>MProperty</A></implements>, <A HREF="MPropertyF.i3"><implements>MPropertyF</A></implements>;

IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="PropertyF.i3">PropertyF</A>;

REVEAL
  <A NAME="Set">Set</A> = Set_public BRANDED OBJECT
  OVERRIDES
    put := Put; get := Get; remove := Remove;
  END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(): Set=
  BEGIN
    RETURN NEW(Set, m := NEW(Thread.Mutex));
  END New;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A>(ps: Set; r: REFANY) =
  BEGIN
    LOCK ps.m DO PropertyF.Put(ps, r); END;
  END Put;

PROCEDURE <A NAME="Remove"><procedure>Remove</procedure></A>(ps: Set; tc: CARDINAL) =
  BEGIN
    LOCK ps.m DO PropertyF.Remove(ps, tc) END;
  END Remove;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(ps: Set; tc: CARDINAL): REFANY =
  BEGIN
    LOCK ps.m DO RETURN PropertyF.Get(ps,tc); END;
  END Get;

PROCEDURE <A NAME="RemoveSub"><procedure>RemoveSub</procedure></A>(ps: Set; tc: CARDINAL) =
  BEGIN
    LOCK ps.m DO PropertyF.RemoveSub(ps, tc) END;
  END RemoveSub;

PROCEDURE <A NAME="GetSub"><procedure>GetSub</procedure></A>(ps: Set; tc: CARDINAL): REFANY =
  BEGIN
    LOCK ps.m DO RETURN PropertyF.GetSub(ps,tc); END;
  END GetSub;

BEGIN
END MProperty.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
