<HTML>
<HEAD>
<TITLE>SRC Modula-3: random/src/Common/Random.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>random/src/Common/Random.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created September 1989 by Bill Kalsow                       </EM></BLOCKQUOTE><PRE>
</PRE> Based on Random.def by Mark R. Brown                        

<P> A <CODE>Random.T</CODE> (or just a generator) is a pseudo-random number
   generator.
   \index{pseudo-random number}


<P><PRE>INTERFACE <interface><A HREF="Random.m3">Random</A></interface>;

TYPE
  T = OBJECT METHODS
    integer(min := FIRST(INTEGER);
      max := LAST(INTEGER)): INTEGER;
    real(min := 0.0e+0; max := 1.0e+0): REAL;
    longreal(min := 0.0d+0; max := 1.0d+0): LONGREAL;
    extended(min := 0.0x+0; max := 1.0x+0): EXTENDED;
    boolean(): BOOLEAN
  END;
  <A HREF="Random.m3#Default">Default</A> &lt;: T OBJECT METHODS
    init(fixed := FALSE): Default
  END;
END Random.
</PRE> Individual generators are unmonitored, and all the operations
   have side effects.
  <P>
   The methods provided by a generator <CODE>rand</CODE> are:
<P>
   The call <CODE>rand.integer(a, b)</CODE> returns a uniformly distributed
   <CODE>INTEGER</CODE> in the closed interval <CODE>[a..b]</CODE>.
<P>
   The call <CODE>rand.real(a, b)</CODE> returns a uniformly distributed <CODE>REAL</CODE>
   in the half-open interval <CODE>[a..b)</CODE>.
<P>
   The call <CODE>longreal</CODE> and <CODE>extended</CODE> are like <CODE>real</CODE>, but return
   values of the specified types.
<P>
   The call <CODE>rand.boolean()</CODE> returns a random <CODE>BOOLEAN</CODE> value.
<P>
   It is a checked runtime error if <CODE>min &gt; max</CODE> on any call.
<P>
   <CODE>NEW(Default).init()</CODE> creates and initializes a generator (see
   below for implementation details).  If <CODE>fixed</CODE> is <CODE>TRUE</CODE>, a
   predetermined sequence is used.  If <CODE>fixed</CODE> is <CODE>FALSE</CODE>, <CODE>init</CODE>
   chooses a random seed in such a way that different sequences result
   even if <CODE>init</CODE> is called many times in close proximity.
<P>
\paragraph*{Example.} A good pseudo-random permutation of an array <CODE>a</CODE>
   can be generated as follows:
<P>
<PRE>
      WITH rand = NEW(Random.Default).init() DO
        FOR i := FIRST(a) TO LAST(a) - 1 DO
          WITH j = rand.integer(i, LAST(a)) DO
            <KBD>Exchange </KBD>a[i]<KBD> and </KBD>a[j]<KBD></KBD>
          END
        END
      END
</PRE>
\paragraph*{SRC Modula-3 implementation details.} The object returned
   by a call of <CODE>New(Default).init</CODE> uses an additive generator based
   on Knuth's Algorithm 3.2.2A (see \cite{Knuth:Vol2}).
<P>


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
