<HTML>
<HEAD>
<TITLE>SRC Modula-3: random/src/Common/RandomPerm.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>random/src/Common/RandomPerm.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created September 1989 by Bill Kalsow                       </EM></BLOCKQUOTE><PRE>
</PRE> Based on RandPerm.def by Mark Manasse                       

<P> A <CODE>RandomPerm.T</CODE> (hereinafter a permutation) represents a
   pseudo-random permutation of a finite set of integers <CODE>[0..n-1]</CODE>,
   that is a bijective (one-one and onto) map from the set <CODE>[0..n-1]</CODE>
   to itself.
   <P>
   Formally, a permutation <CODE>p</CODE> has the components:
<P>
<PRE>
       size(p)  <KBD>a nonnegative integer</KBD>
       perm(p)  <KBD>a permutation of the integers </KBD>[0..size(p)-1]<KBD></KBD>
       index(p) <KBD>an integer in the range </KBD>[0..size(p)]<KBD></KBD>
</PRE>
  It is up to the client to serialize access by multiple threads to
  a permutation; the results of concurrent access are undefined.
<P>


<P><PRE>INTERFACE <interface><A HREF="RandomPerm.m3">RandomPerm</A></interface>;

IMPORT <A HREF="Random.i3">Random</A>;

EXCEPTION Exhausted;

TYPE
  T = OBJECT
      METHODS
        size (): CARDINAL;
        (* Returns &quot;size(p)&quot;, the number of elements in the permutation. *)

        index (): CARDINAL;
        (* Returns &quot;index(p)&quot;, the index of the next element in the
           permutation. *)

        copy (): T;
        (* Returns a new permutation &quot;q&quot; with:

|  size(q)  = size(p)
|  perm(q)  = perm(p)
|  index(q) = index(p)

           and the same allocation type as p. *)

        next (): CARDINAL RAISES {Exhausted};
        (* Returns the next element of the permutation &quot;p&quot;.  &quot;next(p)&quot; is
           equivalent to:

|   IF index(p)=size(p) THEN
|     index(p) := 0; RAISE Exhausted
|   END;
|   WITH n = perm(p)(index(p)) DO
|     index(p) := index(p)+1;
|     RETURN n
|   END

           *)
      END;

TYPE
  <A HREF="RandomPerm.m3#LowQuality">LowQuality</A> &lt;:
    T OBJECT METHODS init (n: CARDINAL; r: Random.T): LowQuality; END;

  <A HREF="RandomPerm.m3#HighQuality">HighQuality</A> &lt;:
    T OBJECT METHODS init (n: CARDINAL; r: Random.T): HighQuality; END;
</PRE> The init methods initialize the type to a permutation <CODE>p</CODE> with
   <CODE>size(p)=n</CODE>, <CODE>index(p)=0</CODE>, and <CODE>perm(p)</CODE> containing a pseudo-random
   permutation that depends on <CODE>r</CODE> and the subtype. 

<P> <CODE>HighQuality</CODE> permutations use Algorithm 3.4.2P of Knuth's {\it
    Seminumerical Algorithms} (second edition), and thus require space
    <CODE>O(n)</CODE>.  <CODE>LowQuality</CODE> permutations are not really very random but
    use constant space and work for <CODE>n</CODE> up to <CODE>2^(BITSIZE(INTEGER)-2)-1</CODE>.  

<P><PRE>PROCEDURE <A HREF="RandomPerm.m3#Fill">Fill</A>(VAR(*OUT*) perm: ARRAY OF CARDINAL; r: Random.T);
</PRE><BLOCKQUOTE><EM> Fill <CODE>perm</CODE> with a new high quality permutation of the integers
   <CODE>[0..NUMBER(perm)-1]</CODE>.  </EM></BLOCKQUOTE><PRE>

END RandomPerm.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
