<HTML>
<HEAD>
<TITLE>SRC Modula-3: random/src/Common/RandomPerm.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>random/src/Common/RandomPerm.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> Created September 1989 by Bill Kalsow                       
 Based on RandPerm.mod by Mark Manasse                       

<P>
<P><PRE>MODULE <module><implements><A HREF="RandomPerm.i3">RandomPerm</A></implements></module>;

IMPORT <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="Random.i3">Random</A>;

REVEAL
  <A NAME="HighQuality">HighQuality</A> = T OBJECT
                METHODS
                  init (n: CARDINAL; r: Random.T): HighQuality;
                END
                  BRANDED OBJECT
                  num, count: CARDINAL := 0;
                  deck: REF ARRAY OF CARDINAL;  (* Current permutation *)
                OVERRIDES
                  init  := HQInit;
                  next  := HQNext;
                  copy  := HQCopy;
                  index := HQIndex;
                  size  := HQSize;
                END;

  <A NAME="LowQuality">LowQuality</A> = T OBJECT
               METHODS
                 init (n: CARDINAL; r: Random.T): LowQuality;
               END
                 BRANDED OBJECT
                 num, count: CARDINAL  := 0;
                 state     : INTEGER;  (* Current state *)
                 mult      : INTEGER;  (* Multiplier *)
                 bits: CARDINAL;  (* CEILING(LOG2(num)), or 0 if num=0. *)
               OVERRIDES
                 init  := LQInit;
                 next  := LQNext;
                 copy  := LQCopy;
                 index := LQIndex;
                 size  := LQSize;
               END;

PROCEDURE <A NAME="HQInit"><procedure>HQInit</procedure></A> (t: HighQuality; n: CARDINAL; r: Random.T): HighQuality =
  BEGIN
    t.num := n;
    t.count := n;
    t.deck := NEW(REF ARRAY OF CARDINAL, n);
    Fill(t.deck^, r);
    RETURN t
  END HQInit;

PROCEDURE <A NAME="LQInit"><procedure>LQInit</procedure></A> (t: LowQuality; n: CARDINAL; r: Random.T): LowQuality =
  VAR m, bits: CARDINAL;
  BEGIN
    t.num := n;
    t.count := n;
    IF n = 0 THEN
      t.bits := 0
    ELSE
      m := n - 1;
      bits := 0;
      WHILE m # 0 DO m := m DIV 2; INC(bits) END;
      &lt;*ASSERT (bits &lt;= BITSIZE(INTEGER) - 2) *&gt;
      t.bits := bits;
    END;
    t.state := Word.Plus(Word.Times(r.integer(0), 2), 1);
    t.mult := Word.Plus(Word.Times(r.integer(0), 8), 3);
    IF ((r.integer(0) MOD 2) # 0) THEN INC(t.mult, 2) END;
    RETURN t;
  END LQInit;

PROCEDURE <A NAME="HQNext"><procedure>HQNext</procedure></A> (t: HighQuality): CARDINAL RAISES {Exhausted} =
  BEGIN
    IF t.count = 0 THEN t.count := t.num; RAISE Exhausted END;
    DEC(t.count);
    RETURN t.deck[t.count];
  END HQNext;

PROCEDURE <A NAME="LQNext"><procedure>LQNext</procedure></A> (t: LowQuality): CARDINAL RAISES {Exhausted} =
  VAR res: CARDINAL;
  BEGIN
    IF t.count = 0 THEN t.count := t.num; RAISE Exhausted END;
    DEC(t.count);
    REPEAT
      t.state := Word.Times(t.state, t.mult);
      res := Word.Extract(Word.Plus(t.state, 1), 2, t.bits)
    UNTIL res &lt; t.num;
    RETURN res
  END LQNext;

PROCEDURE <A NAME="HQSize"><procedure>HQSize</procedure></A> (p: HighQuality): CARDINAL =
  BEGIN
    RETURN p.num
  END HQSize;

PROCEDURE <A NAME="HQIndex"><procedure>HQIndex</procedure></A> (p: HighQuality): CARDINAL =
  BEGIN
    RETURN p.num - p.count
  END HQIndex;

PROCEDURE <A NAME="LQSize"><procedure>LQSize</procedure></A> (p: LowQuality): CARDINAL =
  BEGIN
    RETURN p.num
  END LQSize;

PROCEDURE <A NAME="LQIndex"><procedure>LQIndex</procedure></A> (p: LowQuality): CARDINAL =
  BEGIN
    RETURN p.num - p.count
  END LQIndex;

PROCEDURE <A NAME="HQCopy"><procedure>HQCopy</procedure></A> (p: HighQuality): T =
  BEGIN
    RETURN NEW(HighQuality, num := p.num, count := p.count, deck := p.deck)
  END HQCopy;

PROCEDURE <A NAME="LQCopy"><procedure>LQCopy</procedure></A> (p: LowQuality): T =
  BEGIN
    RETURN NEW(LowQuality, num := p.num, count := p.count,
               state := p.state, mult := p.mult, bits := p.bits)
  END LQCopy;

PROCEDURE <A NAME="Fill"><procedure>Fill</procedure></A> (VAR(*OUT*) perm: ARRAY OF CARDINAL;  r: Random.T) =
  VAR j, t: CARDINAL;
  BEGIN
    FOR i := 0 TO LAST(perm) DO perm[i] := i END;
    FOR i := 0 TO LAST(perm) - 1 DO
      j := r.integer (i, LAST(perm));
      IF j # i THEN t := perm[j]; perm[j] := perm[i]; perm[i] := t END
    END
  END Fill;

BEGIN
END RandomPerm.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
