<HTML>
<HEAD>
<TITLE>SRC Modula-3: realgeometry/src/RealPath.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>realgeometry/src/RealPath.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> Contributed by Michel Dagenais (dagenais@vlsi.polymtl.ca), 1994. 

<P><PRE>&lt;*PRAGMA LL*&gt;
</PRE> Hacked up from Path.i3---see that file for authors. 

<P> A <CODE>RealPath.T</CODE> is a sequence of straight and curved line segments,
   suitable for converting to a <CODE>Path.T</CODE>---suitable for stroking or
   filling.
<P>
   A {\it segment} is a directed arc in the Cartesian plane determined by
   two cubic polynomials <CODE>h(t)</CODE>, <CODE>v(t)</CODE>, where <CODE>t</CODE> ranges over the interval
   of real numbers <CODE>[0, 1]</CODE>.  The segment is said to {\it start} at <CODE>(h(0),
   v(0))</CODE> and {\it end} at <CODE>(h(1), v(1))</CODE>.  If <CODE>h</CODE> and <CODE>v</CODE> are linear
   functions of <CODE>t</CODE>, then the segment is {\it linear}: it consists of a
   line segment.  If <CODE>h</CODE> and <CODE>v</CODE> are constant functions of <CODE>t</CODE>, then the
   segment is {\it degenerate}: it consists of a single point.
<P>
   The segments of a path are grouped into contiguous {\it subpaths}, which
   can be {\it open} or {\it closed}.  Within a subpath, each segment
   starts where the previous segment ends.  In a closed subpath, the last
   segment ends where the first segment starts.  (This may also happen for
   an open subpath, but this coincidence does not make the subpath closed.)
<P>
   The {\it current point} of a path is the endpoint of the last segment of
   its last subpath, assuming this subpath is open.  If the path is empty
   or if the last subpath is closed, the current point is undefined.
<P>
   The call <CODE>NEW(RealPath.T)</CODE> creates an empty path. 

<P><PRE>INTERFACE <interface><A HREF="RealPath.m3">RealPath</A></interface>;

IMPORT <A HREF="RealTransform.i3">RealTransform</A>, <A HREF="RealPoint.i3">RealPoint</A>, <A HREF="#x1">RealRect</A>;

TYPE
  <A HREF="RealPath.m3#T">T</A> &lt;: PublicT;

  PublicT =
    OBJECT
    METHODS
      init ();
      (* Set &quot;self&quot; to be empty. *)

      moveTo (READONLY p: RealPoint.T);
      (* Extend &quot;self&quot; with a new degenerate segment that starts and ends
         at &quot;p&quot;.  This begins a new subpath. *)

      lineTo (READONLY p: RealPoint.T);
      (* Extend &quot;self&quot; with a linear segment that starts at its current
         point and ends at &quot;p&quot;. *)

      arcTo (READONLY center: RealPoint.T; READONLY radius, ang1, ang2: REAL);
      (* Extend &quot;self&quot; with an arc of a circle, possibly preceded by a
         straight line segment.  The arc is defined by its center, radius,
         start and end angle. *)

      curveTo (READONLY q, r, s: RealPoint.T);
      (* Extend &quot;self&quot; with a curved segment that starts at its current
         point and ends at &quot;s&quot;. *)

      (* &quot;CurveTo&quot; adds a curve that starts from the current point of
         &quot;self&quot; in the direction of &quot;q&quot;, and ends at &quot;s&quot; coming from the
         direction of &quot;r&quot;.  More precisely, let &quot;p&quot; be the current point of
         &quot;self&quot; and let &quot;h(t)&quot; and &quot;v(t)&quot; be the cubic polynomials such
         that

|        (h(0), v(0)) = p
|        (h(1), v(1)) = s
|        (h'(0), v'(0)) = 3 * (q - p)
|        (h'(1), v'(1)) = 3 * (s - r)

         (Where the primes denote differentiation with respect to &quot;t&quot;.)
         Then &quot;CurveTo&quot; adds the segment &quot;(h(t), v(t))&quot; for &quot;t&quot; between
         zero and one.  (This is called the {\it Bezier} arc determined by
         &quot;p&quot;, &quot;q&quot;, &quot;r&quot;, and &quot;s&quot;.) *)

      close ();
      (* Add a linear segment to create a closed loop in &quot;self&quot;. *)

      (* More precisely, let &quot;p&quot; be the current point of &quot;self&quot;, and let
         &quot;q&quot; be last point of &quot;self&quot; that was added by a call to &quot;MoveTo&quot;
         (Thus &quot;q&quot; is the startpoint of the first segment of the last
         subpath of &quot;self&quot;.) &quot;Close&quot; adds a linear segment from &quot;p&quot; to &quot;q&quot;
         and marks the sequence of segments from &quot;q&quot; to the end of the path
         as a closed subpath. *)

      isEmpty (): BOOLEAN;
      (* Returns &quot;TRUE&quot; if &quot;self&quot; is empty. *)

      isClosed (): BOOLEAN;
      (* Returns &quot;TRUE&quot; if path is empty or the last subpath of /self/ is
         closed. *)

      currentPoint (): RealPoint.T
        RAISES {NoCurrentPoint};
      (* Returns the current point of /self/. *)

      (* &quot;LineTo&quot;, &quot;CurveTo&quot;, &quot;Close&quot;, and &quot;CurrentPoint&quot; are checked
         runtime errors if the path has no current point. *)

      translate (READONLY delta: RealPoint.T): T;
      (* The result of translating self by &quot;delta&quot;. *)

      copy (): T;
      (* Returns a newly allocated path with the same contents as
         /self/. *)

      map (map: MapObject);
      (* Apply the appropriate method of &quot;map&quot; to each element of
         &quot;self&quot;. *)

      bbox(READONLY matrix := RealTransform.Identity): RealRect.T;
      (* Return the bounding box of &quot;self&quot; transformed by &quot;matrix&quot;. *)

      nbElement(): CARDINAL;
      (* Return the number of elements (arcs, lines, curves, moves)
         forming the path. Their position will be indexed from 0
         to nbElement -1. *)

      insertElement(e: Element; pos: CARDINAL)
        RAISES {BadPosition};
      (* Insert a new element in the path at the specified position.
         A position of zero inserts before the first element (index 0),
         while a position equal to the number of elements
         appends the new element to the path. *)

      replaceElement(e: Element; pos: CARDINAL)
        RAISES {BadPosition};
      (* Change the element at the specified position. *)

      removeElement(pos: CARDINAL)
        RAISES {BadPosition};
      (* Remove the element at the specified position. *)

      getElement(pos: CARDINAL): Element
        RAISES {BadPosition};
      (* Return the Element found at the specified position in the Path. *)

    END;

TYPE
  MapObject =
    OBJECT
    METHODS
      move (READONLY p: RealPoint.T);
      line (READONLY p: RealPoint.T);
      arc (READONLY center: RealPoint.T; READONLY radius, ang1, ang2: REAL);
      close ();
      curve (READONLY p, q, r: RealPoint.T)
    END;

  Element = BRANDED OBJECT END;

  LineElem = Element BRANDED OBJECT
    pt: RealPoint.T;
  END;

  MoveElem = Element BRANDED OBJECT
    pt: RealPoint.T;
  END;

  CloseElem = Element BRANDED OBJECT
    pt: RealPoint.T;
  END;

  CurveElem = Element BRANDED OBJECT
    p, q, r: RealPoint.T;
  END;

  ArcElem = Element BRANDED OBJECT
    center: RealPoint.T;
    radius, ang1, ang2: REAL
  END;

EXCEPTION
  BadPosition;
  NoCurrentPoint;

END RealPath.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface RealRect is in:
</A><UL>
<LI><A HREF="../../mg/src/RealRect.i3#0TOP0">mg/src/RealRect.i3</A>
<LI><A HREF="RealRect.i3#0TOP0">realgeometry/src/RealRect.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
