<HTML>
<HEAD>
<TITLE>SRC Modula-3: realgeometry/src/RealPath.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>realgeometry/src/RealPath.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                   </EM></BLOCKQUOTE><PRE>
</PRE> Contributed by Michel Dagenais (dagenais@vlsi.polymtl.ca), 1994. 

<P> After Path.m3---see that file for authors. 

<P><PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="RealPath.i3">RealPath</A></implements></module>;

IMPORT <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="RealTransform.i3">RealTransform</A>, <A HREF="RealPoint.i3">RealPoint</A>, <A HREF="#x1">RealRect</A>;

CONST
  PATH_INITIAL_ELEMENTS = 1;
  PATH_GROWTH_FACTOR = 1.61;		 (* The golden gizmo *)

TYPE
  ElemList = REF ARRAY OF Element;

REVEAL
  <A NAME="T">T</A> = PublicT BRANDED OBJECT
    elemList: ElemList := NIL;		 (* Empty path *)
    nextElement := 0;			 (* Where to place the next element *)
  OVERRIDES
    init := Init;
    moveTo := MoveTo;
    lineTo := LineTo;
    arcTo := ArcTo;
    curveTo := CurveTo;
    close := Close;
    isEmpty := IsEmpty;
    translate := Translate;
    map := Map;
    bbox := BBox;
    nbElement := NbElement;
    insertElement := InsertElement;
    replaceElement := ReplaceElement;
    removeElement := RemoveElement;
    getElement := GetElement;
    currentPoint := CurrentPoint;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(self: T) =
  BEGIN
    self.elemList := NIL;
    self.nextElement := 0;
  END Init;

PROCEDURE <A NAME="MoveTo"><procedure>MoveTo</procedure></A>(self: T; READONLY pt: RealPoint.T) =
  BEGIN
    Append(self, NEW(MoveElem, pt := pt));
  END MoveTo;

PROCEDURE <A NAME="LineTo"><procedure>LineTo</procedure></A>(self: T; READONLY pt: RealPoint.T) =
  BEGIN
    Append(self, NEW(LineElem, pt := pt));
  END LineTo;

PROCEDURE <A NAME="ArcTo"><procedure>ArcTo</procedure></A>(self: T;
                READONLY center: RealPoint.T;
                READONLY radius, ang1, ang2: REAL) =
  BEGIN
    Append(self, NEW(ArcElem, center := center, radius := radius, ang1 := ang1, ang2 := ang2));
  END ArcTo;

PROCEDURE <A NAME="CurveTo"><procedure>CurveTo</procedure></A>(self: T; READONLY p, q, r: RealPoint.T) =
  BEGIN
    Append(self, NEW(CurveElem, p := p, q := q, r := r));
  END CurveTo;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A>(self: T) =
  BEGIN
    Append(self, NEW(CloseElem));
  END Close;

PROCEDURE <A NAME="Append"><procedure>Append</procedure></A>(VAR path: T; READONLY elem: Element) =
  BEGIN
    IF path.elemList = NIL THEN
      path.elemList := NEW(ElemList, PATH_INITIAL_ELEMENTS);
      path.nextElement := 0;
    END; (* if *)

    IF path.nextElement &gt; LAST(path.elemList^) THEN
      VAR
        (* Increase size by at least 1 each time *)
        l := MAX(NUMBER(path.elemList^) + 1,
                 ROUND(FLOAT(NUMBER(path.elemList^)) * PATH_GROWTH_FACTOR));
        newPath := NEW(ElemList, l);
      BEGIN
        SUBARRAY(newPath^, 0, NUMBER(path.elemList^)) := path.elemList^;
        path.elemList := newPath;
      END (* block *)
    END; (* if *)

    path.elemList[path.nextElement] := elem;
    INC(path.nextElement);
  END Append;

PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A>(self: T): BOOLEAN =
  BEGIN
    RETURN self.elemList = NIL OR self.nextElement = 0;
  END IsEmpty;

PROCEDURE <A NAME="CurrentPoint"><procedure>CurrentPoint</procedure></A> (self: T): RealPoint.T
  RAISES {NoCurrentPoint} =
  VAR
    pt: RealPoint.T;
  BEGIN
    IF self.nextElement = 0 THEN RAISE NoCurrentPoint; END;

    TYPECASE self.elemList[self.nextElement - 1] OF
    | MoveElem(e) =&gt;
        RETURN e.pt;
    | LineElem(e) =&gt;
        RETURN e.pt;
    | CloseElem =&gt;
        RAISE NoCurrentPoint;
    | CurveElem(e) =&gt;
        RETURN e.r;
    | ArcElem(e) =&gt;
        pt[0] := e.center[0] + e.radius *
                 FLOAT(Math.cos(DegToRad * FLOAT(e.ang2,LONGREAL)),REAL);
        pt[1] := e.center[1] + e.radius *
                 FLOAT(Math.sin(DegToRad * FLOAT(e.ang2,LONGREAL)),REAL);
        RETURN pt;
    ELSE
      &lt;* ASSERT FALSE *&gt;
    END; (* typecase *)
  END CurrentPoint;

PROCEDURE <A NAME="Translate"><procedure>Translate</procedure></A>(self: T; READONLY delta: RealPoint.T): T =
  VAR
    newPath := Copy(self);
  BEGIN
    FOR i := 0 TO newPath.nextElement - 1 DO
      TYPECASE newPath.elemList[i] OF
      | MoveElem(e) =&gt;
          e.pt := RealPoint.Add(e.pt, delta);
      | LineElem(e) =&gt;
          e.pt := RealPoint.Add(e.pt, delta);
      | CloseElem(e) =&gt;
          e.pt := RealPoint.Add(e.pt, delta);
      | CurveElem(e) =&gt;
          e.p := RealPoint.Add(e.p, delta);
          e.q := RealPoint.Add(e.q, delta);
          e.r := RealPoint.Add(e.r, delta);
      | ArcElem(e) =&gt;
          e.center := RealPoint.Add(e.center, delta);
      ELSE
        &lt;* ASSERT FALSE *&gt;
      END; (* typecase *)
    END; (* for *)

    RETURN newPath;
  END Translate;

PROCEDURE <A NAME="Copy"><procedure>Copy</procedure></A>(self: T): T =
  VAR
    newPath := NEW(T);
  BEGIN
    Init(self);

    FOR i := 0 TO self.nextElement - 1 DO
      TYPECASE self.elemList[i] OF
      | MoveElem(e) =&gt;
          Append(newPath, NEW(MoveElem, pt := e.pt));
      | LineElem(e) =&gt;
          Append(newPath, NEW(LineElem, pt := e.pt));
      | ArcElem(e) =&gt;
          Append(newPath, NEW(ArcElem, center := e.center, radius := e.radius, ang1 := e.ang1, ang2 := e.ang2));
      | CloseElem(e) =&gt;
          Append(newPath, NEW(CloseElem, pt := e.pt));
      | CurveElem(e) =&gt;
          Append(newPath, NEW(CurveElem, p := e.p, q := e.q, r := e.r));
      ELSE
        &lt;* ASSERT FALSE *&gt;
      END; (* typecase *)
    END; (* for *)

    RETURN newPath;
  END Copy;

PROCEDURE <A NAME="Map"><procedure>Map</procedure></A>(self: T; map: MapObject) =
  BEGIN
    FOR i := 0 TO self.nextElement - 1 DO
      TYPECASE self.elemList[i] OF
      | MoveElem(e) =&gt;
          map.move(e.pt);
      | LineElem(e) =&gt;
          map.line(e.pt);
      | CloseElem =&gt;
          map.close();
      | ArcElem(e) =&gt;
          map.arc(e.center, e.radius, e.ang1, e.ang2)
      | CurveElem(e) =&gt;
          map.curve(e.p, e.q, e.r);
      ELSE
        &lt;* ASSERT FALSE *&gt;
      END; (* typecase *)
    END; (* for *)
  END Map;

PROCEDURE <A NAME="BBox"><procedure>BBox</procedure></A>(self: T; READONLY matrix := RealTransform.Identity): RealRect.T =
  VAR
    bounds := RealRect.Empty;
    min, max : RealPoint.T;

  PROCEDURE extendBBox(READONLY pt: RealPoint.T) =
    BEGIN
      bounds := RealRect.Extend(bounds, RealTransform.Transform(matrix, pt));
    END extendBBox;

  BEGIN
    FOR i := 0 TO self.nextElement - 1 DO
      TYPECASE self.elemList[i] OF
      | MoveElem(e) =&gt;
          extendBBox(e.pt);
      | LineElem(e) =&gt;
          extendBBox(e.pt);
      | CloseElem =&gt;
      | ArcElem(e) =&gt;
          FindArcBBox(e,min,max);
	  extendBBox(min);
	  extendBBox(max);
      | CurveElem(e) =&gt;
          extendBBox(e.p);
          extendBBox(e.q);
          extendBBox(e.r);
      ELSE
        &lt;* ASSERT FALSE *&gt;
      END; (* typecase *)
    END; (* for *)

    RETURN bounds;
  END BBox;

PROCEDURE <A NAME="FindArcBBox"><procedure>FindArcBBox</procedure></A>(e: ArcElem; VAR min, max: RealPoint.T) =
  VAR
    p1, p2: RealPoint.T;
    ang1 := e.ang1;
    ang2 := e.ang2;
    r: REAL;
  BEGIN
    (* We have a full circle *)
    IF (ang2 - ang1) &gt;= 360.0 THEN
      min[0] := e.center[0] - e.radius;
      min[1] := e.center[1] - e.radius;
      max[0] := e.center[0] + e.radius;
      max[1] := e.center[1] + e.radius;
      RETURN;
    END;

    (* if ang2 is smaller than ang1, add 360 until bigger *)
    IF ang2 &lt; ang1 THEN
      r := FLOAT(CEILING((ang1 - ang2)/360.0),REAL);
      ang2 := ang2 + 360.0 * r;
    END;

    (* normalize for ang1 between 0 and 360 *)
    r := FLOAT(FLOOR(ang1/360.0),REAL);
    ang1 := ang1 - 360.0 * r;
    ang2 := ang2 - 360.0 * r;

    (* get the end points *)
    p1[0] := e.center[0] + e.radius *
             FLOAT(Math.cos(DegToRad * FLOAT(ang1,LONGREAL)),REAL);
    p1[1] := e.center[1] + e.radius *
             FLOAT(Math.sin(DegToRad * FLOAT(ang1,LONGREAL)),REAL);
    p2[0] := e.center[0] + e.radius *
             FLOAT(Math.cos(DegToRad * FLOAT(ang2,LONGREAL)),REAL);
    p2[1] := e.center[1] + e.radius *
             FLOAT(Math.sin(DegToRad * FLOAT(ang2,LONGREAL)),REAL);

    (* start with the end points as bounds *)
    min[0] := MIN(p1[0], p2[0]);
    min[1] := MIN(p1[1], p2[1]);
    max[0] := MAX(p1[0], p2[0]);
    max[1] := MAX(p1[1], p2[1]);

    (* check if we cross any axis direction, in which case the arc
       extends beyond the end point. *)

    IF ang2 &gt; 360.0 THEN max[0] := e.center[0] + e.radius; END;

    IF (ang1 &lt; 90.0)AND(ang2 &gt; 90.0) THEN max[1] := e.center[1] + e.radius;END;

    IF (ang1 &lt; 180.0)AND(ang2 &gt; 180.0) THEN
      min[0] := e.center[0] - e.radius;
    END;

    IF (ang1 &lt; 270.0)AND(ang2 &gt; 270.0) THEN
      min[1] := e.center[1] - e.radius;
    END;

    RETURN

  END FindArcBBox;

PROCEDURE <A NAME="NbElement"><procedure>NbElement</procedure></A>(self: T): CARDINAL =
  BEGIN
    RETURN self.nextElement;
  END NbElement;

PROCEDURE <A NAME="InsertElement"><procedure>InsertElement</procedure></A>(self: T; e: Element; pos: CARDINAL)
  RAISES {BadPosition} =
  BEGIN
    (* it really is a append *)
    IF pos = self.nextElement THEN Append(self,e); RETURN; END;
    (* invalid position *)
    IF pos &gt; self.nextElement THEN RAISE BadPosition; END;

    (* is the vector big enough to add one *)
    IF self.nextElement &gt; LAST(self.elemList^) THEN
      VAR
        (* Increase size by at least 1 each time *)
        l := MAX(NUMBER(self.elemList^) + 1,
                 ROUND(FLOAT(NUMBER(self.elemList^)) * PATH_GROWTH_FACTOR));
        newPath := NEW(ElemList, l);
      BEGIN
        SUBARRAY(newPath^, 0, NUMBER(self.elemList^)) := self.elemList^;
        self.elemList := newPath;
      END (* block *)
    END; (* if *)

    (* Now do the insertion *)

    FOR i := self.nextElement TO pos BY -1 DO
      self.elemList[i] := self.elemList[i-1];
    END;

    self.elemList[pos] := e;
  END InsertElement;

PROCEDURE <A NAME="ReplaceElement"><procedure>ReplaceElement</procedure></A>(self: T; e: Element; pos: CARDINAL)
  RAISES {BadPosition} =
  BEGIN
    (* invalid position *)
    IF pos &gt;= self.nextElement THEN RAISE BadPosition; END;

    self.elemList[pos] := e;
  END ReplaceElement;

PROCEDURE <A NAME="RemoveElement"><procedure>RemoveElement</procedure></A>(self: T; pos: CARDINAL)
  RAISES {BadPosition} =
  BEGIN
    (* invalid position *)
    IF pos &gt;= self.nextElement THEN RAISE BadPosition; END;

    DEC(self.nextElement);

    FOR i := pos TO self.nextElement - 1 DO
      self.elemList[i] := self.elemList[i+1];
    END;

    self.elemList[self.nextElement] := NIL;
  END RemoveElement;

PROCEDURE <A NAME="GetElement"><procedure>GetElement</procedure></A>(self: T; pos: CARDINAL): Element
  RAISES {BadPosition} =
  BEGIN
    (* invalid position *)
    IF pos &gt;= self.nextElement THEN RAISE BadPosition; END;

    RETURN self.elemList[pos];
  END GetElement;

CONST DegToRad = FLOAT(2.0 * Math.Pi / 360.0, LONGREAL);

BEGIN
  &lt;* ASSERT PATH_GROWTH_FACTOR &gt; 0.0 *&gt;
  &lt;* ASSERT PATH_INITIAL_ELEMENTS &gt; 0 *&gt;
END RealPath.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface RealRect is in:
</A><UL>
<LI><A HREF="../../mg/src/RealRect.i3#0TOP0">mg/src/RealRect.i3</A>
<LI><A HREF="RealRect.i3#0TOP0">realgeometry/src/RealRect.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
