<HTML>
<HEAD>
<TITLE>SRC Modula-3: realgeometry/src/RealPoint.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>realgeometry/src/RealPoint.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created on Sep 15 1988 by Jorge Stolfi                      </EM></BLOCKQUOTE><PRE>
</PRE> Contributed by Michel Dagenais (dagenais@vlsi.polymtl.ca), 1994. 

<P><PRE>INTERFACE <interface><A HREF="RealPoint.m3">RealPoint</A></interface>;
</PRE> Real pairs.
<P>
   This interface implements the 2-dimensional vector space R^2. 
   It defines the basic linear operations on real pairs (arrays 
   with 2 REAL components).  See R2x2.i3 and R2IO.i3 for 
   additional operations.  
   <P>
   Index: vectors; reals, vectors of; 
   points; geometry; linear algebra; numerical routines
   <P>


<P>******************************************************************
                                                                  
 WARNING: DO NOT EDIT THIS FILE.  IT WAS GENERATED MECHANICALLY.  
 See the  Makefile for more details.                              
                                                                  
******************************************************************

<P> Taken from the mg library distributed with DEC SRC Modula3 2.11.
   There was no makefile there explaining why it should not be edited.
   Simple cleaning and removing of dependencies with other mg modules
   performed.


<P><PRE>IMPORT <A HREF="../../random/src/Common/Random.i3">Random</A>;

TYPE
  Axis = [0..1];           (* Coordinate selectors *)
  Point = ARRAY Axis OF REAL;  (* A point of R2 *)
  T = Point;

CONST
  Origin = T{0.0, 0.0};
  Ones = T{1.0, 1.0};

PROCEDURE <A HREF="RealPoint.m3#Unit">Unit</A>(i: Axis): T;
  (* The unit vector on the i-th axis. *)

PROCEDURE <A HREF="RealPoint.m3#Equal">Equal</A>(READONLY x, y: T): BOOLEAN;
  (* Equality *)

PROCEDURE <A HREF="RealPoint.m3#IsZero">IsZero</A>(READONLY x: T): BOOLEAN;
  (* TRUE if x = (0 0) *)

PROCEDURE <A HREF="RealPoint.m3#Sum">Sum</A> (READONLY x: T): REAL;
  (* Sum of the coordinates x[i]. *)

PROCEDURE <A HREF="RealPoint.m3#Max">Max</A>(READONLY x: T): REAL;
  (* Maximum of the x[i]. *)

PROCEDURE <A HREF="RealPoint.m3#MaxAbsAxis">MaxAbsAxis</A>(READONLY x: T): Axis;
  (* Index i such that ABS(x[i]) is largest. *)

PROCEDURE <A HREF="RealPoint.m3#Min">Min</A>(READONLY x: T): REAL;
  (* Minimum of the x[i]. *)

PROCEDURE <A HREF="RealPoint.m3#SumSq">SumSq</A>(READONLY x: T): REAL;
  (* Sum of x[i]**2. *)

PROCEDURE <A HREF="RealPoint.m3#L1Norm">L1Norm</A>(READONLY x: T): REAL;
  (* Sum of ABS(x[i]). *)

PROCEDURE <A HREF="RealPoint.m3#Length">Length</A>(READONLY x: T): REAL;
PROCEDURE <A HREF="RealPoint.m3#L2Norm">L2Norm</A>(READONLY x: T): REAL;
  (* Euclidean length (sqrt of sum of x[i]**2). *)

PROCEDURE <A HREF="RealPoint.m3#LInfNorm">LInfNorm</A>(READONLY x: T): REAL;
  (* Maximum of ABS(READONLY x[i]). *)

PROCEDURE <A HREF="RealPoint.m3#L1Dist">L1Dist</A>(READONLY x, y: T): REAL;
  (* L1Norm(Sub(x,y)). *)

PROCEDURE <A HREF="RealPoint.m3#Dist">Dist</A>(READONLY x, y: T): REAL;
PROCEDURE <A HREF="RealPoint.m3#L2Dist">L2Dist</A>(READONLY x, y: T): REAL;
  (* L2Norm(Sub(x,y)). *)

PROCEDURE <A HREF="RealPoint.m3#L2DistSq">L2DistSq</A>(READONLY x, y: T): REAL;
  (* SumSq(Sub(x,y)). *)

PROCEDURE <A HREF="RealPoint.m3#LInfDist">LInfDist</A>(READONLY x, y: T): REAL;
  (* LInfNorm(Sub(x,y)). *)

PROCEDURE <A HREF="RealPoint.m3#RelDist">RelDist</A>(READONLY x, y: T; eps: REAL := 1.0e-37): REAL;
  (* Relative distance between two points, useful in convergence tests.
  The /eps/ parameter specifies the magnitude of the (additive) noise
  in each coordinate.
  The value of RelDist is defined as   max_i rdist(x[i], y[i])  where
|
|    rdist(u,v) =  max(|u-v|-eps, 0) / max(|u|, |v|, eps)
|
  The result is between 0.0 and 2.0. A result below 2.0e-7 means the vectors
  differ only at the roundoff error level. *)

PROCEDURE <A HREF="RealPoint.m3#Dot">Dot</A> (READONLY x, y: T): REAL;
  (* Dot product of vectors x and y. *)

PROCEDURE <A HREF="RealPoint.m3#Cos">Cos</A> (READONLY x, y: T): REAL;
  (* Co-sine of the angle between x and y. *)

PROCEDURE <A HREF="RealPoint.m3#Det">Det</A>(READONLY p0, p1: T): REAL;
  (* Determinant of the matrix with given points as rows *)

PROCEDURE <A HREF="RealPoint.m3#Add">Add</A>(READONLY x, y: T): T;
  (* Vector sum x + y. *)

PROCEDURE <A HREF="RealPoint.m3#Sub">Sub</A>(READONLY x, y: T): T;
  (* Vector difference x - y. *)

PROCEDURE <A HREF="RealPoint.m3#Minus">Minus</A>(READONLY x: T): T;
  (* Negation of all coordinates. *)

PROCEDURE <A HREF="RealPoint.m3#Scale">Scale</A>(alpha: REAL; READONLY x: T): T;
  (* Scalar multiplication alpha * x.  *)

PROCEDURE <A HREF="RealPoint.m3#Shift">Shift</A>(READONLY x: T; delta: REAL): T;
  (* Adds delta to every coordinate of x. *)

PROCEDURE <A HREF="RealPoint.m3#Mix">Mix</A> (READONLY x: T; alpha: REAL; READONLY y: T; beta: REAL): T;
  (* Linear combination x * alpha + y * beta. *)

PROCEDURE <A HREF="RealPoint.m3#Weigh">Weigh</A> (READONLY x, y: T): T;
  (* Returns z such that z[i] = x[i] * y[i]. *)

TYPE Function = PROCEDURE (x: REAL): REAL;

PROCEDURE <A HREF="RealPoint.m3#FMap">FMap</A> (READONLY x: T; F: Function): T;
  (* Returns z such that z[i] = F(x[i]). *)

PROCEDURE <A HREF="RealPoint.m3#Direction">Direction</A>(READONLY x: T): T;
  (* Divides x by Length(x). An error if x = (0 0). *)

PROCEDURE <A HREF="RealPoint.m3#Cross">Cross</A>(READONLY p1: T): T;
  (* Cross product: Det(p, q, r, ...) = Dot(p, Cross(q, r, ...))  *)

PROCEDURE <A HREF="RealPoint.m3#Throw">Throw</A>(lo, hi: REAL; src: Random.T := NIL): T;
  (* Returns a random vector with coordinates independently and
  uniformly distributed between lo (inclusive) and hi (exclusive).
  The &quot;src&quot; parameter is the source of randomness (See Random.def).  *)

PROCEDURE <A HREF="RealPoint.m3#ToText">ToText</A>(READONLY x: T): TEXT;

END RealPoint.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
