<HTML>
<HEAD>
<TITLE>SRC Modula-3: realgeometry/src/RealPoint.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>realgeometry/src/RealPoint.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created on Sep 15 1988 by Jorge Stolfi                      </EM></BLOCKQUOTE><PRE>
</PRE> Contributed by Michel Dagenais (dagenais@vlsi.polymtl.ca), 1994. 

<P><PRE>MODULE <module><implements><A HREF="RealPoint.i3">RealPoint</A></implements></module>;
</PRE>******************************************************************
                                                                  
 WARNING: DO NOT EDIT THIS FILE.  IT WAS GENERATED MECHANICALLY.  
 See the  Makefile for more details.                              
                                                                  
******************************************************************

<P>  ***********************************************************
   Disclaimer: the numerical algorithms were quickly hacked  
     from the Modula-2+ version.  They are not suppose to be 
     the best possible, not even close. There are surely     
     gross blunders, especially in the choice of LONGREAL vs 
     REAL for intermediary results.                          
  ***********************************************************

<P><PRE>IMPORT <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="../../random/src/Common/Random.i3">Random</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>;

PROCEDURE <A NAME="Unit"><procedure>Unit</procedure></A>(i: Axis): T =
  VAR rr: T;
  BEGIN
    rr := Origin;
    rr[i] := 1.0;
    RETURN rr
  END Unit;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A>(READONLY x, y: T): BOOLEAN =
  BEGIN
    RETURN (x[0] = y[0])
      AND  (x[1] = y[1])

  END Equal;

PROCEDURE <A NAME="IsZero"><procedure>IsZero</procedure></A>(READONLY x: T): BOOLEAN =
  BEGIN
    RETURN (x[0] = 0.0)
      AND  (x[1] = 0.0)

  END IsZero;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A>(READONLY x, y: T): T =
  VAR rr: T;
  BEGIN
    rr[0] := x[0] + y[0];
    rr[1] := x[1] + y[1];

    RETURN rr
  END Add;

PROCEDURE <A NAME="Sub"><procedure>Sub</procedure></A>(READONLY x, y: T): T =
  VAR rr: T;
  BEGIN
    rr[0] := x[0] - y[0];
    rr[1] := x[1] - y[1];

    RETURN rr
  END Sub;

PROCEDURE <A NAME="Minus"><procedure>Minus</procedure></A>(READONLY x: T): T =
  VAR rr: T;
  BEGIN
    rr[0] := - x[0];
    rr[1] := - x[1];

    RETURN rr
  END Minus;

PROCEDURE <A NAME="Scale"><procedure>Scale</procedure></A>(alpha: REAL; READONLY x: T): T =
  VAR rr: T;
  BEGIN
    rr[0] := alpha * x[0];
    rr[1] := alpha * x[1];

    RETURN rr
  END Scale;

PROCEDURE <A NAME="Shift"><procedure>Shift</procedure></A>(READONLY x: T; delta: REAL): T =
  VAR rr: T;
  BEGIN
    rr[0] := x[0] + delta;
    rr[1] := x[1] + delta;

    RETURN rr
  END Shift;

PROCEDURE <A NAME="Mix"><procedure>Mix</procedure></A>(READONLY x: T; alpha: REAL; READONLY y: T; beta: REAL): T =
  VAR rr: T;
  BEGIN
    rr[0] := x[0]*alpha + y[0]*beta;
    rr[1] := x[1]*alpha + y[1]*beta;

    RETURN rr
  END Mix;

PROCEDURE <A NAME="Weigh"><procedure>Weigh</procedure></A>(READONLY x, y: T): T =
  VAR rr: T;
  BEGIN
    rr[0] := x[0] * y[0];
    rr[1] := x[1] * y[1];

    RETURN rr
  END Weigh;

PROCEDURE <A NAME="FMap"><procedure>FMap</procedure></A>(READONLY x: T; F: Function): T =
  VAR rr: T;
  BEGIN
    rr[0] := F(x[0]);
    rr[1] := F(x[1]);

    RETURN rr
  END FMap;

PROCEDURE <A NAME="Sum"><procedure>Sum</procedure></A> (READONLY x: T): REAL =
  VAR dd: LONGREAL;
  BEGIN
    dd :=
        FLOAT(x[0], LONGREAL)
      + FLOAT(x[1], LONGREAL)

      ;
    RETURN FLOAT(dd)
  END Sum;

PROCEDURE <A NAME="Max"><procedure>Max</procedure></A>(READONLY x: T): REAL =
  BEGIN

    RETURN MAX(x[0], x[1])

  END Max;

PROCEDURE <A NAME="MaxAbsAxis"><procedure>MaxAbsAxis</procedure></A>(READONLY x: T): Axis =
  VAR
    a: Axis;
  BEGIN
    IF ABS(x[0]) &gt; ABS(x[1]) THEN a := 0 ELSE a := 1 END;

    RETURN a;
  END MaxAbsAxis;

PROCEDURE <A NAME="Min"><procedure>Min</procedure></A>(READONLY x: T): REAL =
  BEGIN

    RETURN MIN(x[0], x[1])

  END Min;

PROCEDURE <A NAME="SumSq"><procedure>SumSq</procedure></A>(READONLY x: T): REAL =
  BEGIN
    RETURN
        x[0] * x[0]
      + x[1] * x[1]

  END SumSq;

PROCEDURE <A NAME="L1Norm"><procedure>L1Norm</procedure></A>(READONLY x: T): REAL =

  BEGIN

    RETURN
        ABS(x[0])
      + ABS(x[1])

  END L1Norm;

PROCEDURE <A NAME="LInfNorm"><procedure>LInfNorm</procedure></A>(READONLY x: T): REAL =

  BEGIN

    RETURN MAX(ABS(x[0]), ABS(x[1]))

  END LInfNorm;

PROCEDURE <A NAME="LInfDist"><procedure>LInfDist</procedure></A>(READONLY x, y: T): REAL =

  BEGIN

    RETURN MAX(ABS(x[0] - y[0]), ABS(x[1] - y[1]))

  END LInfDist;

PROCEDURE <A NAME="L1Dist"><procedure>L1Dist</procedure></A>(READONLY x, y: T): REAL =

  BEGIN

    RETURN
        ABS(x[0] - y[0])
      + ABS(x[1] - y[1])

  END L1Dist;

PROCEDURE <A NAME="Dist"><procedure>Dist</procedure></A>(READONLY x, y: T): REAL =

  BEGIN

    RETURN FLOAT(Math.hypot(FLOAT(x[0] - y[0], LONGREAL), FLOAT(x[1] - y[1], LONGREAL)))

  END Dist;

PROCEDURE <A NAME="L2Dist"><procedure>L2Dist</procedure></A>(READONLY x, y: T): REAL =

  BEGIN

    RETURN FLOAT(Math.hypot(FLOAT(x[0] - y[0], LONGREAL), FLOAT(x[1] - y[1], LONGREAL)))

  END L2Dist;

PROCEDURE <A NAME="L2DistSq"><procedure>L2DistSq</procedure></A>(READONLY x, y: T): REAL =
  VAR t, dd: REAL;
  BEGIN

    t := x[0] - y[0]; dd := t*t;
    t := x[1] - y[1]; dd := dd + t*t;

    RETURN dd
  END L2DistSq;

PROCEDURE <A NAME="RelDist"><procedure>RelDist</procedure></A>(READONLY x, y: T; eps: REAL := 1.0e-37): REAL =
  VAR u, v: REAL;
      s, m: REAL;
  BEGIN
    s := 0.0;
    FOR i := 0 TO 1 DO
      u := x[i]; v := y[i];
      m := MAX(MAX(ABS(u), ABS(v)), eps);
      s := MAX(ABS(u/m - v/m) - eps/m, s);
    END;
    RETURN s
  END RelDist;

PROCEDURE <A NAME="Dot"><procedure>Dot</procedure></A>(READONLY x, y: T): REAL =
  BEGIN
    RETURN FLOAT(
        FLOAT(x[0], LONGREAL) * FLOAT(y[0], LONGREAL)
      + FLOAT(x[1], LONGREAL) * FLOAT(y[1], LONGREAL)

    )
  END Dot;

PROCEDURE <A NAME="Cos"><procedure>Cos</procedure></A> (READONLY x, y: T): REAL =
  VAR xy, xx, yy: LONGREAL;
      tx, ty, mx, my: REAL;
  BEGIN
    (* Compute rescaling factors to avoid spurious overflow: *)

    mx := MAX(ABS(x[0]), ABS(x[1]));
    my := MAX(ABS(y[0]), ABS(y[1]));

    (* Now collect dot product and lengths (rescaled): *)

    tx := x[0]/mx; ty := y[0]/my;
    xx := FLOAT(tx*tx, LONGREAL); yy := FLOAT(ty*ty, LONGREAL);
    xy := FLOAT(tx, LONGREAL)*FLOAT(ty, LONGREAL);

    tx := x[1]/mx; ty := y[1]/my;
    xx := xx + FLOAT(tx*tx, LONGREAL); yy := yy + FLOAT(ty*ty, LONGREAL);
    xy := xy + FLOAT(tx, LONGREAL) * FLOAT(ty, LONGREAL);

    xx := 1.0d0 / Math.sqrt(FLOAT(xx*yy, LONGREAL));
    xx := xx*xy;
    RETURN FLOAT(xx)
  END Cos;

PROCEDURE <A NAME="Length"><procedure>Length</procedure></A>(READONLY x: T): REAL =

  BEGIN

    RETURN FLOAT(Math.hypot(FLOAT(x[0], LONGREAL), FLOAT(x[1], LONGREAL)))

  END Length;

PROCEDURE <A NAME="L2Norm"><procedure>L2Norm</procedure></A>(READONLY x: T): REAL =

  BEGIN

    RETURN FLOAT(Math.hypot(FLOAT(x[0], LONGREAL), FLOAT(x[1], LONGREAL)))

  END L2Norm;

PROCEDURE <A NAME="Direction"><procedure>Direction</procedure></A>(READONLY x: T): T =
  (* !!!!! Should try to avoid spurious overflow by prescaling x *)

  VAR d: REAL;
      rr: T;
  BEGIN

    d := 1.0/FLOAT(Math.hypot(FLOAT(x[0], LONGREAL), FLOAT(x[1], LONGREAL)));

    rr[0] := d*x[0];
    rr[1] := d*x[1];

    RETURN rr
  END Direction;

PROCEDURE <A NAME="Det"><procedure>Det</procedure></A>(READONLY p0, p1: T): REAL =
  (* !!!!!! Should use double precision !!!!!! *)

  BEGIN

    RETURN
      p0[0]*p1[1] - p0[1]*p1[0]

  END Det;

PROCEDURE <A NAME="Cross"><procedure>Cross</procedure></A>(READONLY p1: T): T =
  (* !!!!!! Should use double precision !!!!!! *)
  VAR rr: T;

  BEGIN

    rr[0] :=  p1[1];
    rr[1] := -p1[0];

    RETURN rr
  END Cross;

PROCEDURE <A NAME="Throw"><procedure>Throw</procedure></A>(lo, hi: REAL; src: Random.T := NIL): T =
  VAR rr: T; dd, xx: REAL;
  BEGIN
    IF src = NIL THEN src := NEW(Random.Default).init(); END;
    dd := hi - lo;
    &lt;* ASSERT dd &gt; 0.0 *&gt;
    &lt;* ASSERT dd/MAX(1.0E-25, MAX(ABS(hi), ABS(lo))) &gt; 1.0E-6 *&gt;
    FOR i := 0 TO 1 DO
      REPEAT
        xx := src.real();
      UNTIL xx &gt; 0.0;
      rr[i] := lo + dd*xx
    END;
    RETURN rr
  END Throw;

PROCEDURE <A NAME="ToText"><procedure>ToText</procedure></A>(READONLY x: T): TEXT =
BEGIN
  RETURN
    &quot;(&quot; &amp; Fmt.Real(x[0]) &amp;
    &quot; &quot; &amp; Fmt.Real(x[1]) &amp;

    &quot;)&quot;;
END ToText;

BEGIN
END RealPoint.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
