<HTML>
<HEAD>
<TITLE>SRC Modula-3: realgeometry/src/RealRect.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>realgeometry/src/RealRect.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> Contributed by Michel Dagenais (dagenais@vlsi.polymtl.ca), 1994. 

<P><PRE>MODULE <module><implements><A HREF="#x1">RealRect</A></implements></module>;

IMPORT <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="RealPoint.i3">RealPoint</A>, <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="RealInterval.i3">RealInterval</A>;

TYPE
  RefT = REF T;
  PtrT = UNTRACED REF T;
  RefArrayT = REF ARRAY OF T;
  PtrArrayT = UNTRACED REF ARRAY OF T;

PROCEDURE <A NAME="FromEdges"><procedure>FromEdges</procedure></A> (w, e, n, s: REAL): T RAISES {} =
  VAR r: T;
  BEGIN
    IF (w &gt;= e) OR (n &gt;= s) THEN RETURN Empty;  END;
    r.west := w;
    r.east := e;
    r.north := n;
    r.south := s;
    RETURN r;
  END FromEdges;

PROCEDURE <A NAME="FromAbsEdges"><procedure>FromAbsEdges</procedure></A> (w, e, n, s: REAL): T RAISES {} =
  VAR r: T;
  BEGIN
    IF (w = e) OR (n = s) THEN RETURN Empty;  END;
    IF (w &lt; e) THEN
      r.west := w;
      r.east := e;
    ELSE
      r.west := e;
      r.east := w;
    END;
    IF (n &lt; s) THEN
      r.north := n;
      r.south := s;
    ELSE
      r.north := s;
      r.south := n;
    END;
    RETURN r;
  END FromAbsEdges;

PROCEDURE <A NAME="FromPoint"><procedure>FromPoint</procedure></A> (READONLY p: RealPoint.T): T RAISES {} =
  BEGIN
    RETURN FromEdges (p[0], p[0] + 1.0, p[1], p[1] + 1.0);
  END FromPoint;

PROCEDURE <A NAME="FromCorners"><procedure>FromCorners</procedure></A> (READONLY p, q: RealPoint.T): T RAISES {} =
  BEGIN
    RETURN FromAbsEdges (p[0], q[0], p[1], q[1]);
  END FromCorners;

PROCEDURE <A NAME="FromCorner"><procedure>FromCorner</procedure></A> (READONLY p: RealPoint.T; hor, ver: REAL): T RAISES {} =
  VAR r: T;
  BEGIN
    IF (hor &lt;= 0.0) OR (ver &lt;= 0.0) THEN RETURN Empty;  END;
    r.west := p[0];
    r.east := p[0] + hor;
    r.north := p[1];
    r.south := p[1] + ver;
    RETURN r;
  END FromCorner;

PROCEDURE <A NAME="FromSize"><procedure>FromSize</procedure></A> (hor, ver: REAL): T RAISES {} =
  VAR r: T;
  BEGIN
    IF (hor &lt;= 0.0) OR (ver &lt;= 0.0) THEN RETURN Empty;  END;
    r.west := 0.0;
    r.east := hor;
    r.north := 0.0;
    r.south := ver;
    RETURN r;
  END FromSize;

PROCEDURE <A NAME="Center"><procedure>Center</procedure></A> (READONLY r: T; READONLY p: RealPoint.T): T RAISES {} =
  VAR res: T; h, v: REAL;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    h := p[0] - (r.west + r.east) / 2.0;
    v := p[1] - (r.north + r.south) / 2.0;
    res.west := r.west + h;
    res.east := r.east + h;
    res.north := r.north + v;
    res.south := r.south + v;
    RETURN res
  END Center;

PROCEDURE <A NAME="FromIntervals"><procedure>FromIntervals</procedure></A> (READONLY hor, ver: RealInterval.T): T RAISES {} =
  VAR r: T;
  BEGIN
    IF (hor.lo = hor.hi) OR (ver.lo = ver.hi) THEN RETURN Empty;  END;
    r.west := hor.lo;
    r.east := hor.hi;
    r.north := ver.lo;
    r.south := ver.hi;
    RETURN r;
  END FromIntervals;

PROCEDURE <A NAME="FromAxes"><procedure>FromAxes</procedure></A> (axis: Axis.T; READONLY n, m: RealInterval.T): T RAISES {} =
  VAR r: T;
  BEGIN
    IF (n.lo = n.hi) OR (m.lo = m.hi) THEN RETURN Empty END;
    IF (axis = Axis.T.Hor) THEN
      r.west := n.lo;
      r.east := n.hi;
      r.north := m.lo;
      r.south := m.hi;
    ELSE
      r.west := m.lo;
      r.east := m.hi;
      r.north := n.lo;
      r.south := n.hi;
    END;
    RETURN r
  END FromAxes;

PROCEDURE <A NAME="NorthWest"><procedure>NorthWest</procedure></A> (READONLY r: T): RealPoint.T RAISES {} =
  VAR p: RealPoint.T;
  BEGIN
    p[0] := r.west;
    p[1] := r.north;
    RETURN p;
  END NorthWest;

PROCEDURE <A NAME="NorthEast"><procedure>NorthEast</procedure></A> (READONLY r: T): RealPoint.T RAISES {} =
  VAR p: RealPoint.T;
  BEGIN
    p[0] := r.east;
    p[1] := r.north;
    RETURN p;
  END NorthEast;

PROCEDURE <A NAME="SouthWest"><procedure>SouthWest</procedure></A> (READONLY r: T): RealPoint.T RAISES {} =
  VAR p: RealPoint.T;
  BEGIN
    p[0] := r.west;
    p[1] := r.south;
    RETURN p;
  END SouthWest;

PROCEDURE <A NAME="SouthEast"><procedure>SouthEast</procedure></A> (READONLY r: T): RealPoint.T RAISES {} =
  VAR p: RealPoint.T;
  BEGIN
    p[0] := r.east;
    p[1] := r.south;
    RETURN p;
  END SouthEast;

PROCEDURE <A NAME="GetVertex"><procedure>GetVertex</procedure></A> (v: Vertex; READONLY r: T): RealPoint.T RAISES {} =
  BEGIN
    IF (r.west &gt;= r.east)(* OR (r.north&gt;=r.south) *)  THEN
      RETURN RealPoint.Origin;
    END;
    CASE v OF
      | Vertex.NW =&gt; RETURN NorthWest (r);
      | Vertex.NE =&gt; RETURN NorthEast (r);
      | Vertex.SW =&gt; RETURN SouthWest (r);
      | Vertex.SE =&gt; RETURN SouthEast (r);
    END;
  END GetVertex;

PROCEDURE <A NAME="HorSize"><procedure>HorSize</procedure></A> (READONLY r: T): REAL RAISES {} =
  BEGIN
    RETURN r.east - r.west;
  END HorSize;

PROCEDURE <A NAME="VerSize"><procedure>VerSize</procedure></A> (READONLY r: T): REAL RAISES {} =
  BEGIN
    RETURN r.south - r.north
  END VerSize;

PROCEDURE <A NAME="Size"><procedure>Size</procedure></A> (a: Axis.T; READONLY r: T): REAL RAISES {} =
  BEGIN
    CASE a OF
      | Axis.T.Hor =&gt; RETURN HorSize (r);
      | Axis.T.Ver =&gt; RETURN VerSize (r);
    END;
  END Size;

PROCEDURE <A NAME="DiagSizeSquare"><procedure>DiagSizeSquare</procedure></A> (READONLY r: T): REAL RAISES {} =
  VAR hor, ver: REAL;
  BEGIN
    hor := HorSize (r);
    ver := VerSize (r);
    RETURN hor * hor + ver * ver;
  END DiagSizeSquare;

PROCEDURE <A NAME="Middle"><procedure>Middle</procedure></A> (READONLY r: T): RealPoint.T RAISES {} =
  BEGIN
    RETURN RealPoint.T{(r.west+r.east) / 2.0, (r.north+r.south) / 2.0}
  END Middle;

PROCEDURE <A NAME="PickEdge"><procedure>PickEdge</procedure></A> (READONLY r: T; READONLY p: RealPoint.T): Edge RAISES {} =
  VAR mid, se, q: RealPoint.T; a, b: REAL;
  BEGIN
    mid := Middle (r);
    se := RealPoint.Sub (SouthEast (r), mid);
    q := RealPoint.Sub (p, mid);
    a := se[1] * q[0];
    b := se[0] * q[1];
    IF a &gt;= b THEN
      IF -a &gt;= b THEN RETURN Edge.N ELSE RETURN Edge.E END;
    ELSE
      IF -a &gt;= b THEN RETURN Edge.W ELSE RETURN Edge.S END;
    END;
  END PickEdge;

PROCEDURE <A NAME="PickVertex"><procedure>PickVertex</procedure></A> (READONLY r: T; READONLY p: RealPoint.T): Vertex RAISES {} =
  VAR q: RealPoint.T;
  BEGIN
    q := RealPoint.Sub (p, Middle (r));
    IF q[0] &gt; 0.0 THEN
      IF q[1] &gt; 0.0 THEN RETURN Vertex.SE ELSE RETURN Vertex.NE END;
    ELSE
      IF q[1] &gt; 0.0 THEN RETURN Vertex.SW ELSE RETURN Vertex.NW END;
    END;
  END PickVertex;

PROCEDURE <A NAME="Project"><procedure>Project</procedure></A> (READONLY r: T; READONLY p: RealPoint.T): RealPoint.T RAISES {} =
  VAR res: RealPoint.T;
  BEGIN
    &lt;* ASSERT r.east &gt; r.west *&gt;
    res[0] := MAX (MIN (p[0], r.east), r.west);
    res[1] := MAX (MIN (p[1], r.south), r.north);
    RETURN res
  END Project;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A> (READONLY r: T; READONLY p: RealPoint.T): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.west := r.west + p[0];
    s.east := r.east + p[0];
    s.north := r.north + p[1];
    s.south := r.south + p[1];
    RETURN s;
  END Add;

PROCEDURE <A NAME="Sub"><procedure>Sub</procedure></A> (READONLY r: T; READONLY p: RealPoint.T): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.west := r.west - p[0];
    s.east := r.east - p[0];
    s.north := r.north - p[1];
    s.south := r.south - p[1];
    RETURN s;
  END Sub;

PROCEDURE <A NAME="Move"><procedure>Move</procedure></A> (READONLY r: T; READONLY p: RealPoint.T): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.west := r.west + p[0];
    s.east := r.east + p[0];
    s.north := r.north + p[1];
    s.south := r.south + p[1];
    RETURN s;
  END Move;

PROCEDURE <A NAME="MoveH"><procedure>MoveH</procedure></A> (READONLY r: T; h: REAL): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.west := r.west + h;
    s.east := r.east + h;
    s.north := r.north;
    s.south := r.south;
    RETURN s;
  END MoveH;

PROCEDURE <A NAME="MoveV"><procedure>MoveV</procedure></A> (READONLY r: T; v: REAL): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.west := r.west;
    s.east := r.east;
    s.north := r.north + v;
    s.south := r.south + v;
    RETURN s;
  END MoveV;

PROCEDURE <A NAME="MoveHV"><procedure>MoveHV</procedure></A> (READONLY r: T; h: REAL; v: REAL): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.west := r.west + h;
    s.east := r.east + h;
    s.north := r.north + v;
    s.south := r.south + v;
    RETURN s;
  END MoveHV;

PROCEDURE <A NAME="Scale"><procedure>Scale</procedure></A> (READONLY r: T; num, den: REAL): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s.north := (r.north * num) / den;
    s.south := (r.south * num) / den;
    IF s.north &gt;= s.south THEN
      RETURN Empty
    ELSE
      s.west := (r.west * num) / den;
      s.east := (r.east * num) / den;
      IF s.west &gt;= s.east THEN RETURN Empty END;
      RETURN s
    END;
  END Scale;

PROCEDURE <A NAME="Inset"><procedure>Inset</procedure></A> (READONLY r: T; n: REAL): T RAISES {} =
  VAR s: T;
  BEGIN
    IF (r.west &gt;= r.east) OR (r.north &gt;= r.south) THEN RETURN Empty END;
    s.west := r.west + n;
    s.east := r.east - n;
    s.north := r.north + n;
    s.south := r.south - n;
    IF (s.west &gt;= s.east) OR (s.north &gt;= s.south) THEN RETURN Empty;  END;
    RETURN s;
  END Inset;

PROCEDURE <A NAME="Change"><procedure>Change</procedure></A> (READONLY r: T; dw, de, dn, ds: REAL): T RAISES {} =
  VAR s: T;
  BEGIN
    IF (r.west &gt;= r.east) OR (r.north &gt;= r.south) THEN RETURN Empty;  END;
    s.west := r.west + dw;
    s.east := r.east + de;
    s.north := r.north + dn;
    s.south := r.south + ds;
    IF (s.west &gt;= s.east) OR (s.north &gt;= s.south) THEN RETURN Empty;  END;
    RETURN s;
  END Change;

PROCEDURE <A NAME="MoveEdge"><procedure>MoveEdge</procedure></A> (READONLY r: T; e: Edge; dn: REAL): T RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s := r;
    CASE e OF
      | Edge.W =&gt; s.west := r.west + dn;
      | Edge.E =&gt; s.east := r.east + dn;
      | Edge.N =&gt; s.north := r.north + dn;
      | Edge.S =&gt; s.south := r.south + dn;
    END;
    IF (s.west &gt;= s.east) OR (s.north &gt;= s.south) THEN RETURN Empty;  END;
    RETURN s;
  END MoveEdge;

PROCEDURE <A NAME="MoveVertex"><procedure>MoveVertex</procedure></A> (READONLY r: T; v: Vertex; READONLY dp: RealPoint.T): T
  RAISES {} =
  VAR s: T;
  BEGIN
    IF r.west &gt;= r.east THEN RETURN Empty END;
    s := r;
    CASE v OF
    | Vertex.NW =&gt; s.west := r.west + dp[0]; s.north := r.north + dp[1];
    | Vertex.NE =&gt; s.east := r.east + dp[0]; s.north := r.north + dp[1];
    | Vertex.SW =&gt; s.west := r.west + dp[0]; s.south := r.south + dp[1];
    | Vertex.SE =&gt; s.east := r.east + dp[0]; s.south := r.south + dp[1];
    END;
    IF (s.west &gt;= s.east) OR (s.north &gt;= s.south) THEN RETURN Empty;  END;
    RETURN s;
  END MoveVertex;

PROCEDURE <A NAME="Stretch"><procedure>Stretch</procedure></A> (READONLY r: T; axis: Axis.T; lo, hi: REAL): T RAISES {} =
  VAR res: T;
  BEGIN
    IF (r.west &gt;= r.east) OR lo &gt;= hi THEN RETURN Empty;  END;
    IF axis = Axis.T.Hor THEN
      res.north := r.north;
      res.south := r.south;
      res.west := lo;
      res.east := hi
    ELSE
      res.north := lo;
      res.south := hi;
      res.west := r.west;
      res.east := r.east
    END;
    RETURN res
  END Stretch;

PROCEDURE <A NAME="Join"><procedure>Join</procedure></A> (READONLY r, s: T): T RAISES {} =
  VAR t: T;
  BEGIN
    IF (r.west &gt;= r.east)(* OR (r.north&gt;=r.south) *)  THEN RETURN s;  END;
    IF (s.west &gt;= s.east)(* OR (s.north&gt;=s.south) *)  THEN RETURN r;  END;
    t.west := MIN (r.west, s.west);
    t.east := MAX (r.east, s.east);
    t.north := MIN (r.north, s.north);
    t.south := MAX (r.south, s.south);
    RETURN t;
  END Join;

PROCEDURE <A NAME="Meet"><procedure>Meet</procedure></A> (READONLY r, s: T): T RAISES {} =
  VAR t: T;
  BEGIN
    t.west := MAX (r.west, s.west);
    t.east := MIN (r.east, s.east);
    IF t.west &gt;= t.east THEN RETURN Empty END;
    t.north := MAX (r.north, s.north);
    t.south := MIN (r.south, s.south);
    IF t.north &gt;= t.south THEN RETURN Empty;  END;
    RETURN t;
  END Meet;

PROCEDURE <A NAME="Extend"><procedure>Extend</procedure></A> (READONLY r: T; READONLY p: RealPoint.T): T RAISES {} =
  BEGIN
    RETURN Join (r, FromPoint (p));
  END Extend;

PROCEDURE <A NAME="Chop"><procedure>Chop</procedure></A>
  (hv: Axis.T; READONLY r: T; n: REAL; VAR s, t: T) RAISES {} =
  BEGIN
    IF (hv = Axis.T.Hor) THEN
      IF n &lt;= r.west THEN
        s := Empty;
        t := r
      ELSIF n &gt;= r.east THEN
        s := r;
        t := Empty
      ELSE
        s.north := r.north;
        s.south := r.south;
        t.north := r.north;
        t.south := r.south;
        s.west := r.west;
        s.east := n;
        t.west := n;
        t.east := r.east
      END
    ELSE
      IF n &lt;= r.north THEN
        s := Empty;
        t := r
      ELSIF n &gt;= r.south THEN
        s := r;
        t := Empty
      ELSE
        s.west := r.west;
        s.east := r.east;
        t.west := r.west;
        t.east := r.east;
        s.north := r.north;
        s.south := n;
        t.north := n;
        t.south := r.south
      END
    END
  END Chop;
</PRE> This is what it really means:
     PROCEDURE Factor(VAR IN r, by: T; VAR f: Partition; dh, dv: REAL)
     RAISES {}; VAR northIndex, westIndex: REAL; mid, temp: T; BEGIN IF dh &gt;
     0 THEN westIndex := 3 ELSE westIndex := 1 END; IF dv &gt; 0 THEN northIndex
     := 4 ELSE northIndex := 0 END; Chop(Axis.Ver, r, by.north, f[northIndex],
     temp); Chop(Axis.Ver, temp, by.south, mid, f[4 - northIndex]);
     Chop(Axis.Hor, mid, by.west, f[westIndex], temp); Chop(Axis.Hor, temp,
     by.east, f[2], f[4 - westIndex]); END Factor;
 

<P><PRE>PROCEDURE <A NAME="Factor"><procedure>Factor</procedure></A> (READONLY r, by: T;  VAR f: Partition;  dh, dv: REAL)
  RAISES {} =
  VAR ix: INTEGER; rw, re, rn, rs, bw, be, bn, bs: REAL; temp: T;
  BEGIN
    bw := by.west;
    be := by.east;
    bn := by.north;
    bs := by.south;
    rw := r.west;
    re := r.east;
    rn := r.north;
    rs := r.south;
    IF bw &gt;= be OR rw &gt;= re THEN
      f[0] := r;
      FOR z := 1 TO 4 DO f[z] := Empty END;
      RETURN
    END;
    IF dv &gt; 0.0 THEN ix := 4 ELSE ix := 0 END;
    IF rn &lt; bn THEN
      WITH z = f[ix] DO z.west := rw; z.east := re; z.north := rn END;
      IF bn &lt; rs THEN
        f[ix].south := bn;
        WITH z = temp DO z.west := rw; z.east := re; z.north := bn END;
        IF bs &lt; rs THEN
          temp.south := bs;
          WITH z = f[4 - ix] DO
            z.west := rw;
            z.east := re;
            z.north := bs;
            z.south := rs
          END
        ELSE
          temp.south := rs;
          f[4 - ix] := Empty
        END
      ELSE
        f[ix].south := rs;
        temp := Empty;
        f[4 - ix] := Empty
      END
    ELSE
      f[ix] := Empty;
      IF rn &lt; bs THEN
        WITH z = temp DO z.west := rw; z.east := re; z.north := rn END;
        IF bs &lt; rs THEN
          temp.south := bs;
          WITH z = f[4 - ix] DO
            z.west := rw;
            z.east := re;
            z.north := bs;
            z.south := rs
          END
        ELSE
          temp.south := rs;
          f[4 - ix] := Empty
        END
      ELSE
        temp := Empty;
        f[4 - ix] := r
      END
    END;
    rw := temp.west;
    re := temp.east;
    rn := temp.north;
    rs := temp.south;
    IF rw &gt;= re THEN
      FOR z := 1 TO 3 DO f[z] := Empty END;
      RETURN
    END;
    IF dh &gt; 0.0 THEN ix := 3 ELSE ix := 1 END;
    IF rw &lt; bw THEN
      WITH z = f[ix] DO z.north := rn; z.south := rs; z.west := rw END;
      IF bw &lt; re THEN
        f[ix].east := bw;
        WITH z = f[2] DO z.north := rn; z.south := rs; z.west := bw END;
        IF be &lt; re THEN
          f[2].east := be;
          WITH z = f[4 - ix] DO
            z.north := rn;
            z.south := rs;
            z.west := be;
            z.east := re
          END
        ELSE
          f[2].east := re;
          f[4 - ix] := Empty
        END
      ELSE
        f[ix].east := re;
        f[2] := Empty;
        f[4 - ix] := Empty
      END
    ELSE
      f[ix] := Empty;
      IF rw &lt; be THEN
        WITH z = f[2] DO z.north := rn; z.south := rs; z.west := rw END;
        IF be &lt; re THEN
          f[2].east := be;
          WITH z = f[4 - ix] DO
            z.north := rn;
            z.south := rs;
            z.west := be;
            z.east := re
          END
        ELSE
          f[2].east := re;
          f[4 - ix] := Empty
        END
      ELSE
        f[2] := Empty;
        f[4 - ix] := temp
      END
    END
  END Factor;

PROCEDURE <A NAME="Mod"><procedure>Mod</procedure></A> (READONLY p: RealPoint.T; READONLY r: T): RealPoint.T RAISES {} =
  VAR q: RealPoint.T; hor, ver: RealInterval.T;
  BEGIN
    &lt;* ASSERT r.west &lt; r.east *&gt;
    hor.lo := r.west;
    hor.hi := r.east;
    ver.lo := r.north;
    ver.hi := r.south;
    q[0] := RealInterval.Mod (p[0], hor);
    q[1] := RealInterval.Mod (p[1], ver);
    RETURN q
  END Mod;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A> (READONLY r, s: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN r = s
  END Equal;

PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A> (READONLY r: T): BOOLEAN RAISES {} =
  BEGIN RETURN (r.west &gt;= r.east) END IsEmpty;

PROCEDURE <A NAME="Member"><procedure>Member</procedure></A> (READONLY p: RealPoint.T; READONLY r: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN (r.west &lt;= p[0]) AND (p[0] &lt; r.east) AND (r.north &lt;= p[1])
    AND (p[1] &lt; r.south);
  END Member;

PROCEDURE <A NAME="Overlap"><procedure>Overlap</procedure></A> (READONLY r, s: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN (MAX (r.west, s.west) &lt; MIN (r.east, s.east))
    AND (MAX (r.north, s.north) &lt; MIN (r.south, s.south));
  END Overlap;

PROCEDURE <A NAME="Subset"><procedure>Subset</procedure></A> (READONLY r, s: T): BOOLEAN RAISES {} =
  BEGIN
    RETURN (r.west &gt;= r.east)
    OR ((r.west &gt;= s.west) AND (r.east &lt;= s.east) AND (r.north &gt;= s.north)
        AND (r.south &lt;= s.south));
  END Subset;

PROCEDURE <A NAME="Congruent"><procedure>Congruent</procedure></A>(READONLY r, s: T): BOOLEAN =
  BEGIN
    RETURN r.east - r.west = s.east - s.west
    AND  r.south - r.north = s.south - s.north
  END Congruent;

PROCEDURE <A NAME="Transpose"><procedure>Transpose</procedure></A>(READONLY r: T; ax := Axis.T.Ver): T =
  BEGIN
    IF ax = Axis.T.Hor THEN
      RETURN r
    ELSE
      RETURN T{r.north,r.south,r.west,r.east}
    END
  END Transpose;

PROCEDURE <A NAME="GlobToLoc"><procedure>GlobToLoc</procedure></A> (READONLY r: T; READONLY p: RealPoint.T): RealPoint.T RAISES {} =
  VAR q: RealPoint.T;
  BEGIN
    q[0] := p[0] - r.west;
    q[1] := p[1] - r.north;
    RETURN q;
  END GlobToLoc;

PROCEDURE <A NAME="LocToGlob"><procedure>LocToGlob</procedure></A> (READONLY r: T; READONLY p: RealPoint.T): RealPoint.T RAISES {} =
  VAR q: RealPoint.T;
  BEGIN
    q[0] := p[0] + r.west;
    q[1] := p[1] + r.north;
    RETURN q;
  END LocToGlob;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (READONLY value: T): RefT =
  VAR r: RefT;
  BEGIN
    r := NEW (RefT);
    r^ := value;
    RETURN r;
  END New;

PROCEDURE <A NAME="NewArray"><procedure>NewArray</procedure></A>
  (size: CARDINAL; READONLY value: T(* := Empty*)): RefArrayT =
  VAR arr: RefArrayT; i: CARDINAL;
  BEGIN
    arr := NEW (RefArrayT, size);
        (* Assumes the allocator initializes to Empty automatically: *)
        (*IF value # Empty THEN *)
    FOR z := 0 TO size - 1 DO i := z; arr[i] := value END;
        (*END;*)
    RETURN arr
  END NewArray;

PROCEDURE <A NAME="UntracedNew"><procedure>UntracedNew</procedure></A> (READONLY value: T): PtrT =
  VAR r: PtrT;
  BEGIN
    r := NEW (PtrT);
    r^ := value;
    RETURN r;
  END UntracedNew;

PROCEDURE <A NAME="UntracedNewArray"><procedure>UntracedNewArray</procedure></A>
  (size: CARDINAL; READONLY value: T(* := Empty*)): PtrArrayT =
  VAR arr: PtrArrayT; i: CARDINAL;
  BEGIN
    arr := NEW (PtrArrayT, size);
        (* Assumes the allocator initializes to Empty automatically: *)
        (*IF value # Empty THEN *)
    FOR z := 0 TO size - 1 DO i := z; arr[i] := value END;
        (*END; *)
    RETURN arr
  END UntracedNewArray;

PROCEDURE <A NAME="Compare"><procedure>Compare</procedure></A> (READONLY a, b: T): INTEGER =
  BEGIN
    IF (a.west &lt; b.west) THEN RETURN  -1 END;
    IF (a.west &gt; b.west) THEN RETURN  +1 END;
    IF (a.east &lt; b.east) THEN RETURN  -1 END;
    IF (a.east &gt; b.east) THEN RETURN  +1 END;
    IF (a.north &lt; b.north) THEN RETURN  -1 END;
    IF (a.north &gt; b.north) THEN RETURN  +1 END;
    IF (a.south &lt; b.south) THEN RETURN  -1 END;
    IF (a.south &gt; b.south) THEN RETURN  +1 END;
    RETURN 0;
  END Compare;

PROCEDURE <A NAME="Lt"><procedure>Lt</procedure></A> (READONLY a, b: T): BOOLEAN =
  BEGIN
    IF (a.west &lt; b.west) THEN RETURN TRUE END;
    IF (a.west &gt; b.west) THEN RETURN FALSE END;
    IF (a.east &lt; b.east) THEN RETURN TRUE END;
    IF (a.east &gt; b.east) THEN RETURN FALSE END;
    IF (a.north &lt; b.north) THEN RETURN TRUE END;
    IF (a.north &gt; b.north) THEN RETURN FALSE END;
    IF (a.south &lt; b.south) THEN RETURN TRUE END;
    IF (a.south &gt; b.south) THEN RETURN FALSE END;
    RETURN FALSE;
  END Lt;

PROCEDURE <A NAME="Eq"><procedure>Eq</procedure></A> (READONLY a, b: T): BOOLEAN =
  BEGIN
    RETURN Equal (a, b);
  END Eq;

PROCEDURE <A NAME="Hash"><procedure>Hash</procedure></A> (READONLY a: T): INTEGER =
  BEGIN
    RETURN Word.Xor (
             Word.Xor (TRUNC(a.west), TRUNC(a.east)),
             Word.Xor (TRUNC(a.north), TRUNC(a.south)));
  END Hash;

BEGIN
END RealRect.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface RealRect is in:
</A><UL>
<LI><A HREF="../../mg/src/RealRect.i3#0TOP0">mg/src/RealRect.i3</A>
<LI><A HREF="RealRect.i3#0TOP0">realgeometry/src/RealRect.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
