<HTML>
<HEAD>
<TITLE>SRC Modula-3: realgeometry/src/RealTransform.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>realgeometry/src/RealTransform.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                   </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison and Steve Glassman 

<P> Contributed by Michel Dagenais (dagenais@vlsi.polymtl.ca), 1994. 

<P><PRE>INTERFACE <interface><A HREF="RealTransform.m3">RealTransform</A></interface>;
</PRE> A Matrix.T is a simplified representation of a true 3 x 3 matrix.  We
   assume the last column is always {0, 0, 1} so we do not explicitly hold
   it.
<P>
   Here is the layout of the elements of our matrix.  A number is the
   corresponding index into the array, `x' means the element is not held
   explicitly.
<P>
<PRE>
            Column
           0   1   2
         +---+---+---+
        0| 0 | 1 | x |
      R  +---+---+---+
      o 1| 2 | 3 | x |
      w  +---+---+---+
        2| 4 | 5 | x |
         +---+---+---+
</PRE>
   

<P><PRE>IMPORT <A HREF="RealPoint.i3">RealPoint</A>;

TYPE T = ARRAY [0 .. 5] OF REAL;

CONST
  Identity = T{1.0, 0.0,        (* 0.0 *)
               0.0, 1.0,        (* 0.0 *)
               0.0, 0.0};       (* 1.0 *)

PROCEDURE <A HREF="RealTransform.m3#Scale">Scale</A>(READONLY sx, sy: REAL): T;
PROCEDURE <A HREF="RealTransform.m3#Translate">Translate</A>(READONLY tx, ty: REAL): T;
PROCEDURE <A HREF="RealTransform.m3#Rotate">Rotate</A>(READONLY radians: REAL): T;

PROCEDURE <A HREF="RealTransform.m3#Concat">Concat</A>(READONLY m, n: T): T;
PROCEDURE <A HREF="RealTransform.m3#Concat3">Concat3</A>(READONLY l, m, n: T): T;

PROCEDURE <A HREF="RealTransform.m3#Inverse">Inverse</A> (READONLY m: T): T;

PROCEDURE <A HREF="RealTransform.m3#Transform">Transform</A>(READONLY m: T; READONLY p: RealPoint.T): RealPoint.T;

END RealTransform.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
