<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/ALPHA_OSF/old/RTSignal.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/ALPHA_OSF/old/RTSignal.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module><implements><A HREF="#x1">RTSignal</A></implements></module>;

IMPORT <A HREF="../../common/RTMisc.i3">RTMisc</A>, <A HREF="../../common/RTProcess.i3">RTProcess</A>, <A HREF="#x2">Usignal</A>, <A HREF="#x3">Uprocess</A>;
FROM <A HREF="../../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int;

TYPE
  SigInfo = UNTRACED REF Usignal.struct_sigcontext;

VAR
  DefaultHandler: Usignal.SignalHandler;
  IgnoreSignal  : Usignal.SignalHandler;

PROCEDURE <A NAME="InstallHandlers"><procedure>InstallHandlers</procedure></A> () =
  BEGIN
    DefaultHandler := LOOPHOLE (0, Usignal.SignalHandler);
    IgnoreSignal   := LOOPHOLE (1, Usignal.SignalHandler);

    SetHandler (Usignal.SIGHUP,  Shutdown);
    SetHandler (Usignal.SIGINT,  Shutdown);
    SetHandler (Usignal.SIGQUIT, Quit);
    SetHandler (Usignal.SIGBUS,  BusError);
    SetHandler (Usignal.SIGSEGV, SegV);
    SetHandler (Usignal.SIGPIPE, IgnoreSignal);
    SetHandler (Usignal.SIGTERM, Shutdown);
  END InstallHandlers;

PROCEDURE <A NAME="SetHandler"><procedure>SetHandler</procedure></A> (sig: int;  handler: Usignal.SignalHandler) =
  (* Note: we use the LOOPHOLE to prevent the runtime check for
     nested procedure.  The runtime check crashes when
     handler = IgnoreSignal = 1. *)
  VAR new, old: Usignal.struct_sigvec;
  BEGIN
    new.sv_handler := LOOPHOLE (handler, Usignal.SignalHandler);
    new.sv_mask    := Usignal.empty_sv_mask;
    new.sv_flags   := 0;
    EVAL Usignal.sigvec (sig, new, old);
  END SetHandler;

PROCEDURE <A NAME="Shutdown"><procedure>Shutdown</procedure></A> (sig: int; &lt;*UNUSED*&gt; code: int; &lt;*UNUSED*&gt; scp: SigInfo) =
  BEGIN
    RTProcess.InvokeExitors ();                   (* flush stdio... *)
    SetHandler (sig, DefaultHandler);             (* restore default handler *)
    EVAL Usignal.kill (Uprocess.getpid (), sig);  (* and resend the signal *)
  END Shutdown;

PROCEDURE <A NAME="Quit"><procedure>Quit</procedure></A> (&lt;*UNUSED*&gt; sig, code: int; scp: SigInfo) =
  VAR pc := 0;
  BEGIN
    IF (scp # NIL) THEN pc := scp.sc_pc END;
    RTMisc.FatalErrorPC (pc, &quot;aborted&quot;);
  END Quit;

PROCEDURE <A NAME="SegV"><procedure>SegV</procedure></A> (&lt;*UNUSED*&gt; sig, code: int; scp: SigInfo) =
  VAR pc := 0;
  BEGIN
    IF (scp # NIL) THEN pc := scp.sc_pc END;
    RTMisc.FatalErrorPC (pc,
      &quot;Segmentation violation - possible attempt to dereference NIL&quot;);
  END SegV;

PROCEDURE <A NAME="BusError"><procedure>BusError</procedure></A> (&lt;*UNUSED*&gt; sig, code: int; scp: SigInfo) =
  VAR pc := 0;  bad := 0;
  BEGIN
    IF (scp # NIL) THEN  pc  := scp.sc_pc;   bad := scp.sc_badvaddr;  END;
    IF    (bad = -1) THEN CRE (pc, &quot;narrow, assert, return, or case fault&quot;);
    ELSIF (bad = -2) THEN CRE (pc, &quot;range fault&quot;);
    ELSIF (bad = -3) THEN CRE (pc, &quot;open array subscript fault&quot;);
    ELSIF (bad = -4) THEN CRE (pc, &quot;range fault&quot;);
    ELSIF (bad = -5) THEN CRE (pc, &quot;range fault&quot;);
    ELSIF (bad = -6) THEN CRE (pc, &quot;narrow fault (unequal array sizes)&quot;);
    ELSIF (bad = -7) THEN CRE (pc, &quot;attempt to dereference NIL&quot;);
    ELSE RTMisc.FatalErrorPC (pc,&quot;Bus error - possible thread stack overflow&quot;);
    END;
  END BusError;

PROCEDURE <A NAME="CRE"><procedure>CRE</procedure></A> (pc: INTEGER;  msg: TEXT) =
  BEGIN
    RTMisc.FatalErrorPC (pc, &quot;checked runtime error: &quot;, msg);
  END CRE;

BEGIN
END RTSignal.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface RTSignal is in:
</A><UL>
<LI><A HREF="../../AIX386/RTSignal.i3#0TOP0">runtime/src/AIX386/RTSignal.i3</A>
<LI><A HREF="../RTSignal.i3#0TOP0">runtime/src/ALPHA_OSF/RTSignal.i3</A>
<LI><A HREF="../../AP3000/RTSignal.i3#0TOP0">runtime/src/AP3000/RTSignal.i3</A>
<LI><A HREF="../../ARM/RTSignal.i3#0TOP0">runtime/src/ARM/RTSignal.i3</A>
<LI><A HREF="../../DS3100/RTSignal.i3#0TOP0">runtime/src/DS3100/RTSignal.i3</A>
<LI><A HREF="../../HP300/RTSignal.i3#0TOP0">runtime/src/HP300/RTSignal.i3</A>
<LI><A HREF="../../HPPA/RTSignal.i3#0TOP0">runtime/src/HPPA/RTSignal.i3</A>
<LI><A HREF="../../IBMR2/RTSignal.i3#0TOP0">runtime/src/IBMR2/RTSignal.i3</A>
<LI><A HREF="../../IBMRT/RTSignal.i3#0TOP0">runtime/src/IBMRT/RTSignal.i3</A>
<LI><A HREF="../../LINUX/RTSignal.i3#0TOP0">runtime/src/LINUX/RTSignal.i3</A>
<LI><A HREF="../../NEXT/RTSignal.i3#0TOP0">runtime/src/NEXT/RTSignal.i3</A>
<LI><A HREF="../../NT386/RTSignal.i3#0TOP0">runtime/src/NT386/RTSignal.i3</A>
<LI><A HREF="../../OKI/RTSignal.i3#0TOP0">runtime/src/OKI/RTSignal.i3</A>
<LI><A HREF="../../SEQUENT/RTSignal.i3#0TOP0">runtime/src/SEQUENT/RTSignal.i3</A>
<LI><A HREF="../../SOLgnu/RTSignal.i3#0TOP0">runtime/src/SOLgnu/RTSignal.i3</A>
<LI><A HREF="../../SOLsun/RTSignal.i3#0TOP0">runtime/src/SOLsun/RTSignal.i3</A>
<LI><A HREF="../../SPARC/RTSignal.i3#0TOP0">runtime/src/SPARC/RTSignal.i3</A>
<LI><A HREF="../../SUN3/RTSignal.i3#0TOP0">runtime/src/SUN3/RTSignal.i3</A>
<LI><A HREF="../../SUN386/RTSignal.i3#0TOP0">runtime/src/SUN386/RTSignal.i3</A>
<LI><A HREF="../../UMAX/RTSignal.i3#0TOP0">runtime/src/UMAX/RTSignal.i3</A>
<LI><A HREF="../../VAX/RTSignal.i3#0TOP0">runtime/src/VAX/RTSignal.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Usignal is in:
</A><UL>
<LI><A HREF="../../../../unix/src/aix-3-2/Usignal.i3#0TOP0">unix/src/aix-3-2/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/aix-ps2-1-2/Usignal.i3#0TOP0">unix/src/aix-ps2-1-2/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/hpux-7-0/Usignal.i3#0TOP0">unix/src/hpux-7-0/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/ibm-4-3/Usignal.i3#0TOP0">unix/src/ibm-4-3/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/linux/Usignal.i3#0TOP0">unix/src/linux/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/osf-1.ALPHA_OSF/Usignal.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/osf-1.DS3100/Usignal.i3#0TOP0">unix/src/osf-1.DS3100/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/solaris-2-x/Usignal.i3#0TOP0">unix/src/solaris-2-x/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/sunos-4-x/Usignal.i3#0TOP0">unix/src/sunos-4-x/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/sysv-4.0/Usignal.i3#0TOP0">unix/src/sysv-4.0/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/ultrix-3-1.AP3000/Usignal.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/ultrix-3-1.ARM/Usignal.i3#0TOP0">unix/src/ultrix-3-1.ARM/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/ultrix-3-1.DS3100/Usignal.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/ultrix-3-1.NEXT/Usignal.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/ultrix-3-1.SEQUENT/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/ultrix-3-1.SUN3/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/ultrix-3-1.SUN386/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/ultrix-3-1.UMAX/Usignal.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Usignal.i3</A>
<LI><A HREF="../../../../unix/src/ultrix-3-1.VAX/Usignal.i3#0TOP0">unix/src/ultrix-3-1.VAX/Usignal.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Uprocess is in:
</A><UL>
<LI><A HREF="../../../../unix/src/aix-3-2/Uprocess.i3#0TOP0">unix/src/aix-3-2/Uprocess.i3</A>
<LI><A HREF="../../../../unix/src/aix-ps2-1-2/Uprocess.i3#0TOP0">unix/src/aix-ps2-1-2/Uprocess.i3</A>
<LI><A HREF="../../../../unix/src/hpux-7-0/Uprocess.i3#0TOP0">unix/src/hpux-7-0/Uprocess.i3</A>
<LI><A HREF="../../../../unix/src/ibm-4-3/Uprocess.i3#0TOP0">unix/src/ibm-4-3/Uprocess.i3</A>
<LI><A HREF="../../../../unix/src/linux/Uprocess.i3#0TOP0">unix/src/linux/Uprocess.i3</A>
<LI><A HREF="../../../../unix/src/osf-1.generic/Uprocess.i3#0TOP0">unix/src/osf-1.generic/Uprocess.i3</A>
<LI><A HREF="../../../../unix/src/solaris-2-x/Uprocess.i3#0TOP0">unix/src/solaris-2-x/Uprocess.i3</A>
<LI><A HREF="../../../../unix/src/sunos-4-x/Uprocess.i3#0TOP0">unix/src/sunos-4-x/Uprocess.i3</A>
<LI><A HREF="../../../../unix/src/sysv-4.0/Uprocess.i3#0TOP0">unix/src/sysv-4.0/Uprocess.i3</A>
<LI><A HREF="../../../../unix/src/ultrix-3-1.generic/Uprocess.i3#0TOP0">unix/src/ultrix-3-1.generic/Uprocess.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
