<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/DS3100/RTLoader.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/DS3100/RTLoader.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="#x1">RTLoader</A></implements></module>;
</PRE> BEWARE!  Init is called before types are registered
   or main bodies are initialized (but after RTParams is ready). 

<P>**** NOTE: This module is DS3100/Ultrix specific... 

<P><PRE>IMPORT <A HREF="../common/RTParams.i3">RTParams</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="#x2">Unix</A>, <A HREF="#x3">Uuio</A>, <A HREF="../common/RTMisc.i3">RTMisc</A>;

CONST
  OverlayMagic = 8_407;

TYPE
  AoutHeader = RECORD
    f_magic    : Ctypes.unsigned_short;
    f_nscns    : Ctypes.unsigned_short;
    f_timdat   : Ctypes.long;
    f_symptr   : Ctypes.long;
    f_nsyms    : Ctypes.long;
    f_opthdr   : Ctypes.unsigned_short;
    f_flags    : Ctypes.unsigned_short;
    magic      : Ctypes.short;
    vstamp     : Ctypes.short;
    tsize      : Ctypes.long;
    dsize      : Ctypes.long;
    bsize      : Ctypes.long;
    entry      : Ctypes.long;
    text_start : Ctypes.long;
    data_start : Ctypes.long;
    bss_start  : Ctypes.long;
    gprmask    : Ctypes.long;
    cprmask    : ARRAY [0..3] OF Ctypes.long;
    gp_value   : Ctypes.long;
  END;

TYPE
  SectionHeader = RECORD
    s_name    : ARRAY [0..7] OF Ctypes.char;
    s_paddr   : Ctypes.long;
    s_vaddr   : Ctypes.long;
    s_size    : Ctypes.long;
    s_scnptr  : Ctypes.long;
    s_relptr  : Ctypes.long;
    s_lnnoptr : Ctypes.long;
    s_nreloc  : Ctypes.unsigned_short;
    s_nlnno   : Ctypes.unsigned_short;
    s_flags   : Ctypes.long;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> () =
  VAR
    overlay := RTParams.RawValue (&quot;overlay&quot;);
    hdr      : AoutHeader;
    fd       : INTEGER;
    i        : INTEGER;
    cnt      : INTEGER;
    start    : ADDRESS;
    finish   : INTEGER;
    n_needed : INTEGER;
    p_hdr    : ADDRESS := ADR (hdr);
  BEGIN
    IF (overlay = NIL) THEN RETURN END;

    fd := Unix.open (overlay, Unix.O_RDONLY, 0);
    IF (fd &lt; 0) THEN Die (&quot;unable to open overlay file&quot;) END;
    (* if (fd == -1) { perror(pgm); _exit(1); }; *)

    (* read the a.out header *)
    i := Uuio.read (fd, p_hdr, BYTESIZE (hdr));
    IF (i # BYTESIZE (hdr)) THEN Die (&quot;overlay file header is too short&quot;) END;
    IF (hdr.magic # OverlayMagic) THEN Die (&quot;Bad magic in overlay&quot;) END;

    (* seek to the beginning of the text segment *)
    i := BYTESIZE (hdr) + hdr.f_nscns * BYTESIZE (SectionHeader);
    i := (i + 15) DIV 16 * 16;
    EVAL Unix.lseek (fd, i, Unix.L_SET);

    (* compute the end points of the loaded overlay *)
    cnt := hdr.tsize + hdr.dsize; (* # bytes to read *)
    start := ADR (Unix.end);
    finish := LOOPHOLE (start, INTEGER) + cnt + hdr.bsize;

    (* allocate any more memory that we might need *)
    n_needed := finish - Unix.sbrk (0);
    IF (n_needed &gt; 0) THEN
      i := Unix.sbrk (n_needed);
      IF (i + n_needed &lt; finish) THEN Die (&quot;Break messed up.&quot;) END;
    END;

    (* read the overlay's text and data into memory *)
    i := Uuio.read (fd, start, cnt);
    IF (i # cnt) THEN Die (&quot;overlay text+data segment too short&quot;) END;

    (* close the overlay file *)
    EVAL Unix.close (fd);

    (* initialize the overlay's bss segment *)
    RTMisc.Zero (start+cnt, hdr.bsize);

    (* call the overlay's init code *)
    LOOPHOLE (start, PROCEDURE()) ();
  END Init;

PROCEDURE <A NAME="Die"><procedure>Die</procedure></A> (msg: TEXT) =
  BEGIN
    RTMisc.FatalError (NIL, 0, &quot;dynamic loading failed: &quot;, msg);
  END Die;

BEGIN
END RTLoader.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface RTLoader is in:
</A><UL>
<LI><A HREF="../AIX386/RTLoader.i3#0TOP0">runtime/src/AIX386/RTLoader.i3</A>
<LI><A HREF="../ALPHA_OSF/RTLoader.i3#0TOP0">runtime/src/ALPHA_OSF/RTLoader.i3</A>
<LI><A HREF="../AP3000/RTLoader.i3#0TOP0">runtime/src/AP3000/RTLoader.i3</A>
<LI><A HREF="../ARM/RTLoader.i3#0TOP0">runtime/src/ARM/RTLoader.i3</A>
<LI><A HREF="RTLoader.i3#0TOP0">runtime/src/DS3100/RTLoader.i3</A>
<LI><A HREF="../HP300/RTLoader.i3#0TOP0">runtime/src/HP300/RTLoader.i3</A>
<LI><A HREF="../HPPA/RTLoader.i3#0TOP0">runtime/src/HPPA/RTLoader.i3</A>
<LI><A HREF="../IBMR2/RTLoader.i3#0TOP0">runtime/src/IBMR2/RTLoader.i3</A>
<LI><A HREF="../IBMRT/RTLoader.i3#0TOP0">runtime/src/IBMRT/RTLoader.i3</A>
<LI><A HREF="../LINUX/RTLoader.i3#0TOP0">runtime/src/LINUX/RTLoader.i3</A>
<LI><A HREF="../NEXT/RTLoader.i3#0TOP0">runtime/src/NEXT/RTLoader.i3</A>
<LI><A HREF="../NT386/RTLoader.i3#0TOP0">runtime/src/NT386/RTLoader.i3</A>
<LI><A HREF="../OKI/RTLoader.i3#0TOP0">runtime/src/OKI/RTLoader.i3</A>
<LI><A HREF="../SEQUENT/RTLoader.i3#0TOP0">runtime/src/SEQUENT/RTLoader.i3</A>
<LI><A HREF="../SOLgnu/RTLoader.i3#0TOP0">runtime/src/SOLgnu/RTLoader.i3</A>
<LI><A HREF="../SOLsun/RTLoader.i3#0TOP0">runtime/src/SOLsun/RTLoader.i3</A>
<LI><A HREF="../SPARC/RTLoader.i3#0TOP0">runtime/src/SPARC/RTLoader.i3</A>
<LI><A HREF="../SUN3/RTLoader.i3#0TOP0">runtime/src/SUN3/RTLoader.i3</A>
<LI><A HREF="../SUN386/RTLoader.i3#0TOP0">runtime/src/SUN386/RTLoader.i3</A>
<LI><A HREF="../UMAX/RTLoader.i3#0TOP0">runtime/src/UMAX/RTLoader.i3</A>
<LI><A HREF="../VAX/RTLoader.i3#0TOP0">runtime/src/VAX/RTLoader.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Unix is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Uuio is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uuio.i3#0TOP0">unix/src/aix-3-2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uuio.i3#0TOP0">unix/src/aix-ps2-1-2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uuio.i3#0TOP0">unix/src/hpux-7-0/Uuio.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uuio.i3#0TOP0">unix/src/ibm-4-3/Uuio.i3</A>
<LI><A HREF="../../../unix/src/linux/Uuio.i3#0TOP0">unix/src/linux/Uuio.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uuio.i3#0TOP0">unix/src/osf-1.generic/Uuio.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uuio.i3#0TOP0">unix/src/solaris-2-x/Uuio.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uuio.i3#0TOP0">unix/src/sunos-4-x/Uuio.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uuio.i3#0TOP0">unix/src/sysv-4.0/Uuio.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Uuio.i3#0TOP0">unix/src/ultrix-3-1.generic/Uuio.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
