<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/HP300/RTHeapDep.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/HP300/RTHeapDep.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="#x1">RTHeapDep</A></interface>;

IMPORT <A HREF="../../../word/src/Word.i3">Word</A>;
</PRE> This is the interface to the machine-dependent portion of the traced
   heap allocator and collector. 

<P> The heap page size is machine-dependent, since it might depend on the
   architecture's VM page size (if VM is TRUE).  Otherwise, 8192 bytes is a
   reasonable page size.  The page size must be a power of two. 

<P><PRE>CONST
  BytesPerPage    = 8192;        (* bytes per page *)
  LogBytesPerPage = 13;
  AdrPerPage      = 8192;        (* addresses per page *)
  LogAdrPerPage   = 13;

TYPE Page = [0 .. Word.Divide(-1, AdrPerPage)];
</PRE> The collector supports the use of VM protection to achieve incremental,
   generational collection.  This is not possible on all architectures, and
   it may not be implemented in all cases where it is possible.  The
   boolean constant VM is TRUE iff all necessary support is present for
   this architecture.  VM is TRUE for the DS3100, whose implementation you
   might use as a reference. 

<P><PRE>CONST VM = FALSE;
</PRE> None of the procedures below will be called if VM is FALSE.  The
   descriptions given for each assume that VM is TRUE. 

<P> If VM is TRUE, there must also be machine-dependent code to catch
   all protection faults that might reference the heap, and call
   RTHeap.Fault.  In addition to ordinary instructions that may reference
   heap pages while they are protected, this also includes system calls
   that might fault when reading or writing heap locations. 

<P><PRE>PROCEDURE <A HREF="#x2">Protect</A> (p: Page; n: CARDINAL; readable, writable: BOOLEAN);
</PRE> When pages are allocated from the heap, they are assumed to
   readable and writable, although not executable.  Protect is used to
   change memory protection on heap pages.
<P>
   Protect changes the protection of pages [p..p+n-1] as specified by
   <CODE>readable</CODE> and <CODE>writable</CODE>.  The page remains unexecutable.  If readable
   is FALSE and writable is TRUE, but the architecture does not support
   this combination, it is acceptable for Protect to make the page neither
   readable nor writable.
<P>
   Note that the <CODE>pages</CODE> are heap pages, not VM pages; the locations
   protected are p*BytesPerPage through (p+n)*BytesPerPage-1.  If VM is
   TRUE, BytesPerPage must be at least the VM page size. 

<P><PRE>PROCEDURE <A HREF="#x3">TimeUsed</A> (): REAL;
</PRE> TimeUsed returns the amount of processor time used by the program
   so far, in arbitrary units.  This information is used to tune the
   generational collector. 

<P><PRE>PROCEDURE <A HREF="#x4">VMFaultTime</A> (): REAL;
</PRE> VMFaultTime returns the amount of processor time required to handle
   a VM fault, in the same units as TimeUsed.  This information is used
   to tune the generational collector. 

<P><PRE>END RTHeapDep.
</PRE>
</inInterface>
<HR>
<A NAME="x1">RTHeapDep's implementation  is in:
</A><UL>
<LI><A HREF="../AIX386/RTHeapDep.m3#0TOP0">runtime/src/AIX386/RTHeapDep.m3</A>
<LI><A HREF="../ALPHA_OSF/RTHeapDep.m3#0TOP0">runtime/src/ALPHA_OSF/RTHeapDep.m3</A>
<LI><A HREF="../AP3000/RTHeapDep.m3#0TOP0">runtime/src/AP3000/RTHeapDep.m3</A>
<LI><A HREF="../ARM/RTHeapDep.m3#0TOP0">runtime/src/ARM/RTHeapDep.m3</A>
<LI><A HREF="../DS3100/RTHeapDep.m3#0TOP0">runtime/src/DS3100/RTHeapDep.m3</A>
<LI><A HREF="RTHeapDep.m3#0TOP0">runtime/src/HP300/RTHeapDep.m3</A>
<LI><A HREF="../HPPA/RTHeapDep.m3#0TOP0">runtime/src/HPPA/RTHeapDep.m3</A>
<LI><A HREF="../IBMR2/RTHeapDep.m3#0TOP0">runtime/src/IBMR2/RTHeapDep.m3</A>
<LI><A HREF="../IBMRT/RTHeapDep.m3#0TOP0">runtime/src/IBMRT/RTHeapDep.m3</A>
<LI><A HREF="../LINUX/RTHeapDep.m3#0TOP0">runtime/src/LINUX/RTHeapDep.m3</A>
<LI><A HREF="../NEXT/RTHeapDep.m3#0TOP0">runtime/src/NEXT/RTHeapDep.m3</A>
<LI><A HREF="../NT386/RTHeapDep.m3#0TOP0">runtime/src/NT386/RTHeapDep.m3</A>
<LI><A HREF="../OKI/RTHeapDep.m3#0TOP0">runtime/src/OKI/RTHeapDep.m3</A>
<LI><A HREF="../SEQUENT/RTHeapDep.m3#0TOP0">runtime/src/SEQUENT/RTHeapDep.m3</A>
<LI><A HREF="../SOLgnu/RTHeapDep.m3#0TOP0">runtime/src/SOLgnu/RTHeapDep.m3</A>
<LI><A HREF="../SOLsun/RTHeapDep.m3#0TOP0">runtime/src/SOLsun/RTHeapDep.m3</A>
<LI><A HREF="../SPARC/RTHeapDep.m3#0TOP0">runtime/src/SPARC/RTHeapDep.m3</A>
<LI><A HREF="../SUN3/RTHeapDep.m3#0TOP0">runtime/src/SUN3/RTHeapDep.m3</A>
<LI><A HREF="../SUN386/RTHeapDep.m3#0TOP0">runtime/src/SUN386/RTHeapDep.m3</A>
<LI><A HREF="../UMAX/RTHeapDep.m3#0TOP0">runtime/src/UMAX/RTHeapDep.m3</A>
<LI><A HREF="../VAX/RTHeapDep.m3#0TOP0">runtime/src/VAX/RTHeapDep.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure RTHeapDep.Protect is in:
</A><UL>
<LI><A HREF="../AIX386/RTHeapDep.m3#Protect">runtime/src/AIX386/RTHeapDep.m3</A>
<LI><A HREF="../ALPHA_OSF/RTHeapDep.m3#Protect">runtime/src/ALPHA_OSF/RTHeapDep.m3</A>
<LI><A HREF="../AP3000/RTHeapDep.m3#Protect">runtime/src/AP3000/RTHeapDep.m3</A>
<LI><A HREF="../ARM/RTHeapDep.m3#Protect">runtime/src/ARM/RTHeapDep.m3</A>
<LI><A HREF="../DS3100/RTHeapDep.m3#Protect">runtime/src/DS3100/RTHeapDep.m3</A>
<LI><A HREF="RTHeapDep.m3#Protect">runtime/src/HP300/RTHeapDep.m3</A>
<LI><A HREF="../HPPA/RTHeapDep.m3#Protect">runtime/src/HPPA/RTHeapDep.m3</A>
<LI><A HREF="../IBMR2/RTHeapDep.m3#Protect">runtime/src/IBMR2/RTHeapDep.m3</A>
<LI><A HREF="../IBMRT/RTHeapDep.m3#Protect">runtime/src/IBMRT/RTHeapDep.m3</A>
<LI><A HREF="../LINUX/RTHeapDep.m3#Protect">runtime/src/LINUX/RTHeapDep.m3</A>
<LI><A HREF="../NEXT/RTHeapDep.m3#Protect">runtime/src/NEXT/RTHeapDep.m3</A>
<LI><A HREF="../NT386/RTHeapDep.m3#Protect">runtime/src/NT386/RTHeapDep.m3</A>
<LI><A HREF="../OKI/RTHeapDep.m3#Protect">runtime/src/OKI/RTHeapDep.m3</A>
<LI><A HREF="../SEQUENT/RTHeapDep.m3#Protect">runtime/src/SEQUENT/RTHeapDep.m3</A>
<LI><A HREF="../SOLgnu/RTHeapDep.m3#Protect">runtime/src/SOLgnu/RTHeapDep.m3</A>
<LI><A HREF="../SOLsun/RTHeapDep.m3#Protect">runtime/src/SOLsun/RTHeapDep.m3</A>
<LI><A HREF="../SPARC/RTHeapDep.m3#Protect">runtime/src/SPARC/RTHeapDep.m3</A>
<LI><A HREF="../SUN3/RTHeapDep.m3#Protect">runtime/src/SUN3/RTHeapDep.m3</A>
<LI><A HREF="../SUN386/RTHeapDep.m3#Protect">runtime/src/SUN386/RTHeapDep.m3</A>
<LI><A HREF="../UMAX/RTHeapDep.m3#Protect">runtime/src/UMAX/RTHeapDep.m3</A>
<LI><A HREF="../VAX/RTHeapDep.m3#Protect">runtime/src/VAX/RTHeapDep.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure RTHeapDep.TimeUsed is in:
</A><UL>
<LI><A HREF="../AIX386/RTHeapDep.m3#TimeUsed">runtime/src/AIX386/RTHeapDep.m3</A>
<LI><A HREF="../ALPHA_OSF/RTHeapDep.m3#TimeUsed">runtime/src/ALPHA_OSF/RTHeapDep.m3</A>
<LI><A HREF="../AP3000/RTHeapDep.m3#TimeUsed">runtime/src/AP3000/RTHeapDep.m3</A>
<LI><A HREF="../ARM/RTHeapDep.m3#TimeUsed">runtime/src/ARM/RTHeapDep.m3</A>
<LI><A HREF="../DS3100/RTHeapDep.m3#TimeUsed">runtime/src/DS3100/RTHeapDep.m3</A>
<LI><A HREF="RTHeapDep.m3#TimeUsed">runtime/src/HP300/RTHeapDep.m3</A>
<LI><A HREF="../HPPA/RTHeapDep.m3#TimeUsed">runtime/src/HPPA/RTHeapDep.m3</A>
<LI><A HREF="../IBMR2/RTHeapDep.m3#TimeUsed">runtime/src/IBMR2/RTHeapDep.m3</A>
<LI><A HREF="../IBMRT/RTHeapDep.m3#TimeUsed">runtime/src/IBMRT/RTHeapDep.m3</A>
<LI><A HREF="../LINUX/RTHeapDep.m3#TimeUsed">runtime/src/LINUX/RTHeapDep.m3</A>
<LI><A HREF="../NEXT/RTHeapDep.m3#TimeUsed">runtime/src/NEXT/RTHeapDep.m3</A>
<LI><A HREF="../NT386/RTHeapDep.m3#TimeUsed">runtime/src/NT386/RTHeapDep.m3</A>
<LI><A HREF="../OKI/RTHeapDep.m3#TimeUsed">runtime/src/OKI/RTHeapDep.m3</A>
<LI><A HREF="../SEQUENT/RTHeapDep.m3#TimeUsed">runtime/src/SEQUENT/RTHeapDep.m3</A>
<LI><A HREF="../SOLgnu/RTHeapDep.m3#TimeUsed">runtime/src/SOLgnu/RTHeapDep.m3</A>
<LI><A HREF="../SOLsun/RTHeapDep.m3#TimeUsed">runtime/src/SOLsun/RTHeapDep.m3</A>
<LI><A HREF="../SPARC/RTHeapDep.m3#TimeUsed">runtime/src/SPARC/RTHeapDep.m3</A>
<LI><A HREF="../SUN3/RTHeapDep.m3#TimeUsed">runtime/src/SUN3/RTHeapDep.m3</A>
<LI><A HREF="../SUN386/RTHeapDep.m3#TimeUsed">runtime/src/SUN386/RTHeapDep.m3</A>
<LI><A HREF="../UMAX/RTHeapDep.m3#TimeUsed">runtime/src/UMAX/RTHeapDep.m3</A>
<LI><A HREF="../VAX/RTHeapDep.m3#TimeUsed">runtime/src/VAX/RTHeapDep.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure RTHeapDep.VMFaultTime is in:
</A><UL>
<LI><A HREF="../AIX386/RTHeapDep.m3#VMFaultTime">runtime/src/AIX386/RTHeapDep.m3</A>
<LI><A HREF="../ALPHA_OSF/RTHeapDep.m3#VMFaultTime">runtime/src/ALPHA_OSF/RTHeapDep.m3</A>
<LI><A HREF="../AP3000/RTHeapDep.m3#VMFaultTime">runtime/src/AP3000/RTHeapDep.m3</A>
<LI><A HREF="../ARM/RTHeapDep.m3#VMFaultTime">runtime/src/ARM/RTHeapDep.m3</A>
<LI><A HREF="../DS3100/RTHeapDep.m3#VMFaultTime">runtime/src/DS3100/RTHeapDep.m3</A>
<LI><A HREF="RTHeapDep.m3#VMFaultTime">runtime/src/HP300/RTHeapDep.m3</A>
<LI><A HREF="../HPPA/RTHeapDep.m3#VMFaultTime">runtime/src/HPPA/RTHeapDep.m3</A>
<LI><A HREF="../IBMR2/RTHeapDep.m3#VMFaultTime">runtime/src/IBMR2/RTHeapDep.m3</A>
<LI><A HREF="../IBMRT/RTHeapDep.m3#VMFaultTime">runtime/src/IBMRT/RTHeapDep.m3</A>
<LI><A HREF="../LINUX/RTHeapDep.m3#VMFaultTime">runtime/src/LINUX/RTHeapDep.m3</A>
<LI><A HREF="../NEXT/RTHeapDep.m3#VMFaultTime">runtime/src/NEXT/RTHeapDep.m3</A>
<LI><A HREF="../NT386/RTHeapDep.m3#VMFaultTime">runtime/src/NT386/RTHeapDep.m3</A>
<LI><A HREF="../OKI/RTHeapDep.m3#VMFaultTime">runtime/src/OKI/RTHeapDep.m3</A>
<LI><A HREF="../SEQUENT/RTHeapDep.m3#VMFaultTime">runtime/src/SEQUENT/RTHeapDep.m3</A>
<LI><A HREF="../SOLgnu/RTHeapDep.m3#VMFaultTime">runtime/src/SOLgnu/RTHeapDep.m3</A>
<LI><A HREF="../SOLsun/RTHeapDep.m3#VMFaultTime">runtime/src/SOLsun/RTHeapDep.m3</A>
<LI><A HREF="../SPARC/RTHeapDep.m3#VMFaultTime">runtime/src/SPARC/RTHeapDep.m3</A>
<LI><A HREF="../SUN3/RTHeapDep.m3#VMFaultTime">runtime/src/SUN3/RTHeapDep.m3</A>
<LI><A HREF="../SUN386/RTHeapDep.m3#VMFaultTime">runtime/src/SUN386/RTHeapDep.m3</A>
<LI><A HREF="../UMAX/RTHeapDep.m3#VMFaultTime">runtime/src/UMAX/RTHeapDep.m3</A>
<LI><A HREF="../VAX/RTHeapDep.m3#VMFaultTime">runtime/src/VAX/RTHeapDep.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
