<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/HPPA/RTThread.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/HPPA/RTThread.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                            </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="#x1">RTThread</A></interface>;

IMPORT <A HREF="#x2">Csetjmp</A>, <A HREF="#x3">Usignal</A>;

CONST
  FramePadBottom = 2; (* additional words before old stack pointer to copy *)
  FramePadTop = 0;     (* additional words beyond new stack pointer to copy *)
</PRE>--------------------------------------------------------- machine state ---

<P><PRE>TYPE
  State = Csetjmp.jmp_buf;
  (* The machine state is saved in a State.  This type is really opaque
     to the client, i.e. it does not need to be an array. *)

&lt;*EXTERNAL &quot;_setjmp&quot; *&gt; PROCEDURE Save (VAR s: State): INTEGER;

&lt;*EXTERNAL &quot;RTThread__Transfer&quot;*&gt;
PROCEDURE Transfer (VAR from, to: State);
  (* Records the current machine state in &quot;from&quot; and sets
     the machine state to that contained in &quot;to&quot;. *)

PROCEDURE <A HREF="#x4">SP</A> (READONLY s: State): ADDRESS;
  (* Returns the stack pointer associated with s *)
</PRE>-------------------------------------------------- modifying the models ---

<P> When a new thread is forked, the contents of its stack and its state
   are built from models.  The only difference with the model is the location
   of the stack.  The two procedures below are used to modify the values of 
   the model to point to the correct state.  offset is the difference 
   between the actual stack location and the model stack location 

<P><PRE>PROCEDURE <A HREF="#x5">UpdateStateForNewSP</A> (VAR s: State; offset: INTEGER);
  (* update the state *)

PROCEDURE <A HREF="#x6">UpdateFrameForNewSP</A> (a: ADDRESS; offset: INTEGER);
  (* update the stack frame.  a is the correct value for the SP
     on the stack that contains that frame. *)
</PRE>------------------------------------------------------- flushing caches ---

<P> On some machines, the stack is cached; for example, on SPARC, the stack
   is partially cached in the registers. FlushStackCache is use to make
   sure that the contents of the stack is up to date. 

<P><PRE>PROCEDURE <A HREF="#x7">FlushStackCache</A> ();
</PRE>------------------------------------ manipulating the SIGVTALRM handler ---

<P><PRE>PROCEDURE <A HREF="#x8">setup_sigvtalrm</A> (handler: Usignal.SignalHandler);
PROCEDURE <A HREF="#x9">allow_sigvtalrm</A> ();
PROCEDURE <A HREF="#x10">disallow_sigvtalrm</A> ();
</PRE>---------------------------------------------------- exception delivery ---

<P><PRE>&lt;*EXTERNAL &quot;RTThread__handlerStack&quot; *&gt;
VAR handlerStack: ADDRESS;
</PRE><BLOCKQUOTE><EM> linked list of exception frames. </EM></BLOCKQUOTE><PRE>

END RTThread.
</PRE>
</inInterface>
<HR>
<A NAME="x1">RTThread's implementation  is in:
</A><UL>
<LI><A HREF="../AIX386/RTThread.m3#0TOP0">runtime/src/AIX386/RTThread.m3</A>
<LI><A HREF="../ALPHA_OSF/RTThread.m3#0TOP0">runtime/src/ALPHA_OSF/RTThread.m3</A>
<LI><A HREF="../AP3000/RTThread.m3#0TOP0">runtime/src/AP3000/RTThread.m3</A>
<LI><A HREF="../ARM/RTThread.m3#0TOP0">runtime/src/ARM/RTThread.m3</A>
<LI><A HREF="../DS3100/RTThread.m3#0TOP0">runtime/src/DS3100/RTThread.m3</A>
<LI><A HREF="../HP300/RTThread.m3#0TOP0">runtime/src/HP300/RTThread.m3</A>
<LI><A HREF="RTThread.m3#0TOP0">runtime/src/HPPA/RTThread.m3</A>
<LI><A HREF="../IBMR2/RTThread.m3#0TOP0">runtime/src/IBMR2/RTThread.m3</A>
<LI><A HREF="../IBMRT/RTThread.m3#0TOP0">runtime/src/IBMRT/RTThread.m3</A>
<LI><A HREF="../LINUX/RTThread.m3#0TOP0">runtime/src/LINUX/RTThread.m3</A>
<LI><A HREF="../NEXT/RTThread.m3#0TOP0">runtime/src/NEXT/RTThread.m3</A>
<LI><A HREF="../OKI/RTThread.m3#0TOP0">runtime/src/OKI/RTThread.m3</A>
<LI><A HREF="../SEQUENT/RTThread.m3#0TOP0">runtime/src/SEQUENT/RTThread.m3</A>
<LI><A HREF="../SOLgnu/RTThread.m3#0TOP0">runtime/src/SOLgnu/RTThread.m3</A>
<LI><A HREF="../SOLsun/RTThread.m3#0TOP0">runtime/src/SOLsun/RTThread.m3</A>
<LI><A HREF="../SPARC/RTThread.m3#0TOP0">runtime/src/SPARC/RTThread.m3</A>
<LI><A HREF="../SUN3/RTThread.m3#0TOP0">runtime/src/SUN3/RTThread.m3</A>
<LI><A HREF="../SUN386/RTThread.m3#0TOP0">runtime/src/SUN386/RTThread.m3</A>
<LI><A HREF="../UMAX/RTThread.m3#0TOP0">runtime/src/UMAX/RTThread.m3</A>
<LI><A HREF="../VAX/RTThread.m3#0TOP0">runtime/src/VAX/RTThread.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Csetjmp is in:
</A><UL>
<LI><A HREF="../../../C/src/AIX386/Csetjmp.i3#0TOP0">C/src/AIX386/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/ALPHA_OSF/Csetjmp.i3#0TOP0">C/src/ALPHA_OSF/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/AP3000/Csetjmp.i3#0TOP0">C/src/AP3000/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/ARM/Csetjmp.i3#0TOP0">C/src/ARM/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/DS3100/Csetjmp.i3#0TOP0">C/src/DS3100/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/HP300/Csetjmp.i3#0TOP0">C/src/HP300/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/HPPA/Csetjmp.i3#0TOP0">C/src/HPPA/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/IBMR2/Csetjmp.i3#0TOP0">C/src/IBMR2/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/IBMRT/Csetjmp.i3#0TOP0">C/src/IBMRT/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/LINUX/Csetjmp.i3#0TOP0">C/src/LINUX/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/NEXT/Csetjmp.i3#0TOP0">C/src/NEXT/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/NT386/Csetjmp.i3#0TOP0">C/src/NT386/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/OKI/Csetjmp.i3#0TOP0">C/src/OKI/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/SEQUENT/Csetjmp.i3#0TOP0">C/src/SEQUENT/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/SOLgnu/Csetjmp.i3#0TOP0">C/src/SOLgnu/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/SOLsun/Csetjmp.i3#0TOP0">C/src/SOLsun/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/SPARC/Csetjmp.i3#0TOP0">C/src/SPARC/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/SUN3/Csetjmp.i3#0TOP0">C/src/SUN3/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/SUN386/Csetjmp.i3#0TOP0">C/src/SUN386/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/UMAX/Csetjmp.i3#0TOP0">C/src/UMAX/Csetjmp.i3</A>
<LI><A HREF="../../../C/src/VAX/Csetjmp.i3#0TOP0">C/src/VAX/Csetjmp.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Usignal is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Usignal.i3#0TOP0">unix/src/aix-3-2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Usignal.i3#0TOP0">unix/src/aix-ps2-1-2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Usignal.i3#0TOP0">unix/src/hpux-7-0/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Usignal.i3#0TOP0">unix/src/ibm-4-3/Usignal.i3</A>
<LI><A HREF="../../../unix/src/linux/Usignal.i3#0TOP0">unix/src/linux/Usignal.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Usignal.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Usignal.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Usignal.i3#0TOP0">unix/src/osf-1.DS3100/Usignal.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Usignal.i3#0TOP0">unix/src/solaris-2-x/Usignal.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Usignal.i3#0TOP0">unix/src/sunos-4-x/Usignal.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Usignal.i3#0TOP0">unix/src/sysv-4.0/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Usignal.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Usignal.i3#0TOP0">unix/src/ultrix-3-1.ARM/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Usignal.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Usignal.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Usignal.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Usignal.i3#0TOP0">unix/src/ultrix-3-1.VAX/Usignal.i3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure RTThread.SP is in:
</A><UL>
<LI><A HREF="../AIX386/RTThread.m3#SP">runtime/src/AIX386/RTThread.m3</A>
<LI><A HREF="../ALPHA_OSF/RTThread.m3#SP">runtime/src/ALPHA_OSF/RTThread.m3</A>
<LI><A HREF="../AP3000/RTThread.m3#SP">runtime/src/AP3000/RTThread.m3</A>
<LI><A HREF="../ARM/RTThread.m3#SP">runtime/src/ARM/RTThread.m3</A>
<LI><A HREF="../DS3100/RTThread.m3#SP">runtime/src/DS3100/RTThread.m3</A>
<LI><A HREF="../HP300/RTThread.m3#SP">runtime/src/HP300/RTThread.m3</A>
<LI><A HREF="RTThread.m3#SP">runtime/src/HPPA/RTThread.m3</A>
<LI><A HREF="../IBMR2/RTThread.m3#SP">runtime/src/IBMR2/RTThread.m3</A>
<LI><A HREF="../IBMRT/RTThread.m3#SP">runtime/src/IBMRT/RTThread.m3</A>
<LI><A HREF="../LINUX/RTThread.m3#SP">runtime/src/LINUX/RTThread.m3</A>
<LI><A HREF="../NEXT/RTThread.m3#SP">runtime/src/NEXT/RTThread.m3</A>
<LI><A HREF="../OKI/RTThread.m3#SP">runtime/src/OKI/RTThread.m3</A>
<LI><A HREF="../SEQUENT/RTThread.m3#SP">runtime/src/SEQUENT/RTThread.m3</A>
<LI><A HREF="../SOLgnu/RTThread.m3#SP">runtime/src/SOLgnu/RTThread.m3</A>
<LI><A HREF="../SOLsun/RTThread.m3#SP">runtime/src/SOLsun/RTThread.m3</A>
<LI><A HREF="../SPARC/RTThread.m3#SP">runtime/src/SPARC/RTThread.m3</A>
<LI><A HREF="../SUN3/RTThread.m3#SP">runtime/src/SUN3/RTThread.m3</A>
<LI><A HREF="../SUN386/RTThread.m3#SP">runtime/src/SUN386/RTThread.m3</A>
<LI><A HREF="../UMAX/RTThread.m3#SP">runtime/src/UMAX/RTThread.m3</A>
<LI><A HREF="../VAX/RTThread.m3#SP">runtime/src/VAX/RTThread.m3</A>
</UL>
<P>
<HR>
<A NAME="x5">procedure RTThread.UpdateStateForNewSP is in:
</A><UL>
<LI><A HREF="../AIX386/RTThread.m3#UpdateStateForNewSP">runtime/src/AIX386/RTThread.m3</A>
<LI><A HREF="../ALPHA_OSF/RTThread.m3#UpdateStateForNewSP">runtime/src/ALPHA_OSF/RTThread.m3</A>
<LI><A HREF="../AP3000/RTThread.m3#UpdateStateForNewSP">runtime/src/AP3000/RTThread.m3</A>
<LI><A HREF="../ARM/RTThread.m3#UpdateStateForNewSP">runtime/src/ARM/RTThread.m3</A>
<LI><A HREF="../DS3100/RTThread.m3#UpdateStateForNewSP">runtime/src/DS3100/RTThread.m3</A>
<LI><A HREF="../HP300/RTThread.m3#UpdateStateForNewSP">runtime/src/HP300/RTThread.m3</A>
<LI><A HREF="RTThread.m3#UpdateStateForNewSP">runtime/src/HPPA/RTThread.m3</A>
<LI><A HREF="../IBMR2/RTThread.m3#UpdateStateForNewSP">runtime/src/IBMR2/RTThread.m3</A>
<LI><A HREF="../IBMRT/RTThread.m3#UpdateStateForNewSP">runtime/src/IBMRT/RTThread.m3</A>
<LI><A HREF="../LINUX/RTThread.m3#UpdateStateForNewSP">runtime/src/LINUX/RTThread.m3</A>
<LI><A HREF="../NEXT/RTThread.m3#UpdateStateForNewSP">runtime/src/NEXT/RTThread.m3</A>
<LI><A HREF="../OKI/RTThread.m3#UpdateStateForNewSP">runtime/src/OKI/RTThread.m3</A>
<LI><A HREF="../SEQUENT/RTThread.m3#UpdateStateForNewSP">runtime/src/SEQUENT/RTThread.m3</A>
<LI><A HREF="../SOLgnu/RTThread.m3#UpdateStateForNewSP">runtime/src/SOLgnu/RTThread.m3</A>
<LI><A HREF="../SOLsun/RTThread.m3#UpdateStateForNewSP">runtime/src/SOLsun/RTThread.m3</A>
<LI><A HREF="../SPARC/RTThread.m3#UpdateStateForNewSP">runtime/src/SPARC/RTThread.m3</A>
<LI><A HREF="../SUN3/RTThread.m3#UpdateStateForNewSP">runtime/src/SUN3/RTThread.m3</A>
<LI><A HREF="../SUN386/RTThread.m3#UpdateStateForNewSP">runtime/src/SUN386/RTThread.m3</A>
<LI><A HREF="../UMAX/RTThread.m3#UpdateStateForNewSP">runtime/src/UMAX/RTThread.m3</A>
<LI><A HREF="../VAX/RTThread.m3#UpdateStateForNewSP">runtime/src/VAX/RTThread.m3</A>
</UL>
<P>
<HR>
<A NAME="x6">procedure RTThread.UpdateFrameForNewSP is in:
</A><UL>
<LI><A HREF="../AIX386/RTThread.m3#UpdateFrameForNewSP">runtime/src/AIX386/RTThread.m3</A>
<LI><A HREF="../ALPHA_OSF/RTThread.m3#UpdateFrameForNewSP">runtime/src/ALPHA_OSF/RTThread.m3</A>
<LI><A HREF="../AP3000/RTThread.m3#UpdateFrameForNewSP">runtime/src/AP3000/RTThread.m3</A>
<LI><A HREF="../ARM/RTThread.m3#UpdateFrameForNewSP">runtime/src/ARM/RTThread.m3</A>
<LI><A HREF="../DS3100/RTThread.m3#UpdateFrameForNewSP">runtime/src/DS3100/RTThread.m3</A>
<LI><A HREF="../HP300/RTThread.m3#UpdateFrameForNewSP">runtime/src/HP300/RTThread.m3</A>
<LI><A HREF="RTThread.m3#UpdateFrameForNewSP">runtime/src/HPPA/RTThread.m3</A>
<LI><A HREF="../IBMR2/RTThread.m3#UpdateFrameForNewSP">runtime/src/IBMR2/RTThread.m3</A>
<LI><A HREF="../IBMRT/RTThread.m3#UpdateFrameForNewSP">runtime/src/IBMRT/RTThread.m3</A>
<LI><A HREF="../LINUX/RTThread.m3#UpdateFrameForNewSP">runtime/src/LINUX/RTThread.m3</A>
<LI><A HREF="../NEXT/RTThread.m3#UpdateFrameForNewSP">runtime/src/NEXT/RTThread.m3</A>
<LI><A HREF="../OKI/RTThread.m3#UpdateFrameForNewSP">runtime/src/OKI/RTThread.m3</A>
<LI><A HREF="../SEQUENT/RTThread.m3#UpdateFrameForNewSP">runtime/src/SEQUENT/RTThread.m3</A>
<LI><A HREF="../SOLgnu/RTThread.m3#UpdateFrameForNewSP">runtime/src/SOLgnu/RTThread.m3</A>
<LI><A HREF="../SOLsun/RTThread.m3#UpdateFrameForNewSP">runtime/src/SOLsun/RTThread.m3</A>
<LI><A HREF="../SPARC/RTThread.m3#UpdateFrameForNewSP">runtime/src/SPARC/RTThread.m3</A>
<LI><A HREF="../SUN3/RTThread.m3#UpdateFrameForNewSP">runtime/src/SUN3/RTThread.m3</A>
<LI><A HREF="../SUN386/RTThread.m3#UpdateFrameForNewSP">runtime/src/SUN386/RTThread.m3</A>
<LI><A HREF="../UMAX/RTThread.m3#UpdateFrameForNewSP">runtime/src/UMAX/RTThread.m3</A>
<LI><A HREF="../VAX/RTThread.m3#UpdateFrameForNewSP">runtime/src/VAX/RTThread.m3</A>
</UL>
<P>
<HR>
<A NAME="x7">procedure RTThread.FlushStackCache is in:
</A><UL>
<LI><A HREF="../AIX386/RTThread.m3#FlushStackCache">runtime/src/AIX386/RTThread.m3</A>
<LI><A HREF="../ALPHA_OSF/RTThread.m3#FlushStackCache">runtime/src/ALPHA_OSF/RTThread.m3</A>
<LI><A HREF="../AP3000/RTThread.m3#FlushStackCache">runtime/src/AP3000/RTThread.m3</A>
<LI><A HREF="../ARM/RTThread.m3#FlushStackCache">runtime/src/ARM/RTThread.m3</A>
<LI><A HREF="../DS3100/RTThread.m3#FlushStackCache">runtime/src/DS3100/RTThread.m3</A>
<LI><A HREF="../HP300/RTThread.m3#FlushStackCache">runtime/src/HP300/RTThread.m3</A>
<LI><A HREF="RTThread.m3#FlushStackCache">runtime/src/HPPA/RTThread.m3</A>
<LI><A HREF="../IBMR2/RTThread.m3#FlushStackCache">runtime/src/IBMR2/RTThread.m3</A>
<LI><A HREF="../IBMRT/RTThread.m3#FlushStackCache">runtime/src/IBMRT/RTThread.m3</A>
<LI><A HREF="../LINUX/RTThread.m3#FlushStackCache">runtime/src/LINUX/RTThread.m3</A>
<LI><A HREF="../NEXT/RTThread.m3#FlushStackCache">runtime/src/NEXT/RTThread.m3</A>
<LI><A HREF="../OKI/RTThread.m3#FlushStackCache">runtime/src/OKI/RTThread.m3</A>
<LI><A HREF="../SEQUENT/RTThread.m3#FlushStackCache">runtime/src/SEQUENT/RTThread.m3</A>
<LI><A HREF="../SOLgnu/RTThread.m3#FlushStackCache">runtime/src/SOLgnu/RTThread.m3</A>
<LI><A HREF="../SOLsun/RTThread.m3#FlushStackCache">runtime/src/SOLsun/RTThread.m3</A>
<LI><A HREF="../SPARC/RTThread.m3#FlushStackCache">runtime/src/SPARC/RTThread.m3</A>
<LI><A HREF="../SUN3/RTThread.m3#FlushStackCache">runtime/src/SUN3/RTThread.m3</A>
<LI><A HREF="../SUN386/RTThread.m3#FlushStackCache">runtime/src/SUN386/RTThread.m3</A>
<LI><A HREF="../UMAX/RTThread.m3#FlushStackCache">runtime/src/UMAX/RTThread.m3</A>
<LI><A HREF="../VAX/RTThread.m3#FlushStackCache">runtime/src/VAX/RTThread.m3</A>
</UL>
<P>
<HR>
<A NAME="x8">procedure RTThread.setup_sigvtalrm is in:
</A><UL>
<LI><A HREF="../AIX386/RTThread.m3#setup_sigvtalrm">runtime/src/AIX386/RTThread.m3</A>
<LI><A HREF="../ALPHA_OSF/RTThread.m3#setup_sigvtalrm">runtime/src/ALPHA_OSF/RTThread.m3</A>
<LI><A HREF="../AP3000/RTThread.m3#setup_sigvtalrm">runtime/src/AP3000/RTThread.m3</A>
<LI><A HREF="../ARM/RTThread.m3#setup_sigvtalrm">runtime/src/ARM/RTThread.m3</A>
<LI><A HREF="../DS3100/RTThread.m3#setup_sigvtalrm">runtime/src/DS3100/RTThread.m3</A>
<LI><A HREF="../HP300/RTThread.m3#setup_sigvtalrm">runtime/src/HP300/RTThread.m3</A>
<LI><A HREF="RTThread.m3#setup_sigvtalrm">runtime/src/HPPA/RTThread.m3</A>
<LI><A HREF="../IBMR2/RTThread.m3#setup_sigvtalrm">runtime/src/IBMR2/RTThread.m3</A>
<LI><A HREF="../IBMRT/RTThread.m3#setup_sigvtalrm">runtime/src/IBMRT/RTThread.m3</A>
<LI><A HREF="../LINUX/RTThread.m3#setup_sigvtalrm">runtime/src/LINUX/RTThread.m3</A>
<LI><A HREF="../NEXT/RTThread.m3#setup_sigvtalrm">runtime/src/NEXT/RTThread.m3</A>
<LI><A HREF="../OKI/RTThread.m3#setup_sigvtalrm">runtime/src/OKI/RTThread.m3</A>
<LI><A HREF="../SEQUENT/RTThread.m3#setup_sigvtalrm">runtime/src/SEQUENT/RTThread.m3</A>
<LI><A HREF="../SOLgnu/RTThread.m3#setup_sigvtalrm">runtime/src/SOLgnu/RTThread.m3</A>
<LI><A HREF="../SOLsun/RTThread.m3#setup_sigvtalrm">runtime/src/SOLsun/RTThread.m3</A>
<LI><A HREF="../SPARC/RTThread.m3#setup_sigvtalrm">runtime/src/SPARC/RTThread.m3</A>
<LI><A HREF="../SUN3/RTThread.m3#setup_sigvtalrm">runtime/src/SUN3/RTThread.m3</A>
<LI><A HREF="../SUN386/RTThread.m3#setup_sigvtalrm">runtime/src/SUN386/RTThread.m3</A>
<LI><A HREF="../UMAX/RTThread.m3#setup_sigvtalrm">runtime/src/UMAX/RTThread.m3</A>
<LI><A HREF="../VAX/RTThread.m3#setup_sigvtalrm">runtime/src/VAX/RTThread.m3</A>
</UL>
<P>
<HR>
<A NAME="x9">procedure RTThread.allow_sigvtalrm is in:
</A><UL>
<LI><A HREF="../AIX386/RTThread.m3#allow_sigvtalrm">runtime/src/AIX386/RTThread.m3</A>
<LI><A HREF="../ALPHA_OSF/RTThread.m3#allow_sigvtalrm">runtime/src/ALPHA_OSF/RTThread.m3</A>
<LI><A HREF="../AP3000/RTThread.m3#allow_sigvtalrm">runtime/src/AP3000/RTThread.m3</A>
<LI><A HREF="../ARM/RTThread.m3#allow_sigvtalrm">runtime/src/ARM/RTThread.m3</A>
<LI><A HREF="../DS3100/RTThread.m3#allow_sigvtalrm">runtime/src/DS3100/RTThread.m3</A>
<LI><A HREF="../HP300/RTThread.m3#allow_sigvtalrm">runtime/src/HP300/RTThread.m3</A>
<LI><A HREF="RTThread.m3#allow_sigvtalrm">runtime/src/HPPA/RTThread.m3</A>
<LI><A HREF="../IBMR2/RTThread.m3#allow_sigvtalrm">runtime/src/IBMR2/RTThread.m3</A>
<LI><A HREF="../IBMRT/RTThread.m3#allow_sigvtalrm">runtime/src/IBMRT/RTThread.m3</A>
<LI><A HREF="../LINUX/RTThread.m3#allow_sigvtalrm">runtime/src/LINUX/RTThread.m3</A>
<LI><A HREF="../NEXT/RTThread.m3#allow_sigvtalrm">runtime/src/NEXT/RTThread.m3</A>
<LI><A HREF="../OKI/RTThread.m3#allow_sigvtalrm">runtime/src/OKI/RTThread.m3</A>
<LI><A HREF="../SEQUENT/RTThread.m3#allow_sigvtalrm">runtime/src/SEQUENT/RTThread.m3</A>
<LI><A HREF="../SOLgnu/RTThread.m3#allow_sigvtalrm">runtime/src/SOLgnu/RTThread.m3</A>
<LI><A HREF="../SOLsun/RTThread.m3#allow_sigvtalrm">runtime/src/SOLsun/RTThread.m3</A>
<LI><A HREF="../SPARC/RTThread.m3#allow_sigvtalrm">runtime/src/SPARC/RTThread.m3</A>
<LI><A HREF="../SUN3/RTThread.m3#allow_sigvtalrm">runtime/src/SUN3/RTThread.m3</A>
<LI><A HREF="../SUN386/RTThread.m3#allow_sigvtalrm">runtime/src/SUN386/RTThread.m3</A>
<LI><A HREF="../UMAX/RTThread.m3#allow_sigvtalrm">runtime/src/UMAX/RTThread.m3</A>
<LI><A HREF="../VAX/RTThread.m3#allow_sigvtalrm">runtime/src/VAX/RTThread.m3</A>
</UL>
<P>
<HR>
<A NAME="x10">procedure RTThread.disallow_sigvtalrm is in:
</A><UL>
<LI><A HREF="../AIX386/RTThread.m3#disallow_sigvtalrm">runtime/src/AIX386/RTThread.m3</A>
<LI><A HREF="../ALPHA_OSF/RTThread.m3#disallow_sigvtalrm">runtime/src/ALPHA_OSF/RTThread.m3</A>
<LI><A HREF="../AP3000/RTThread.m3#disallow_sigvtalrm">runtime/src/AP3000/RTThread.m3</A>
<LI><A HREF="../ARM/RTThread.m3#disallow_sigvtalrm">runtime/src/ARM/RTThread.m3</A>
<LI><A HREF="../DS3100/RTThread.m3#disallow_sigvtalrm">runtime/src/DS3100/RTThread.m3</A>
<LI><A HREF="../HP300/RTThread.m3#disallow_sigvtalrm">runtime/src/HP300/RTThread.m3</A>
<LI><A HREF="RTThread.m3#disallow_sigvtalrm">runtime/src/HPPA/RTThread.m3</A>
<LI><A HREF="../IBMR2/RTThread.m3#disallow_sigvtalrm">runtime/src/IBMR2/RTThread.m3</A>
<LI><A HREF="../IBMRT/RTThread.m3#disallow_sigvtalrm">runtime/src/IBMRT/RTThread.m3</A>
<LI><A HREF="../LINUX/RTThread.m3#disallow_sigvtalrm">runtime/src/LINUX/RTThread.m3</A>
<LI><A HREF="../NEXT/RTThread.m3#disallow_sigvtalrm">runtime/src/NEXT/RTThread.m3</A>
<LI><A HREF="../OKI/RTThread.m3#disallow_sigvtalrm">runtime/src/OKI/RTThread.m3</A>
<LI><A HREF="../SEQUENT/RTThread.m3#disallow_sigvtalrm">runtime/src/SEQUENT/RTThread.m3</A>
<LI><A HREF="../SOLgnu/RTThread.m3#disallow_sigvtalrm">runtime/src/SOLgnu/RTThread.m3</A>
<LI><A HREF="../SOLsun/RTThread.m3#disallow_sigvtalrm">runtime/src/SOLsun/RTThread.m3</A>
<LI><A HREF="../SPARC/RTThread.m3#disallow_sigvtalrm">runtime/src/SPARC/RTThread.m3</A>
<LI><A HREF="../SUN3/RTThread.m3#disallow_sigvtalrm">runtime/src/SUN3/RTThread.m3</A>
<LI><A HREF="../SUN386/RTThread.m3#disallow_sigvtalrm">runtime/src/SUN386/RTThread.m3</A>
<LI><A HREF="../UMAX/RTThread.m3#disallow_sigvtalrm">runtime/src/UMAX/RTThread.m3</A>
<LI><A HREF="../VAX/RTThread.m3#disallow_sigvtalrm">runtime/src/VAX/RTThread.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
