<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/NT386/RTIO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/NT386/RTIO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="../common/RTIO.i3">RTIO</A></implements></module>;

IMPORT <A HREF="../../../text/src/TextF.i3">TextF</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../common/RTMisc.i3">RTMisc</A>;
IMPORT <A HREF="../../../win32/src/WinNT.i3">WinNT</A>, <A HREF="../../../win32/src/WinBase.i3">WinBase</A>, <A HREF="../../../win32/src/WinCon.i3">WinCon</A>;

VAR
  std_handles: ARRAY [0..2] OF WinNT.HANDLE;

PROCEDURE <A NAME="OpenRead"><procedure>OpenRead</procedure></A> (&lt;*UNUSED*&gt; t: TEXT): File =
  BEGIN
    RTMisc.FatalError (NIL, 0, &quot;RTIO.OpenRead is not implemented&quot;);
    RETURN stdin;
  END OpenRead;

PROCEDURE <A NAME="OpenWrite"><procedure>OpenWrite</procedure></A> (&lt;*UNUSED*&gt; t: TEXT): File =
  BEGIN
    RTMisc.FatalError (NIL, 0, &quot;RTIO.OpenWrite is not implemented&quot;);
    RETURN stdout;
  END OpenWrite;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A> (&lt;*UNUSED*&gt; f: File) =
  BEGIN
    RTMisc.FatalError (NIL, 0, &quot;RTIO.Close is not implemented&quot;);
  END Close;

PROCEDURE <A NAME="EOF"><procedure>EOF</procedure></A> (&lt;*UNUSED*&gt; f: File): BOOLEAN =
  BEGIN
    RETURN FALSE;
  END EOF;

VAR
  unget := FALSE;
  lastChar: CHAR := '\000';

PROCEDURE <A NAME="GetChar"><procedure>GetChar</procedure></A> (f: File): CHAR =
  VAR numberRead: INTEGER;
  BEGIN
    IF unget THEN
      unget := FALSE;
    ELSE
      REPEAT
        (* to convert CR LF to '\n' *)
        IF WinCon.ReadConsole(std_handles[f], ADR(lastChar), 1,
                              ADR(numberRead), NIL) = 0 THEN
          (* what to do? *)
        END;
      UNTIL lastChar # '\r';
    END;
    RETURN lastChar;
  END GetChar;

PROCEDURE <A NAME="UnGetChar"><procedure>UnGetChar</procedure></A> (&lt;*UNUSED*&gt; f: File;  &lt;*UNUSED*&gt; c: CHAR) =
  BEGIN
    unget := TRUE;
  END UnGetChar;

PROCEDURE <A NAME="PutChar"><procedure>PutChar</procedure></A> (f: File; c: CHAR) =
  BEGIN
    PutChars(f, ADR(c), 1);
  END PutChar;

PROCEDURE <A NAME="PutChars"><procedure>PutChars</procedure></A> (f: File; c: UNTRACED REF CHAR; n: INTEGER) =
  VAR numberWritten: INTEGER;
  BEGIN
    IF WinCon.WriteConsole(std_handles[f], c, n,
                        ADR(numberWritten), NIL) = 0 THEN
      (* what to do? *)
    END;
  END PutChars;

PROCEDURE <A NAME="PutInt"><procedure>PutInt</procedure></A> (f: File;  i: INTEGER;  width := 0) =
  VAR
    buf : ARRAY [0..30] OF CHAR;
    len := FromInt (ADR (buf[0]), i, 10);
  BEGIN
    FOR i := 1 TO width - len DO PutChar (f, ' ') END;
    PutChars (f, ADR (buf[0]), len);
  END PutInt;

PROCEDURE <A NAME="PutHexa"><procedure>PutHexa</procedure></A> (f: File; i: INTEGER;  width := 0) =
  VAR
    buf : ARRAY [0..30] OF CHAR;
    len := FromUnsigned (ADR (buf[2]), i, 16) + 2;
  BEGIN
    FOR i := 1 TO width - len DO PutChar (f, ' ') END;
    buf[0] := '0';
    buf[1] := 'x';
    PutChars (f, ADR (buf[0]), len);
  END PutHexa;

PROCEDURE <A NAME="PutText"><procedure>PutText</procedure></A> (f: File; t: TEXT) =
  BEGIN
    PutChars (f, ADR (t[0]), NUMBER (t^) - 1);
  END PutText;

PROCEDURE <A NAME="Flush"><procedure>Flush</procedure></A> (&lt;*UNUSED*&gt; f: File) =
  BEGIN
    (* nothing to do? *)
  END Flush;
</PRE>----------------------------------------------------- internal routines ---

<P><PRE>TYPE Base = [2..16];
CONST Digits = ARRAY [0..15] OF CHAR {
                   '0', '1', '2', '3', '4', '5', '6', '7',
                   '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

PROCEDURE <A NAME="FromInt"><procedure>FromInt</procedure></A> (buf    : UNTRACED REF CHAR;
                   value  : INTEGER;
                   base   : Base := 10): INTEGER =
  VAR
    nDigits : INTEGER := 0;
    minus   : BOOLEAN := FALSE;
    bump    : BOOLEAN := FALSE;
    i, j    : INTEGER;
    c       : CHAR;
    result  : ARRAY [0..BITSIZE (INTEGER)] OF CHAR;

  BEGIN
    IF (value = 0) THEN
      result[0] := '0';
      nDigits := 1;
    ELSE (* handle a non-zero number *)
      (* get rid of negative numbers *)
      IF (value &lt; 0) THEN
        IF (value = FIRST (INTEGER)) THEN
          (* 2's complement makes FIRST(INTEGER) a special case *)
          bump := TRUE;
	  INC (value);
        END;
        minus := TRUE;
        value := -value;
        &lt;* ASSERT value &gt; 0 *&gt;
      END;

      (* convert the bulk of the digits *)
      WHILE (value &gt; 0) DO
        result [nDigits] := Digits [value MOD base];
        value := value DIV base;
        INC (nDigits);
      END;

      (* fixup FIRST (INTEGER) *)
      IF (bump) THEN
        result [nDigits] := '0';
        j := 0;
        LOOP
          c := result [j];
          IF (c &lt;= '9')
            THEN i := ORD (c) - ORD ('0');
            ELSE i := ORD (c) - ORD ('a') + 10;
          END;
          INC (i);
	  IF (i &lt; base) THEN  result [j] := Digits [i];  EXIT END;
	  result [j] := '0';
	  INC (j);
        END;
        nDigits := MAX (nDigits, j+1);
      END;
    END;

    (* build the result buffer *)
    j := 0;
    IF (minus)  THEN buf^ := '-';  j := 1; INC (buf, BYTESIZE (buf^)); END;
    FOR k := nDigits-1 TO 0 BY -1 DO
      buf^ := result [k];  INC (j); INC (buf, BYTESIZE (buf^));
    END;

    RETURN j;
  END FromInt;

PROCEDURE <A NAME="FromUnsigned"><procedure>FromUnsigned</procedure></A> (buf    : UNTRACED REF CHAR;
                        value  : INTEGER;
                        base   : Base := 10): INTEGER =
  VAR
    nDigits : INTEGER := 0;
    j       : INTEGER;
    result  : ARRAY [0..BITSIZE (INTEGER)] OF CHAR;

  BEGIN
    IF (value = 0) THEN
      result[0] := '0';
      nDigits := 1;
    ELSE
      (* convert the bulk of the digits *)
      WHILE (value # 0) DO
        result [nDigits] := Digits [Word.Mod (value, base)];
        value := Word.Divide (value, base);
        INC (nDigits);
      END;
    END;

    (* build the result buffer *)
    j := 0;
    FOR k := nDigits-1 TO 0 BY -1 DO
      buf^ := result [k];  INC (j); INC (buf, BYTESIZE (buf^));
    END;

    RETURN j;
  END FromUnsigned;

BEGIN
  (* Perhaps we should explicitly open CONIN$ et al, in case of
     redirection by parent? *)
  std_handles[0] := WinBase.GetStdHandle(WinBase.STD_INPUT_HANDLE);
  std_handles[1] := WinBase.GetStdHandle(WinBase.STD_OUTPUT_HANDLE);
  std_handles[2] := WinBase.GetStdHandle(WinBase.STD_ERROR_HANDLE);
END RTIO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
