<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/POSIX/RTArgs.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/POSIX/RTArgs.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> On Posix systems, <CODE>envp</CODE> points at a NIL-terminated list of
   string pointers 

<P><PRE>UNSAFE MODULE <module><implements><A HREF="../common/RTArgs.i3">RTArgs</A></implements></module>;

IMPORT <A HREF="../common/RTLinker.i3">RTLinker</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>;

VAR env_c : CARDINAL := 0;

PROCEDURE <A NAME="ArgC"><procedure>ArgC</procedure></A> (): CARDINAL =
  BEGIN
    RETURN RTLinker.info.argc;
  END ArgC;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (n: CARDINAL): TEXT =
  VAR p: Ctypes.char_star_star := RTLinker.info.argv + n * ADRSIZE (ADDRESS);
      a: ARRAY [0..1] OF INTEGER;
  BEGIN
    IF (n &gt;= RTLinker.info.argc) THEN
      n := 2;  n := a[n];  (* force a subscript fault *)
    END;
    RETURN M3toC.StoT (p^);
  END GetArg;

PROCEDURE <A NAME="EnvC"><procedure>EnvC</procedure></A> (): CARDINAL =
  VAR
    cnt  : CARDINAL := 0;
    envp : Ctypes.char_star_star := RTLinker.info.envp;
  BEGIN
    IF (env_c = 0) THEN
      WHILE envp^ # NIL DO
        INC (envp, ADRSIZE (ADDRESS));
        INC (cnt);
      END;
      env_c := cnt;
    END;
    RETURN env_c;
  END EnvC;

PROCEDURE <A NAME="GetEnv"><procedure>GetEnv</procedure></A> (n: CARDINAL): TEXT =
  VAR p: Ctypes.char_star_star := RTLinker.info.envp + n * ADRSIZE (ADDRESS);
      a: ARRAY [0..1] OF INTEGER;
  BEGIN
    IF (n &gt;= EnvC ()) THEN
      n := 2;  n := a[n];  (* force a subscript fault *)
    END;
    RETURN M3toC.StoT (p^);
  END GetEnv;

BEGIN
END RTArgs.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
