<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/POSIX/RTOS.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/POSIX/RTOS.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="../common/RTOS.i3">RTOS</A></implements></module>;

IMPORT <A HREF="#x1">Unix</A>, <A HREF="#x2">Uuio</A>, <A HREF="../../../C/src/Common/Cstdlib.i3">Cstdlib</A>, <A HREF="#x3">RT0u</A>;
</PRE>--------------------------------------------------- process termination ---

<P><PRE>PROCEDURE <A NAME="Exit"><procedure>Exit</procedure></A> (n: INTEGER) =
  BEGIN
    Unix.exit (n);
  END Exit;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A> () =
  BEGIN
    Cstdlib.abort ();
    LOOP END; (* wait *)
  END Crash;
</PRE>------------------------------------------------------------- allocator ---

<P><PRE>PROCEDURE <A NAME="GetMemory"><procedure>GetMemory</procedure></A> (size: INTEGER): ADDRESS =
  (* Return the address of &quot;size&quot; bytes of unused storage *)
  BEGIN
    RETURN LOOPHOLE(Unix.sbrk(size), ADDRESS);
  END GetMemory;
</PRE>------------------------------------------------------------- collector ---
 These procedures provide synchronization primitives for the allocator
   and collector.  This is the Ultrix version, and depends on the Ultrix
   user-level thread implementation. 

<P> LockHeap() enters a critical section; the same thread may enter the
   critical section multiple times.  It could be written at user level
   as:
<P>
<PRE>
      VAR
        mutex    : MUTEX            := NEW(MUTEX);
        condition: Thread.Condition := NEW(Thread.Condition);
        thread   : Thread.T         := NIL;
        count    : CARDINAL         := 0;
</PRE>
<PRE>
      PROCEDURE LockHeap () =
        BEGIN
          LOCK mutex DO
            IF count = 0 THEN
              thread := Thread.Self();
              INC(count);
            ELSIF thread = Thread.Self() THEN
              INC(count);
            ELSE
              Thread.Wait(mutex, condition);
            END;
          END;
        END LockHeap;
</PRE>
   However, it must be possible to call it from anywhere in the
   collector. 

<P><PRE>PROCEDURE <A NAME="LockHeap"><procedure>LockHeap</procedure></A> () =
  BEGIN
    INC(RT0u.inCritical);
  END LockHeap;
</PRE> UnlockHeap() leaves the critical section.  It could be written at user
   level as:
<P>
<PRE>
      PROCEDURE UnlockHeap () =
        BEGIN
          LOCK mutex DO DEC(count); END;
          IF count = 0 THEN Thread.Signal(condition); END;
        END UnlockHeap;
</PRE>
   However, it must be possible to call it from anywhere inside the
   collector. 

<P><PRE>PROCEDURE <A NAME="UnlockHeap"><procedure>UnlockHeap</procedure></A> () =
  BEGIN
    DEC(RT0u.inCritical);
  END UnlockHeap;
</PRE>------------------------------------------------------------------- I/O ---

<P><PRE>PROCEDURE <A NAME="Write"><procedure>Write</procedure></A> (a: ADDRESS;  n: INTEGER) =
  BEGIN
    EVAL Uuio.write (2, a, n);
  END Write;

BEGIN
END RTOS.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Unix is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Unix.i3#0TOP0">unix/src/freebsd-1/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Unix.i3#0TOP0">unix/src/freebsd-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Unix.i3#0TOP0">unix/src/irix-5.2/Unix.i3</A>
<LI><A HREF="../../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Uuio is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uuio.i3#0TOP0">unix/src/aix-3-2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uuio.i3#0TOP0">unix/src/aix-ps2-1-2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uuio.i3#0TOP0">unix/src/freebsd-1/Uuio.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uuio.i3#0TOP0">unix/src/freebsd-2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uuio.i3#0TOP0">unix/src/hpux-7-0/Uuio.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uuio.i3#0TOP0">unix/src/ibm-4-3/Uuio.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uuio.i3#0TOP0">unix/src/irix-5.2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/linux/Uuio.i3#0TOP0">unix/src/linux/Uuio.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uuio.i3#0TOP0">unix/src/osf-1.generic/Uuio.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uuio.i3#0TOP0">unix/src/solaris-2-x/Uuio.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uuio.i3#0TOP0">unix/src/sunos-4-x/Uuio.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uuio.i3#0TOP0">unix/src/sysv-4.0/Uuio.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Uuio.i3#0TOP0">unix/src/ultrix-3-1.generic/Uuio.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface RT0u is in:
</A><UL>
<LI><A HREF="RT0u.i3#0TOP0">runtime/src/POSIX/RT0u.i3</A>
<LI><A HREF="../WIN32/RT0u.i3#0TOP0">runtime/src/WIN32/RT0u.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
