<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/POSIX/RTPerfTool.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/POSIX/RTPerfTool.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Last Modified On Fri Jun 11 13:54:56 PDT 1993 by kalsow                   </EM></BLOCKQUOTE><PRE>
</PRE>      Modified On Wed Feb  3 22:48:42 PST 1993 by mjordan                  
      Modified On Fri May 29 16:46:51 PDT 1992 by muller                   

<P><PRE>INTERFACE <interface><A HREF="#x1">RTPerfTool</A></interface>;
</PRE> This interface provides procedures to start performance tools with
   a very low-level communication channel. 

<P><PRE>TYPE Handle = INTEGER;

PROCEDURE <A HREF="#x2">Start</A> (param: TEXT;  VAR w: Handle): BOOLEAN;
</PRE><BLOCKQUOTE><EM> If the Modula runtime parameter <CODE>param</CODE> is not set, return <CODE>FALSE</CODE>.
   Otherwise, use the value of that parameter to determine the name
   of the program to start.  If the value of the parameters is <CODE></CODE>,
   the <CODE>param</CODE> is used as its value.  Start the program and wait until
   it writes a byte on its stdout file.  If everything succeeds, return
   <CODE>TRUE</CODE> and set <CODE>w</CODE> to a handle connected to the tool's stdin file.
   Otherwise, return <CODE>FALSE</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x3">Close</A> (w: Handle);
</PRE><BLOCKQUOTE><EM> Makes a good effort attempt to shutdown the connection to the
   tool attached to <CODE>w</CODE>.  The result of reusing a closed handle is
   undefined. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x4">Send</A> (w: Handle;  at: ADDRESS;  len: CARDINAL): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Sends <CODE>len</CODE> bytes of data beginning at address <CODE>at</CODE> to the
   monitoring tool connected to handle <CODE>w</CODE>.  Returns <CODE>TRUE</CODE> iff
   the operation was successful.  This routine must be called
   from within a runtime critical section. </EM></BLOCKQUOTE><PRE>

END RTPerfTool.
</PRE>
</inInterface>
<HR>
<A NAME="x1">RTPerfTool's implementation  is in:
</A><UL>
<LI><A HREF="RTPerfTool.m3#0TOP0">runtime/src/POSIX/RTPerfTool.m3</A>
<LI><A HREF="../WIN32/RTPerfTool.m3#0TOP0">runtime/src/WIN32/RTPerfTool.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure RTPerfTool.Start is in:
</A><UL>
<LI><A HREF="RTPerfTool.m3#Start">runtime/src/POSIX/RTPerfTool.m3</A>
<LI><A HREF="../WIN32/RTPerfTool.m3#Start">runtime/src/WIN32/RTPerfTool.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure RTPerfTool.Close is in:
</A><UL>
<LI><A HREF="RTPerfTool.m3#Close">runtime/src/POSIX/RTPerfTool.m3</A>
<LI><A HREF="../WIN32/RTPerfTool.m3#Close">runtime/src/WIN32/RTPerfTool.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure RTPerfTool.Send is in:
</A><UL>
<LI><A HREF="RTPerfTool.m3#Send">runtime/src/POSIX/RTPerfTool.m3</A>
<LI><A HREF="../WIN32/RTPerfTool.m3#Send">runtime/src/WIN32/RTPerfTool.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
