<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/POSIX/RTThreadStk.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/POSIX/RTThreadStk.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                         </EM></BLOCKQUOTE><PRE>
</PRE> This module maintains a pool of free thread stacks 

<P><PRE>UNSAFE MODULE <module>RTThreadStk</module> EXPORTS <A HREF="RTThread.i3"><implements>RTThread</A></implements>;

VAR pool       : ARRAY [0..49] OF Stack;
VAR tos        : CARDINAL := 0;  (* next free pool slot *)
VAR clock      : CARDINAL := 0;

PROCEDURE <A NAME="GetStack"><procedure>GetStack</procedure></A> (size: INTEGER;  VAR(*OUT*) s: Stack) =
  VAR
    bytes   := size * ADRSIZE (INTEGER);
    best    : INTEGER := -1;
    best_sz : INTEGER;
    sz      : INTEGER;
  BEGIN
    (* check the pool first *)
    FOR p := tos-1 TO FIRST (pool) BY -1 DO
      WITH pp = pool[p] DO
        sz := pp.last - pp.first;
        IF (sz = bytes) THEN
          (* exact match*)
          DEC (tos);
          s  := pp;
          pp := pool[tos];
          pool[tos].words := NIL;
          RETURN;
        ELSIF (sz &gt;= bytes) AND ((best &lt; 0) OR (sz &lt; best_sz)) THEN
          (* a new best match *)
          best := p;  best_sz := sz;
        END;
      END;
    END;

    IF (best &gt;= 0) THEN
      DEC (tos);
      s := pool[best];
      pool[best] := pool[tos];
      pool[tos].words := NIL;
      RETURN;
    END;

    (* nothing in the pool =&gt; allocate a fresh stack *)
    NewStack (size, s);
  END GetStack;

PROCEDURE <A NAME="FreeStack"><procedure>FreeStack</procedure></A> (VAR(*IN/OUT*) s: Stack) =
  BEGIN
    IF (tos &lt; NUMBER (pool)) THEN
      (* the pool isn't full *)
      pool[tos] := s;  INC (tos);
      s.words := NIL;
      s.first := NIL;
      s.last  := NIL;
    ELSE
      (* no room in the pool =&gt; free an old stack from the pool *)
      IF (clock &gt;= tos) THEN clock := 0 END;
      DisposeStack (pool[clock]);
      pool[clock] := s;
      INC (clock);
    END;
  END FreeStack;

BEGIN
END RTThreadStk.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
