<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/SEQUENT/RTIO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/SEQUENT/RTIO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="../common/RTIO.i3">RTIO</A></implements></module>;

IMPORT <A HREF="../../../text/src/TextF.i3">TextF</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="#x1">Unix</A>, <A HREF="#x2">Cstdio</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>;

PROCEDURE <A NAME="OpenRead"><procedure>OpenRead</procedure></A> (t: TEXT): File =
  BEGIN
    RETURN Unix.open (M3toC.TtoS (t), Unix.O_RDONLY, 0);
  END OpenRead;

PROCEDURE <A NAME="OpenWrite"><procedure>OpenWrite</procedure></A> (t: TEXT): File =
  BEGIN
    RETURN Unix.open (M3toC.TtoS (t), Unix.O_WRONLY, Unix.Mrwrwrw);
  END OpenWrite;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A> (f: File) =
  BEGIN
    EVAL Unix.close (f);
  END Close;

PROCEDURE <A NAME="EOF"><procedure>EOF</procedure></A> (f: File): BOOLEAN =
  BEGIN
    RETURN Word.And (Cstdio.iob[f].flag, Cstdio.IOEOF) # 0;
  END EOF;

PROCEDURE <A NAME="GetChar"><procedure>GetChar</procedure></A> (f: File): CHAR =
  VAR c: CHAR;
  BEGIN
    WITH ff = Cstdio.iob[f] DO
      DEC (ff.cnt);
      IF ff.cnt &gt;= 0 THEN
        c := ff.ptr^;
        INC (ff.ptr, ADRSIZE (ff.ptr^));
      ELSE
        c := Cstdio.filbuf (ADR (ff));
      END;
    END;
    RETURN c;
  END GetChar;

PROCEDURE <A NAME="UnGetChar"><procedure>UnGetChar</procedure></A> (f: File; c: CHAR) =
  BEGIN
    Cstdio.ungetc (c, ADR (Cstdio.iob[f]));
  END UnGetChar;

PROCEDURE <A NAME="PutChar"><procedure>PutChar</procedure></A> (f: File; c: CHAR) =
  BEGIN
    WITH ff = Cstdio.iob[f] DO
      DEC (ff.cnt);
      IF ff.cnt &gt;= 0 THEN
        ff.ptr^ := c;
        INC (ff.ptr, ADRSIZE (ff.ptr^));
      ELSE
        Cstdio.flsbuf (c, ADR (ff));
      END;
    END;
  END PutChar;

PROCEDURE <A NAME="PutChars"><procedure>PutChars</procedure></A> (f: File;  c: UNTRACED REF CHAR;  n: INTEGER) =
  BEGIN
    FOR i := 1 TO n DO
      PutChar (f, c^);
      INC (c, BYTESIZE (c^));
    END;
  END PutChars;

PROCEDURE <A NAME="PutInt"><procedure>PutInt</procedure></A> (f: File;  i: INTEGER;  width := 0) =
  VAR
    buf : ARRAY [0..30] OF CHAR;
    len := FromInt (ADR (buf[0]), i, 10);
  BEGIN
    FOR i := 1 TO width - len DO PutChar (f, ' ') END;
    PutChars (f, ADR (buf[0]), len);
  END PutInt;

PROCEDURE <A NAME="PutHexa"><procedure>PutHexa</procedure></A> (f: File; i: INTEGER;  width := 0) =
  VAR
    buf : ARRAY [0..30] OF CHAR;
    len := FromUnsigned (ADR (buf[2]), i, 16) + 2;
  BEGIN
    FOR i := 1 TO width - len DO PutChar (f, ' ') END;
    buf[0] := '0';
    buf[1] := 'x';
    PutChars (f, ADR (buf[0]), len);
  END PutHexa;

PROCEDURE <A NAME="PutText"><procedure>PutText</procedure></A> (f: File;  t: TEXT) =
  BEGIN
    PutChars (f, ADR (t[0]), NUMBER (t^) - 1);
  END PutText;

PROCEDURE <A NAME="Flush"><procedure>Flush</procedure></A> (f: File) =
  BEGIN
    Cstdio.flush (ADR (Cstdio.iob[f]));
  END Flush;
</PRE>----------------------------------------------------- internal routines ---

<P>
<P><PRE>TYPE  Base = [2..16];
CONST Digits = ARRAY [0..15] OF CHAR {
                   '0', '1', '2', '3', '4', '5', '6', '7',
                   '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

PROCEDURE <A NAME="FromInt"><procedure>FromInt</procedure></A> (buf    : UNTRACED REF CHAR;
                   value  : INTEGER;
                   base   : Base := 10): INTEGER =
  VAR
    nDigits : INTEGER := 0;
    minus   : BOOLEAN := FALSE;
    bump    : BOOLEAN := FALSE;
    i, j    : INTEGER;
    c       : CHAR;
    result  : ARRAY [0..BITSIZE (INTEGER)] OF CHAR;

  BEGIN
    IF (value = 0) THEN
      result[0] := '0';
      nDigits := 1;
    ELSE (* handle a non-zero number *)
      (* get rid of negative numbers *)
      IF (value &lt; 0) THEN
        IF (value = FIRST (INTEGER)) THEN
          (* 2's complement makes FIRST(INTEGER) a special case *)
          bump := TRUE;
	  INC (value);
        END;
        minus := TRUE;
        value := -value;
        &lt;* ASSERT value &gt; 0 *&gt;
      END;

      (* convert the bulk of the digits *)
      WHILE (value &gt; 0) DO
        result [nDigits] := Digits [value MOD base];
        value := value DIV base;
        INC (nDigits);
      END;

      (* fixup FIRST (INTEGER) *)
      IF (bump) THEN
        result [nDigits] := '0';
        j := 0;
        LOOP
          c := result [j];
          IF (c &lt;= '9')
            THEN i := ORD (c) - ORD ('0');
            ELSE i := ORD (c) - ORD ('a') + 10;
          END;
          INC (i);
	  IF (i &lt; base) THEN  result [j] := Digits [i];  EXIT END;
	  result [j] := '0';
	  INC (j);
        END;
        nDigits := MAX (nDigits, j+1);
      END;
    END;

    (* build the result buffer *)
    j := 0;
    IF (minus)  THEN buf^ := '-';  j := 1; INC (buf, BYTESIZE (buf^)); END;
    FOR k := nDigits-1 TO 0 BY -1 DO
      buf^ := result [k];  INC (j); INC (buf, BYTESIZE (buf^));
    END;

    RETURN j;
  END FromInt;

PROCEDURE <A NAME="FromUnsigned"><procedure>FromUnsigned</procedure></A> (buf    : UNTRACED REF CHAR;
                        value  : INTEGER;
                        base   : Base := 10): INTEGER =
  VAR
    nDigits : INTEGER := 0;
    j       : INTEGER;
    result  : ARRAY [0..BITSIZE (INTEGER)] OF CHAR;
  BEGIN
    IF (value = 0) THEN
      result[0] := '0';
      nDigits := 1;
    ELSE
      (* convert the bulk of the digits *)
      WHILE (value # 0) DO
        result [nDigits] := Digits [Word.Mod (value, base)];
        value := Word.Divide (value, base);
        INC (nDigits);
      END;
    END;

    (* build the result buffer *)
    j := 0;
    FOR k := nDigits-1 TO 0 BY -1 DO
      buf^ := result [k];  INC (j); INC (buf, BYTESIZE (buf^));
    END;

    RETURN j;
  END FromUnsigned;

BEGIN
END RTIO.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Unix is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Cstdio is in:
</A><UL>
<LI><A HREF="../../../C/src/AIX386/Cstdio.i3#0TOP0">C/src/AIX386/Cstdio.i3</A>
<LI><A HREF="../../../C/src/ALPHA_OSF/Cstdio.i3#0TOP0">C/src/ALPHA_OSF/Cstdio.i3</A>
<LI><A HREF="../../../C/src/AP3000/Cstdio.i3#0TOP0">C/src/AP3000/Cstdio.i3</A>
<LI><A HREF="../../../C/src/ARM/Cstdio.i3#0TOP0">C/src/ARM/Cstdio.i3</A>
<LI><A HREF="../../../C/src/DS3100/Cstdio.i3#0TOP0">C/src/DS3100/Cstdio.i3</A>
<LI><A HREF="../../../C/src/HP300/Cstdio.i3#0TOP0">C/src/HP300/Cstdio.i3</A>
<LI><A HREF="../../../C/src/HPPA/Cstdio.i3#0TOP0">C/src/HPPA/Cstdio.i3</A>
<LI><A HREF="../../../C/src/IBMR2/Cstdio.i3#0TOP0">C/src/IBMR2/Cstdio.i3</A>
<LI><A HREF="../../../C/src/IBMRT/Cstdio.i3#0TOP0">C/src/IBMRT/Cstdio.i3</A>
<LI><A HREF="../../../C/src/LINUX/Cstdio.i3#0TOP0">C/src/LINUX/Cstdio.i3</A>
<LI><A HREF="../../../C/src/NEXT/Cstdio.i3#0TOP0">C/src/NEXT/Cstdio.i3</A>
<LI><A HREF="../../../C/src/NT386/Cstdio.i3#0TOP0">C/src/NT386/Cstdio.i3</A>
<LI><A HREF="../../../C/src/OKI/Cstdio.i3#0TOP0">C/src/OKI/Cstdio.i3</A>
<LI><A HREF="../../../C/src/SEQUENT/Cstdio.i3#0TOP0">C/src/SEQUENT/Cstdio.i3</A>
<LI><A HREF="../../../C/src/SOLgnu/Cstdio.i3#0TOP0">C/src/SOLgnu/Cstdio.i3</A>
<LI><A HREF="../../../C/src/SOLsun/Cstdio.i3#0TOP0">C/src/SOLsun/Cstdio.i3</A>
<LI><A HREF="../../../C/src/SPARC/Cstdio.i3#0TOP0">C/src/SPARC/Cstdio.i3</A>
<LI><A HREF="../../../C/src/SUN3/Cstdio.i3#0TOP0">C/src/SUN3/Cstdio.i3</A>
<LI><A HREF="../../../C/src/SUN386/Cstdio.i3#0TOP0">C/src/SUN386/Cstdio.i3</A>
<LI><A HREF="../../../C/src/UMAX/Cstdio.i3#0TOP0">C/src/UMAX/Cstdio.i3</A>
<LI><A HREF="../../../C/src/VAX/Cstdio.i3#0TOP0">C/src/VAX/Cstdio.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
