<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/SOLgnu/RTSignal.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/SOLgnu/RTSignal.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                            </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module><implements><A HREF="../common/RTSignal.i3">RTSignal</A></implements></module>;

IMPORT <A HREF="../common/RTMisc.i3">RTMisc</A>, <A HREF="../common/RTProcess.i3">RTProcess</A>, <A HREF="#x1">Usignal</A>, <A HREF="#x2">Uprocess</A>;
FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int;

TYPE
  SigInfo = UNTRACED REF Usignal.struct_sigcontext;

VAR
  DefaultHandler   : Usignal.SignalHandler;
  IgnoreSignal     : Usignal.SignalHandler;
  initial_handlers : ARRAY [0..5] OF Usignal.struct_sigaction;

PROCEDURE <A NAME="InstallHandlers"><procedure>InstallHandlers</procedure></A> () =
  BEGIN
    DefaultHandler := LOOPHOLE (0, Usignal.SignalHandler);
    IgnoreSignal   := LOOPHOLE (1, Usignal.SignalHandler);

    SetHandler (0, Usignal.SIGHUP,  Shutdown);
    SetHandler (1, Usignal.SIGINT,  Interrupt);
    SetHandler (2, Usignal.SIGQUIT, Quit);
    SetHandler (3, Usignal.SIGSEGV, SegV);
    SetHandler (4, Usignal.SIGPIPE, IgnoreSignal);
    SetHandler (5, Usignal.SIGTERM, Shutdown);
  END InstallHandlers;

PROCEDURE <A NAME="SetHandler"><procedure>SetHandler</procedure></A> (id: INTEGER; sig: int;  handler: Usignal.SignalHandler) =
  (* Note: we use the LOOPHOLE to prevent the runtime check for
     nested procedure.  The runtime check crashes when
     handler = IgnoreSignal = 1. *)
  VAR new: Usignal.struct_sigaction;
  BEGIN
    new.sa_handler := LOOPHOLE (handler, Usignal.SignalHandler);
    new.sa_flags   := 0;
    EVAL Usignal.sigaction (sig, new, initial_handlers[id]);
    IF (initial_handlers[id].sa_handler # DefaultHandler) THEN
      (* don't override inherited, non-default handlers *)
      EVAL Usignal.sigaction (sig, initial_handlers[id], new);
    END;
  END SetHandler;

PROCEDURE <A NAME="RestoreHandlers"><procedure>RestoreHandlers</procedure></A> () =
  BEGIN
    RestoreHandler (0, Usignal.SIGHUP);
    RestoreHandler (1, Usignal.SIGINT);
    RestoreHandler (2, Usignal.SIGQUIT);
    RestoreHandler (3, Usignal.SIGSEGV);
    RestoreHandler (4, Usignal.SIGPIPE);
    RestoreHandler (5, Usignal.SIGTERM);
  END RestoreHandlers;

PROCEDURE <A NAME="RestoreHandler"><procedure>RestoreHandler</procedure></A> (id: INTEGER;  sig: int) =
  VAR old: Usignal.struct_sigaction;
  BEGIN
    EVAL Usignal.sigaction (sig, initial_handlers[id], old);
  END RestoreHandler;

PROCEDURE <A NAME="Shutdown"><procedure>Shutdown</procedure></A> (sig: int; &lt;*UNUSED*&gt; code: int; &lt;*UNUSED*&gt; scp: SigInfo) =
  VAR new, old: Usignal.struct_sigaction;
  BEGIN
    new.sa_handler := DefaultHandler;
    new.sa_flags   := 0;
    RTProcess.InvokeExitors ();                   (* flush stdio... *)
    EVAL Usignal.sigaction (sig, new, old);       (* restore default handler *)
    EVAL Usignal.kill (Uprocess.getpid (), sig);  (* and resend the signal *)
  END Shutdown;

PROCEDURE <A NAME="Interrupt"><procedure>Interrupt</procedure></A> (sig: int;  code: int;  scp: SigInfo) =
  VAR h := RTProcess.OnInterrupt (NIL);
  BEGIN
    IF (h = NIL) THEN
      Shutdown (sig, code, scp);
    ELSE
      EVAL RTProcess.OnInterrupt (h); (* reinstall the handler *)
      h ();
    END;
  END Interrupt;

PROCEDURE <A NAME="Quit"><procedure>Quit</procedure></A> (&lt;*UNUSED*&gt; sig, code: int; &lt;*UNUSED*&gt;scp: SigInfo) =
  VAR pc := 0;
  BEGIN
    (*IF (scp # NIL) THEN pc := scp.sc_pc END;*)
    RTMisc.FatalErrorPC (pc, &quot;aborted&quot;);
  END Quit;

PROCEDURE <A NAME="SegV"><procedure>SegV</procedure></A> (&lt;*UNUSED*&gt; sig, code: int; &lt;*UNUSED*&gt;scp: SigInfo) =
  VAR pc := 0;
  BEGIN
    (*IF (scp # NIL) THEN pc := scp.sc_pc END;*)
    RTMisc.FatalErrorPC (pc,
      &quot;Segmentation violation - possible attempt to dereference NIL&quot;);
  END SegV;

BEGIN
END RTSignal.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Usignal is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Usignal.i3#0TOP0">unix/src/aix-3-2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Usignal.i3#0TOP0">unix/src/aix-ps2-1-2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Usignal.i3#0TOP0">unix/src/freebsd-1/Usignal.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Usignal.i3#0TOP0">unix/src/freebsd-2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Usignal.i3#0TOP0">unix/src/hpux-7-0/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Usignal.i3#0TOP0">unix/src/ibm-4-3/Usignal.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Usignal.i3#0TOP0">unix/src/irix-5.2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/linux/Usignal.i3#0TOP0">unix/src/linux/Usignal.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Usignal.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Usignal.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Usignal.i3#0TOP0">unix/src/osf-1.DS3100/Usignal.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Usignal.i3#0TOP0">unix/src/solaris-2-x/Usignal.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Usignal.i3#0TOP0">unix/src/sunos-4-x/Usignal.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Usignal.i3#0TOP0">unix/src/sysv-4.0/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Usignal.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Usignal.i3#0TOP0">unix/src/ultrix-3-1.ARM/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Usignal.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Usignal.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Usignal.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Usignal.i3#0TOP0">unix/src/ultrix-3-1.VAX/Usignal.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Uprocess is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uprocess.i3#0TOP0">unix/src/aix-3-2/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uprocess.i3#0TOP0">unix/src/aix-ps2-1-2/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uprocess.i3#0TOP0">unix/src/freebsd-1/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uprocess.i3#0TOP0">unix/src/freebsd-2/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uprocess.i3#0TOP0">unix/src/hpux-7-0/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uprocess.i3#0TOP0">unix/src/ibm-4-3/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uprocess.i3#0TOP0">unix/src/irix-5.2/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/linux/Uprocess.i3#0TOP0">unix/src/linux/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uprocess.i3#0TOP0">unix/src/osf-1.generic/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uprocess.i3#0TOP0">unix/src/solaris-2-x/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uprocess.i3#0TOP0">unix/src/sunos-4-x/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uprocess.i3#0TOP0">unix/src/sysv-4.0/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Uprocess.i3#0TOP0">unix/src/ultrix-3-1.generic/Uprocess.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
