<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/SUN386/RTStack.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/SUN386/RTStack.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

UNSAFE INTERFACE <interface><A HREF="#x1">RTStack</A></interface>;

TYPE
  T = UNTRACED REF ARRAY OF INTEGER;
  (* a thread stack *)

CONST
  PointerAlignment = 4;
  (* The C compiler allocates all pointers on 'PointerAlignment'-byte
     boundaries.  The garbage collector scans thread stacks, but only
     looks at these possible pointer locations.  Setting this value
     smaller than is needed will only make your system run slower.
     Setting it too large will cause the collector to collect storage
     that is not free. *)

  StackFrameAlignment = 8;
  (* Stack frames must be aligned to this constraint (in ADRSIZE units).
     It's not a big deal if this value is too large, but it may break
     the thread mechanism to make it too small. *)

PROCEDURE <A HREF="#x2">New</A> (size: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Allocate a thread stack with at least 'size' usable INTEGERs of storage,
   unmap its guard page, and return it. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x3">Dispose</A> (t: T);
</PRE><BLOCKQUOTE><EM> Dispose of 't' and remap its guard page. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x4">GetBounds</A> (t: T;  VAR(*OUT*) first, last: ADDRESS);
</PRE><BLOCKQUOTE><EM> returns the range of usable addresses in stack 't': [first .. last) </EM></BLOCKQUOTE><PRE>

END RTStack.
</PRE>
</inInterface>
<HR>
<A NAME="x1">RTStack's implementation  is in:
</A><UL>
<LI><A HREF="../AIX386/RTStack.m3#0TOP0">runtime/src/AIX386/RTStack.m3</A>
<LI><A HREF="../ALPHA_OSF/RTStack.m3#0TOP0">runtime/src/ALPHA_OSF/RTStack.m3</A>
<LI><A HREF="../AP3000/RTStack.m3#0TOP0">runtime/src/AP3000/RTStack.m3</A>
<LI><A HREF="../ARM/RTStack.m3#0TOP0">runtime/src/ARM/RTStack.m3</A>
<LI><A HREF="../DS3100/RTStack.m3#0TOP0">runtime/src/DS3100/RTStack.m3</A>
<LI><A HREF="../HP300/RTStack.m3#0TOP0">runtime/src/HP300/RTStack.m3</A>
<LI><A HREF="../HPPA/RTStack.m3#0TOP0">runtime/src/HPPA/RTStack.m3</A>
<LI><A HREF="../IBMR2/RTStack.m3#0TOP0">runtime/src/IBMR2/RTStack.m3</A>
<LI><A HREF="../IBMRT/RTStack.m3#0TOP0">runtime/src/IBMRT/RTStack.m3</A>
<LI><A HREF="../LINUX/RTStack.m3#0TOP0">runtime/src/LINUX/RTStack.m3</A>
<LI><A HREF="../NEXT/RTStack.m3#0TOP0">runtime/src/NEXT/RTStack.m3</A>
<LI><A HREF="../NT386/RTStack.m3#0TOP0">runtime/src/NT386/RTStack.m3</A>
<LI><A HREF="../OKI/RTStack.m3#0TOP0">runtime/src/OKI/RTStack.m3</A>
<LI><A HREF="../SEQUENT/RTStack.m3#0TOP0">runtime/src/SEQUENT/RTStack.m3</A>
<LI><A HREF="../SOLgnu/RTStack.m3#0TOP0">runtime/src/SOLgnu/RTStack.m3</A>
<LI><A HREF="../SOLsun/RTStack.m3#0TOP0">runtime/src/SOLsun/RTStack.m3</A>
<LI><A HREF="../SPARC/RTStack.m3#0TOP0">runtime/src/SPARC/RTStack.m3</A>
<LI><A HREF="../SUN3/RTStack.m3#0TOP0">runtime/src/SUN3/RTStack.m3</A>
<LI><A HREF="RTStack.m3#0TOP0">runtime/src/SUN386/RTStack.m3</A>
<LI><A HREF="../UMAX/RTStack.m3#0TOP0">runtime/src/UMAX/RTStack.m3</A>
<LI><A HREF="../VAX/RTStack.m3#0TOP0">runtime/src/VAX/RTStack.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure RTStack.New is in:
</A><UL>
<LI><A HREF="../AIX386/RTStack.m3#New">runtime/src/AIX386/RTStack.m3</A>
<LI><A HREF="../ALPHA_OSF/RTStack.m3#New">runtime/src/ALPHA_OSF/RTStack.m3</A>
<LI><A HREF="../AP3000/RTStack.m3#New">runtime/src/AP3000/RTStack.m3</A>
<LI><A HREF="../ARM/RTStack.m3#New">runtime/src/ARM/RTStack.m3</A>
<LI><A HREF="../DS3100/RTStack.m3#New">runtime/src/DS3100/RTStack.m3</A>
<LI><A HREF="../HP300/RTStack.m3#New">runtime/src/HP300/RTStack.m3</A>
<LI><A HREF="../HPPA/RTStack.m3#New">runtime/src/HPPA/RTStack.m3</A>
<LI><A HREF="../IBMR2/RTStack.m3#New">runtime/src/IBMR2/RTStack.m3</A>
<LI><A HREF="../IBMRT/RTStack.m3#New">runtime/src/IBMRT/RTStack.m3</A>
<LI><A HREF="../LINUX/RTStack.m3#New">runtime/src/LINUX/RTStack.m3</A>
<LI><A HREF="../NEXT/RTStack.m3#New">runtime/src/NEXT/RTStack.m3</A>
<LI><A HREF="../OKI/RTStack.m3#New">runtime/src/OKI/RTStack.m3</A>
<LI><A HREF="../SEQUENT/RTStack.m3#New">runtime/src/SEQUENT/RTStack.m3</A>
<LI><A HREF="../SOLgnu/RTStack.m3#New">runtime/src/SOLgnu/RTStack.m3</A>
<LI><A HREF="../SOLsun/RTStack.m3#New">runtime/src/SOLsun/RTStack.m3</A>
<LI><A HREF="../SPARC/RTStack.m3#New">runtime/src/SPARC/RTStack.m3</A>
<LI><A HREF="../SUN3/RTStack.m3#New">runtime/src/SUN3/RTStack.m3</A>
<LI><A HREF="RTStack.m3#New">runtime/src/SUN386/RTStack.m3</A>
<LI><A HREF="../UMAX/RTStack.m3#New">runtime/src/UMAX/RTStack.m3</A>
<LI><A HREF="../VAX/RTStack.m3#New">runtime/src/VAX/RTStack.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure RTStack.Dispose is in:
</A><UL>
<LI><A HREF="../AIX386/RTStack.m3#Dispose">runtime/src/AIX386/RTStack.m3</A>
<LI><A HREF="../ALPHA_OSF/RTStack.m3#Dispose">runtime/src/ALPHA_OSF/RTStack.m3</A>
<LI><A HREF="../AP3000/RTStack.m3#Dispose">runtime/src/AP3000/RTStack.m3</A>
<LI><A HREF="../ARM/RTStack.m3#Dispose">runtime/src/ARM/RTStack.m3</A>
<LI><A HREF="../DS3100/RTStack.m3#Dispose">runtime/src/DS3100/RTStack.m3</A>
<LI><A HREF="../HP300/RTStack.m3#Dispose">runtime/src/HP300/RTStack.m3</A>
<LI><A HREF="../HPPA/RTStack.m3#Dispose">runtime/src/HPPA/RTStack.m3</A>
<LI><A HREF="../IBMR2/RTStack.m3#Dispose">runtime/src/IBMR2/RTStack.m3</A>
<LI><A HREF="../IBMRT/RTStack.m3#Dispose">runtime/src/IBMRT/RTStack.m3</A>
<LI><A HREF="../LINUX/RTStack.m3#Dispose">runtime/src/LINUX/RTStack.m3</A>
<LI><A HREF="../NEXT/RTStack.m3#Dispose">runtime/src/NEXT/RTStack.m3</A>
<LI><A HREF="../OKI/RTStack.m3#Dispose">runtime/src/OKI/RTStack.m3</A>
<LI><A HREF="../SEQUENT/RTStack.m3#Dispose">runtime/src/SEQUENT/RTStack.m3</A>
<LI><A HREF="../SOLgnu/RTStack.m3#Dispose">runtime/src/SOLgnu/RTStack.m3</A>
<LI><A HREF="../SOLsun/RTStack.m3#Dispose">runtime/src/SOLsun/RTStack.m3</A>
<LI><A HREF="../SPARC/RTStack.m3#Dispose">runtime/src/SPARC/RTStack.m3</A>
<LI><A HREF="../SUN3/RTStack.m3#Dispose">runtime/src/SUN3/RTStack.m3</A>
<LI><A HREF="RTStack.m3#Dispose">runtime/src/SUN386/RTStack.m3</A>
<LI><A HREF="../UMAX/RTStack.m3#Dispose">runtime/src/UMAX/RTStack.m3</A>
<LI><A HREF="../VAX/RTStack.m3#Dispose">runtime/src/VAX/RTStack.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure RTStack.GetBounds is in:
</A><UL>
<LI><A HREF="../AIX386/RTStack.m3#GetBounds">runtime/src/AIX386/RTStack.m3</A>
<LI><A HREF="../ALPHA_OSF/RTStack.m3#GetBounds">runtime/src/ALPHA_OSF/RTStack.m3</A>
<LI><A HREF="../AP3000/RTStack.m3#GetBounds">runtime/src/AP3000/RTStack.m3</A>
<LI><A HREF="../ARM/RTStack.m3#GetBounds">runtime/src/ARM/RTStack.m3</A>
<LI><A HREF="../DS3100/RTStack.m3#GetBounds">runtime/src/DS3100/RTStack.m3</A>
<LI><A HREF="../HP300/RTStack.m3#GetBounds">runtime/src/HP300/RTStack.m3</A>
<LI><A HREF="../HPPA/RTStack.m3#GetBounds">runtime/src/HPPA/RTStack.m3</A>
<LI><A HREF="../IBMR2/RTStack.m3#GetBounds">runtime/src/IBMR2/RTStack.m3</A>
<LI><A HREF="../IBMRT/RTStack.m3#GetBounds">runtime/src/IBMRT/RTStack.m3</A>
<LI><A HREF="../LINUX/RTStack.m3#GetBounds">runtime/src/LINUX/RTStack.m3</A>
<LI><A HREF="../NEXT/RTStack.m3#GetBounds">runtime/src/NEXT/RTStack.m3</A>
<LI><A HREF="../OKI/RTStack.m3#GetBounds">runtime/src/OKI/RTStack.m3</A>
<LI><A HREF="../SEQUENT/RTStack.m3#GetBounds">runtime/src/SEQUENT/RTStack.m3</A>
<LI><A HREF="../SOLgnu/RTStack.m3#GetBounds">runtime/src/SOLgnu/RTStack.m3</A>
<LI><A HREF="../SOLsun/RTStack.m3#GetBounds">runtime/src/SOLsun/RTStack.m3</A>
<LI><A HREF="../SPARC/RTStack.m3#GetBounds">runtime/src/SPARC/RTStack.m3</A>
<LI><A HREF="../SUN3/RTStack.m3#GetBounds">runtime/src/SUN3/RTStack.m3</A>
<LI><A HREF="RTStack.m3#GetBounds">runtime/src/SUN386/RTStack.m3</A>
<LI><A HREF="../UMAX/RTStack.m3#GetBounds">runtime/src/UMAX/RTStack.m3</A>
<LI><A HREF="../VAX/RTStack.m3#GetBounds">runtime/src/VAX/RTStack.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
