<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/SUN386/RTStack.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/SUN386/RTStack.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module><implements><A HREF="#x1">RTStack</A></implements></module>;

IMPORT <A HREF="#x2">Unix</A>, <A HREF="#x3">Umman</A>, <A HREF="../common/RTMisc.i3">RTMisc</A>;

VAR page_bytes : CARDINAL := 0;
VAR stack_slop : CARDINAL;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> () =
  BEGIN
    page_bytes := Unix.getpagesize ();
    stack_slop := 2 * (page_bytes DIV BYTESIZE (INTEGER));
  END Init;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (size: INTEGER): T =
  VAR t: T;  i: INTEGER;  start: ADDRESS;
  BEGIN
    IF (page_bytes = 0) THEN Init () END;

    (* allocate enough so that we're guaranteed to get a full, aligned page *)
    t := NEW (T, size + stack_slop);

    (* find the aligned page and unmap it *)
    (* the guard page is marked read-only so that when Thread.InitContext
       writes the &quot;seal&quot; on the non-protected pages it doesn't generate
       a NIL fault. *)
    start := RTMisc.Align (ADR (t[0]), page_bytes);
    i := Umman.mprotect (start, page_bytes, Umman.PROT_READ);
    &lt;* ASSERT i = 0 *&gt;

    (* finally, return the new stack *)
    RETURN t;
  END New;

PROCEDURE <A NAME="Dispose"><procedure>Dispose</procedure></A> (t: T) =
  VAR i: INTEGER;  start := RTMisc.Align (ADR (t[0]), page_bytes);
  BEGIN
    (* find the aligned page and re-map it *)
    i := Umman.mprotect (start, page_bytes,
                         Umman.PROT_READ + Umman.PROT_WRITE);
    &lt;* ASSERT i = 0 *&gt;

    (* and finally, free the storage *)
    DISPOSE (t);
  END Dispose;

PROCEDURE <A NAME="GetBounds"><procedure>GetBounds</procedure></A> (t: T;  VAR(*OUT*) first, last: ADDRESS) =
  VAR start := RTMisc.Align (ADR (t[0]), page_bytes);
  BEGIN
    first := start + page_bytes;
    last  := ADR (t [0]) + NUMBER (t^) * ADRSIZE (t[0]);
  END GetBounds;

BEGIN
END RTStack.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface RTStack is in:
</A><UL>
<LI><A HREF="../AIX386/RTStack.i3#0TOP0">runtime/src/AIX386/RTStack.i3</A>
<LI><A HREF="../ALPHA_OSF/RTStack.i3#0TOP0">runtime/src/ALPHA_OSF/RTStack.i3</A>
<LI><A HREF="../ALPHA_OSF/old/RTStack.i3#0TOP0">runtime/src/ALPHA_OSF/old/RTStack.i3</A>
<LI><A HREF="../AP3000/RTStack.i3#0TOP0">runtime/src/AP3000/RTStack.i3</A>
<LI><A HREF="../ARM/RTStack.i3#0TOP0">runtime/src/ARM/RTStack.i3</A>
<LI><A HREF="../DS3100/RTStack.i3#0TOP0">runtime/src/DS3100/RTStack.i3</A>
<LI><A HREF="../HP300/RTStack.i3#0TOP0">runtime/src/HP300/RTStack.i3</A>
<LI><A HREF="../HPPA/RTStack.i3#0TOP0">runtime/src/HPPA/RTStack.i3</A>
<LI><A HREF="../IBMR2/RTStack.i3#0TOP0">runtime/src/IBMR2/RTStack.i3</A>
<LI><A HREF="../IBMRT/RTStack.i3#0TOP0">runtime/src/IBMRT/RTStack.i3</A>
<LI><A HREF="../LINUX/RTStack.i3#0TOP0">runtime/src/LINUX/RTStack.i3</A>
<LI><A HREF="../NEXT/RTStack.i3#0TOP0">runtime/src/NEXT/RTStack.i3</A>
<LI><A HREF="../NT386/RTStack.i3#0TOP0">runtime/src/NT386/RTStack.i3</A>
<LI><A HREF="../OKI/RTStack.i3#0TOP0">runtime/src/OKI/RTStack.i3</A>
<LI><A HREF="../SEQUENT/RTStack.i3#0TOP0">runtime/src/SEQUENT/RTStack.i3</A>
<LI><A HREF="../SOLgnu/RTStack.i3#0TOP0">runtime/src/SOLgnu/RTStack.i3</A>
<LI><A HREF="../SOLsun/RTStack.i3#0TOP0">runtime/src/SOLsun/RTStack.i3</A>
<LI><A HREF="../SPARC/RTStack.i3#0TOP0">runtime/src/SPARC/RTStack.i3</A>
<LI><A HREF="../SUN3/RTStack.i3#0TOP0">runtime/src/SUN3/RTStack.i3</A>
<LI><A HREF="RTStack.i3#0TOP0">runtime/src/SUN386/RTStack.i3</A>
<LI><A HREF="../UMAX/RTStack.i3#0TOP0">runtime/src/UMAX/RTStack.i3</A>
<LI><A HREF="../VAX/RTStack.i3#0TOP0">runtime/src/VAX/RTStack.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Unix is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Umman is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Umman.i3#0TOP0">unix/src/aix-3-2/Umman.i3</A>
<LI><A HREF="../../../unix/src/linux/Umman.i3#0TOP0">unix/src/linux/Umman.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Umman.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Umman.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Umman.i3#0TOP0">unix/src/osf-1.DS3100/Umman.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Umman.i3#0TOP0">unix/src/solaris-2-x/Umman.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Umman.i3#0TOP0">unix/src/sunos-4-x/Umman.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Umman.i3#0TOP0">unix/src/sysv-4.0/Umman.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Umman.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Umman.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Umman.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Umman.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Umman.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Umman.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Umman.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Umman.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Umman.i3#0TOP0">unix/src/ultrix-3-1.VAX/Umman.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
