<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/WIN32/RTArgs.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/WIN32/RTArgs.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> In Windows/NT, <CODE>envp</CODE> points at a null-terminated block of
   null-terminated strings 

<P><PRE>UNSAFE MODULE <module><implements><A HREF="../common/RTArgs.i3">RTArgs</A></implements></module>;

IMPORT <A HREF="../common/RTLinker.i3">RTLinker</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../../../C/src/Common/Cstdlib.i3">Cstdlib</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="../../../win32/src/WinBase.i3">WinBase</A>;

CONST
  NUL    = VAL (0, Ctypes.char);
  SPACE  = VAL (ORD (' '), Ctypes.char);
  QUOTE  = VAL (ORD ('&quot;'), Ctypes.char);
  BSLASH = VAL (ORD ('\134'), Ctypes.char);

VAR env_c : CARDINAL := 0;

PROCEDURE <A NAME="ArgC"><procedure>ArgC</procedure></A> (): CARDINAL =
  BEGIN
    IF (RTLinker.info.argc &lt; 0) THEN ParseArgs (); END;
    RETURN RTLinker.info.argc;
  END ArgC;

PROCEDURE <A NAME="ParseArgs"><procedure>ParseArgs</procedure></A> () =
  (* This hack is necessary because a windows GUI program is passed
     its command line unparsed.  This code is executed before the
     runtime type system is initialized. *)
  VAR
    cp       : Ctypes.char_star := RTLinker.info.argv;
    n_args   : INTEGER;
    n_chars  : INTEGER;
    next     : Ctypes.char_star_star;
    argv     : Ctypes.char_star_star;
    args     : Ctypes.char_star;
    quoted   : BOOLEAN;
    filename : ARRAY [0..255] OF Ctypes.char;
    fn_len   : INTEGER;
  BEGIN
    IF (cp = NIL) THEN
      RTLinker.info.argc := 0;
      RETURN;
    END;

    (* get a bound on number of arguments *)
    n_args := 0;
    WHILE (cp^ # NUL) DO
      (* skip blanks *)
      WHILE (cp^ = SPACE) DO INC (cp, ADRSIZE (cp^)); END;
      IF (cp^ = NUL) THEN EXIT; END;
      INC (n_args);
      WHILE (cp^ # SPACE) AND (cp^ # NUL) DO INC (cp, ADRSIZE (cp^)); END;
    END;
    n_chars := cp - RTLinker.info.argv;

    (* try getting the file name *)
    fn_len := MAX (0, WinBase.GetModuleFileName (NIL, ADR (filename[0]),
                                         BYTESIZE(filename)));
    INC (n_chars, fn_len + 1);

    (* allocate the new argv arrays *)
    argv := Cstdlib.malloc ((n_args+2) * BYTESIZE (ADDRESS));
    args := Cstdlib.malloc ((n_chars+1) * BYTESIZE (CHAR));

    (* add the file name to the arg vectors *)
    n_args := 1;  next := argv;
    next^ := args;
    INC (next, ADRSIZE (next^));
    FOR i := 0 TO fn_len-1 DO
      args^ := filename[i];
      INC (args, ADRSIZE (args^));
    END;
    args^ := NUL;  INC (args, ADRSIZE (args^));

    (* parse the command line *)
    cp := RTLinker.info.argv;
    WHILE (cp^ # NUL) DO

      (* skip blanks *)
      WHILE (cp^ = SPACE) DO INC (cp, ADRSIZE (cp^)); END;

      IF (cp^ = NUL) THEN EXIT; END;

      (* add an arg *)
      next^ := args;
      INC (next, ADRSIZE (next^));
      INC (n_args);

      (* copy an arg *)
      quoted := FALSE;
      WHILE (cp^ # NUL) DO
        IF (cp^ = SPACE) THEN
          IF (NOT quoted) THEN EXIT; END;
          args^ := cp^;
          INC (args, ADRSIZE (args^));
        ELSIF (cp^ = QUOTE) THEN
          quoted := NOT quoted;
        ELSIF (cp^ = BSLASH) THEN (* escape *)
          INC (cp, ADRSIZE (cp^));
          IF (cp^ # QUOTE) THEN
            args^ := BSLASH;
            INC (args, ADRSIZE (args^));
          END;
          IF (cp^ = NUL) THEN EXIT; END;
          args^ := cp^;
          INC (args, ADRSIZE (args^));
        ELSE
          args^ := cp^;
          INC (args, ADRSIZE (args^));
        END;
        INC (cp, ADRSIZE (cp^));
      END;
      args^ := NUL;  INC (args, ADRSIZE (args^));

    END;
    next^ := NIL;

    RTLinker.info.argv := argv;
    RTLinker.info.argc := n_args;
  END ParseArgs;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (n: CARDINAL): TEXT =
  VAR p: Ctypes.char_star_star := RTLinker.info.argv + n * ADRSIZE (ADDRESS);
      a: ARRAY [0..1] OF INTEGER;
  BEGIN
    IF (n &gt;= RTLinker.info.argc) THEN
      n := 2;  n := a[n];  (* force a subscript fault *)
    END;
    RETURN M3toC.StoT (p^);
  END GetArg;

PROCEDURE <A NAME="EnvC"><procedure>EnvC</procedure></A> (): CARDINAL =
  VAR
    cnt  : CARDINAL := 0;
    envp : Ctypes.char_star := RTLinker.info.envp;
  BEGIN
    IF (env_c = 0) AND (envp # NIL) THEN
      WHILE envp^ # NUL DO
        (* skip over string *)
        WHILE envp^ # NUL DO INC (envp, ADRSIZE (CHAR)) END;
        INC (envp, ADRSIZE (CHAR));
        INC (cnt);
      END;
      env_c := cnt;
    END;
    RETURN env_c;
  END EnvC;

PROCEDURE <A NAME="GetEnv"><procedure>GetEnv</procedure></A> (n: CARDINAL): TEXT =
  VAR envp : Ctypes.char_star := RTLinker.info.envp;
      a: ARRAY [0..1] OF INTEGER;
  BEGIN
    IF (n &gt;= EnvC ()) THEN
      n := 2;  n := a[n];  (* force a subscript fault *)
    END;
    FOR i := 0 TO n-1 DO
      WHILE envp^ # NUL DO INC (envp, ADRSIZE (CHAR)) END;
      INC (envp, ADRSIZE (CHAR));
    END;
    RETURN M3toC.StoT (envp);
  END GetEnv;

BEGIN
END RTArgs.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
