<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/WIN32/RTHeapWin32.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/WIN32/RTHeapWin32.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module>RTHeapWin32</module> EXPORTS <A HREF="../common/RTCollector.i3"><implements>RTCollector</A></implements>, <A HREF="../common/RTCollectorSRC.i3"><implements>RTCollectorSRC</A></implements>,
                                  <A HREF="../common/RTHeap.i3"><implements>RTHeap</A></implements>, <A HREF="../common/RTHeapRep.i3"><implements>RTHeapRep</A></implements>, <A HREF="../common/RTWeakRef.i3"><implements>RTWeakRef</A></implements>;

IMPORT <A HREF="../../../C/src/Common/Cstdlib.i3">Cstdlib</A>, <A HREF="../common/RTMisc.i3">RTMisc</A>, <A HREF="../../../win32/src/WinBase.i3">WinBase</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

EXCEPTION NotImplemented;
</PRE>** RTCollector **

<P><PRE>PROCEDURE <A NAME="Disable"><procedure>Disable</procedure></A> () =
  BEGIN
    Lock();
    BEGIN
      FinishVM();
      INC(disableCount);
    END;
    Unlock();
  END Disable;

PROCEDURE <A NAME="Enable"><procedure>Enable</procedure></A> () =
  BEGIN
    Lock();
    BEGIN
      DEC(disableCount);
    END;
    Unlock();
  END Enable;

PROCEDURE <A NAME="DisableMotion"><procedure>DisableMotion</procedure></A> () =
  BEGIN
    Lock();
    BEGIN
      INC(disableMotionCount);
    END;
    Unlock();
  END DisableMotion;

PROCEDURE <A NAME="EnableMotion"><procedure>EnableMotion</procedure></A> () =
  BEGIN
    Lock();
    BEGIN
      DEC(disableMotionCount);
    END;
    Unlock();
  END EnableMotion;

PROCEDURE <A NAME="Collect"><procedure>Collect</procedure></A> () =
  BEGIN
    Lock();
    BEGIN
      FinishGC();
      StartGC();
      FinishGC();
    END;
    Unlock();
  END Collect;

PROCEDURE <A NAME="StartCollection"><procedure>StartCollection</procedure></A> () =
  BEGIN
  END StartCollection;

PROCEDURE <A NAME="FinishCollection"><procedure>FinishCollection</procedure></A> () =
  BEGIN
  END FinishCollection;

PROCEDURE <A NAME="DisableVM"><procedure>DisableVM</procedure></A> () =
  BEGIN
    Lock();
    BEGIN
      FinishVM();
      INC(disableVMCount);
    END;
    Unlock();
  END DisableVM;

PROCEDURE <A NAME="EnableVM"><procedure>EnableVM</procedure></A> () =
  BEGIN
    Lock();
    BEGIN
      DEC(disableVMCount);
    END;
    Unlock();
  END EnableVM;

PROCEDURE <A NAME="FinishVM"><procedure>FinishVM</procedure></A> () =
  BEGIN
  END FinishVM;

PROCEDURE <A NAME="StartBackgroundCollection"><procedure>StartBackgroundCollection</procedure></A> () =
  BEGIN
  END StartBackgroundCollection;

TYPE
  RefReferent = ADDRESS;

PROCEDURE <A NAME="HeaderOf"><procedure>HeaderOf</procedure></A> (r: RefReferent): RefHeader =
  BEGIN
    RETURN LOOPHOLE(r - ADRSIZE(Header), RefHeader);
  END HeaderOf;
</PRE> Malloc returns the address of <CODE>size</CODE> bytes of untraced, zeroed storage 

<P><PRE>PROCEDURE <A NAME="Malloc"><procedure>Malloc</procedure></A> (size: INTEGER): ADDRESS =
  VAR res: ADDRESS;
  BEGIN
    Lock();
    BEGIN
      res := Cstdlib.malloc(size);
      IF res = NIL THEN
        RTMisc.FatalError(NIL, 0, &quot;malloc failed, unable to get more memory&quot;);
      END;
    END;
    Unlock();
    RETURN res;
  END Malloc;
</PRE> AllocForNew allocates space for a NEW. 

<P><PRE>PROCEDURE <A NAME="AllocForNew"><procedure>AllocForNew</procedure></A> (size, alignment: CARDINAL): RefReferent =
  VAR at: INTEGER;
  BEGIN
    WHILE alignment MOD ADRSIZE(Header) # 0 DO alignment := alignment * 2; END;
    Lock();
    BEGIN
      at := LOOPHOLE(Malloc(size + alignment - 1), INTEGER);
      at := at - at MOD alignment;
    END;
    Unlock();
    RETURN LOOPHOLE(at + ADRSIZE(Header), RefReferent);
  END AllocForNew;

PROCEDURE <A NAME="StartGC"><procedure>StartGC</procedure></A> () =
  BEGIN
    StartCollection();
  END StartGC;

PROCEDURE <A NAME="FinishGC"><procedure>FinishGC</procedure></A> () =
  BEGIN
    FinishCollection();
  END FinishGC;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A> (): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END Crash;

PROCEDURE <A NAME="VisitAllRefs"><procedure>VisitAllRefs</procedure></A> (&lt;*UNUSED*&gt; v: RefVisitor) =
  &lt;* FATAL NotImplemented *&gt;
  BEGIN
    RAISE NotImplemented;
  END VisitAllRefs;

VAR
  weakTable: UNTRACED REF ARRAY OF WeakEntry; (* allocated in &quot;Init&quot; *)
             (* := NEW(UNTRACED REF ARRAY OF WeakEntry, 0); *)
  weakLive0  := -1;
  weakFinal0 := -1;
  weakFree0  := -1;

TYPE
  WeakRefAB = RECORD
                a: BITS 32 FOR INTEGER;
                b: BITS 32 FOR Word.T;
              END;
  WeakEntry = RECORD
                t   : WeakRefAB;
                r   : RefReferent;
                p   : ADDRESS;
                next: INTEGER;
              END;

PROCEDURE <A NAME="WeakRefFromRef"><procedure>WeakRefFromRef</procedure></A> (r: REFANY; p: WeakRefCleanUpProc := NIL):
  WeakRef =
  VAR result: WeakRef;
  BEGIN
    &lt;* ASSERT r # NIL *&gt;
    Lock();
    BEGIN
      IF weakFree0 = -1 THEN ExpandWeakTable(); END;
      IF p # NIL THEN
        VAR header := HeaderOf(LOOPHOLE(r, ADDRESS));
        BEGIN
          &lt;* ASSERT NOT header^.weak *&gt;
          header^.weak := TRUE;
        END;
      END;
      VAR i := weakFree0;
      BEGIN
        weakFree0 := weakTable[i].next;
        VAR t := WeakRefAB{a := i, b := Word.Plus(weakTable[i].t.b, 1)};
        BEGIN
          &lt;* ASSERT t.b # 0 *&gt;
          weakTable[i] :=
            WeakEntry{t := t, r := LOOPHOLE(r, RefReferent), p :=
                      LOOPHOLE(p, ADDRESS), next := weakLive0};
          weakLive0 := i;
          result := LOOPHOLE(t, WeakRef);
        END;
      END;
    END;
    Unlock();
    RETURN result;
  END WeakRefFromRef;

PROCEDURE <A NAME="ExpandWeakTable"><procedure>ExpandWeakTable</procedure></A> () =
  VAR
    newTable := NEW(UNTRACED REF ARRAY OF WeakEntry,
                    2 * NUMBER(weakTable^) + 1);
  BEGIN
    SUBARRAY(newTable^, 0, NUMBER(weakTable^)) := weakTable^;
    FOR i := NUMBER(weakTable^) TO NUMBER(newTable^) - 1 DO
      WITH entry = newTable[i] DO
        entry.t.b := 0;
        entry.next := weakFree0;
        weakFree0 := i;
      END;
    END;
    weakTable := newTable;
  END ExpandWeakTable;

PROCEDURE <A NAME="WeakRefToRef"><procedure>WeakRefToRef</procedure></A> (READONLY t: WeakRef): REFANY =
  VAR ab: WeakRefAB;  r: REFANY := NIL;
  BEGIN
    LOOPHOLE (ab, WeakRef) := t;
    Lock();
    WITH entry = weakTable[ab.a] DO
      IF entry.t = ab THEN
        r := LOOPHOLE(entry.r, REFANY);
      END;
    END;
    Unlock();
    RETURN r;
  END WeakRefToRef;

PROCEDURE <A NAME="RegisterFinalCleanup"><procedure>RegisterFinalCleanup</procedure></A> (r: REFANY; p: PROCEDURE (r: REFANY)) =
  BEGIN
    &lt;* ASSERT r # NIL *&gt;
    &lt;* ASSERT p # NIL *&gt;
    Lock();
    BEGIN
      IF weakFree0 = -1 THEN ExpandWeakTable(); END;
      VAR i := weakFree0;
      BEGIN
        weakFree0 := weakTable[i].next;
        weakTable[i].r := LOOPHOLE(r, RefReferent);
        weakTable[i].p := LOOPHOLE(p, ADDRESS);
        weakTable[i].next := weakFinal0;
        weakFinal0 := i;
      END;
    END;
    Unlock();
  END RegisterFinalCleanup;

PROCEDURE <A NAME="Fault"><procedure>Fault</procedure></A> (&lt;*UNUSED*&gt; addr: ADDRESS): BOOLEAN =
  BEGIN
    RETURN FALSE;
  END Fault;

VAR cs: WinBase.CRITICAL_SECTION;

PROCEDURE <A NAME="Lock"><procedure>Lock</procedure></A> () =
  BEGIN
    WinBase.EnterCriticalSection(
      LOOPHOLE(ADR(cs), WinBase.LPCRITICAL_SECTION));
  END Lock;

PROCEDURE <A NAME="Unlock"><procedure>Unlock</procedure></A> () =
  BEGIN
    WinBase.LeaveCriticalSection(
      LOOPHOLE(ADR(cs), WinBase.LPCRITICAL_SECTION));
  END Unlock;
</PRE>** INITIALIZATION **

<P><PRE>CONST MaxAlignment = 8;
TYPE MaxAlignRange = [0 .. MaxAlignment - 1];

VAR align: ARRAY MaxAlignRange, [1 .. MaxAlignment] OF CARDINAL;
</PRE><BLOCKQUOTE><EM> align[i,j] == RTMisc.Align (i, j) - i </EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> () =
  BEGIN
    WinBase.InitializeCriticalSection(
      LOOPHOLE(ADR(cs), WinBase.LPCRITICAL_SECTION));
    weakTable := NEW(UNTRACED REF ARRAY OF WeakEntry, 0);

    (* initialize the alignment array *)
    FOR i := FIRST(align) TO LAST(align) DO
      FOR j := FIRST(align[0]) TO LAST(align[0]) DO
        align[i, j] := RTMisc.Upper(i, j) - i;
      END;
    END;
  END Init;

BEGIN
END RTHeapWin32.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
