<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTAllocator.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTAllocator.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>RTAllocator</CODE> provides access to the runtime storage allocator.
   \index{allocator}
   \index{storage allocator}
   \index{heap}


<P><PRE>INTERFACE <interface><A HREF="RTAllocator.m3">RTAllocator</A></interface>;

FROM <A HREF="RTType.i3">RTType</A> IMPORT Typecode;
</PRE> Each of the procedures described below allocates and initializes heap
   storage.  Calling any of these procedures with a typecode <CODE>tc</CODE> that
   names a type <CODE>T</CODE> is equivalent to calling <CODE>NEW</CODE> for that type.  It is a
   checked runtime error to pass a typecode that is not proper.  (See
   <CODE>RTType</CODE> for the definition of proper typecode.) 

<P><PRE>PROCEDURE <A HREF="RTAllocator.m3#NewTraced">NewTraced</A>(tc: Typecode): REFANY;
</PRE><BLOCKQUOTE><EM> Return a reference to a freshly allocated and initialized, traced
   referent with typecode <CODE>tc</CODE>.  It is a checked runtime error if <CODE>tc</CODE> does
   not name a traced reference type other than <CODE>REFANY</CODE>, or if its referent
   is an open array. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTAllocator.m3#NewUntraced">NewUntraced</A>(tc: Typecode): ADDRESS;
</PRE><BLOCKQUOTE><EM> Return a reference to a freshly allocated and initialized, untraced
   referent with typecode <CODE>tc</CODE>.  It is a checked runtime error if <CODE>tc</CODE> does
   not name an untraced reference type other than <CODE>ADDRESS</CODE>, or if it names
   an untraced object type, or if its referent is an open array. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTAllocator.m3#NewUntracedObject">NewUntracedObject</A>(tc: Typecode): UNTRACED ROOT;
</PRE><BLOCKQUOTE><EM> Return a freshly allocated and initialized, untraced object with
   typecode <CODE>tc</CODE>.  It is a checked runtime error if <CODE>tc</CODE> does not name an
   untraced object type. </EM></BLOCKQUOTE><PRE>

TYPE Shape = ARRAY OF INTEGER;

PROCEDURE <A HREF="RTAllocator.m3#NewTracedArray">NewTracedArray</A>(
    tc: Typecode;
    READONLY s: Shape): REFANY;
</PRE><BLOCKQUOTE><EM> Return a reference to a freshly allocated and initialized, traced open
   array referent with typecode <CODE>tc</CODE> and sizes <CODE>s[0]</CODE>, ..., <CODE>s[LAST(s)]</CODE>.
   It is a checked runtime error if <CODE>tc</CODE> does not name a traced reference
   to an open array, or if any <CODE>s[i]</CODE> is negative, or if <CODE>NUMBER(s)</CODE> does
   not equal the number of open dimensions of the array. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTAllocator.m3#NewUntracedArray">NewUntracedArray</A>(
    tc: Typecode;
    READONLY s: Shape): ADDRESS;
</PRE><BLOCKQUOTE><EM> Return a reference to a freshly allocated and initialized, untraced open
   array referent with typecode <CODE>tc</CODE> and sizes <CODE>s[0]</CODE>, ..., <CODE>s[LAST(s)]</CODE>.
   It is a checked runtime error if <CODE>tc</CODE> does not name an untraced
   reference to an open array, or if any <CODE>s[i]</CODE> is negative, or if
   <CODE>NUMBER(s)</CODE> does not equal the number of open dimensions of the
   array. </EM></BLOCKQUOTE><PRE>

END RTAllocator.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
