<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTAllocator.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTAllocator.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module>RTAllocator</module> EXPORTS <A HREF="RTAllocator.i3"><implements>RTAllocator</A></implements>, <A HREF="RTHooks.i3"><implements>RTHooks</A></implements>;

IMPORT <A HREF="../../../C/src/Common/Cstdlib.i3">Cstdlib</A>, <A HREF="RT0.i3">RT0</A>, <A HREF="#x1">RT0u</A>, <A HREF="RTMisc.i3">RTMisc</A>, <A HREF="RTOS.i3">RTOS</A>, <A HREF="RTType.i3">RTType</A>, <A HREF="../../../word/src/Word.i3">Word</A>;
FROM <A HREF="RTType.i3">RTType</A> IMPORT Typecode;
FROM <A HREF="RTMisc.i3">RTMisc</A> IMPORT FatalErrorI;
FROM <A HREF="RTHeapRep.i3">RTHeapRep</A> IMPORT Header, RefHeader, AllocForNew, Malloc;
</PRE> In the following procedures, <CODE>RTType.Get(tc)</CODE> will fail if <CODE>tc</CODE> is not
   proper. 

<P>----------------------------------------------------------- RTAllocator ---

<P> NewTraced returns a reference to a freshly allocated and initialized,
   traced referent with typecode <CODE>tc</CODE>.  It is a checked runtime error if
   <CODE>tc</CODE> does not name a traced reference type other than REFANY, or if
   its referent is an open array. 

<P><PRE>PROCEDURE <A NAME="NewTraced"><procedure>NewTraced</procedure></A>(tc: Typecode): REFANY =
  VAR def := RTType.Get(tc);
  BEGIN
    IF tc = 0 OR def.traced = 0 OR def.nDimensions # 0 THEN
      FatalErrorI(&quot;RTAllocator.NewTraced: improper typecode: &quot;, tc);
    END;
    RETURN Allocate(def);
  END NewTraced;
</PRE> NewUntraced returns a reference to a freshly allocated and initialized,
   untraced referent with typecode <CODE>tc</CODE>.  It is a checked runtime error if
   <CODE>tc</CODE> does not name an untraced reference type other than ADDRESS, or if
   it names an untraced object type, or if its referent is an open
   array. 

<P><PRE>PROCEDURE <A NAME="NewUntraced"><procedure>NewUntraced</procedure></A>(tc: Typecode): ADDRESS =
  VAR def := RTType.Get(tc);
  BEGIN
    IF tc = 0 OR def.traced # 0 OR def.defaultMethods # NIL
         OR def.nDimensions # 0 THEN
      FatalErrorI(&quot;RTAllocator.NewUntraced: improper typecode: &quot;, tc);
    END;
    RETURN AllocateUntracedRef(def);
  END NewUntraced;
</PRE> NewUntracedObject returns a freshly allocated and initialized, untraced
   object with typecode <CODE>tc</CODE>.  It is a checked runtime error if <CODE>tc</CODE> does
   not name an untraced object type. 

<P><PRE>PROCEDURE <A NAME="NewUntracedObject"><procedure>NewUntracedObject</procedure></A>(tc: Typecode): UNTRACED ROOT =
  VAR def := RTType.Get(tc);
  BEGIN
    IF tc = 0 OR def.traced # 0 OR def.defaultMethods = NIL THEN
      FatalErrorI(&quot;RTAllocator.NewUntracedObject: improper typecode:&quot;, tc);
    END;
    RETURN AllocateUntracedObj(def);
  END NewUntracedObject;
</PRE> NewTracedArray returns a reference to a freshly allocated and
   initialized, traced open array referent with typecode <CODE>tc</CODE> and sizes
   <CODE>s[0]</CODE>, ..., <CODE>s[LAST(s)]</CODE>.  It is a checked runtime error if <CODE>tc</CODE> does
   not name a traced reference to an open array, if any s[i] is negative,
   or if <CODE>NUMBER(s)</CODE> does not equal the number of open dimensions of the
   array. 

<P><PRE>PROCEDURE <A NAME="NewTracedArray"><procedure>NewTracedArray</procedure></A>(tc: Typecode; READONLY s: Shape): REFANY =
  VAR def := RTType.Get(tc);
  BEGIN
    IF tc = 0 OR def.traced = 0 OR def.nDimensions = 0 THEN
      FatalErrorI(&quot;RTAllocator.NewTracedArray: improper typecode: &quot;, tc);
    END;
    IF NUMBER(s) # def.nDimensions THEN
      FatalErrorI(&quot;RTAllocator.NewTracedArray: bad NUMBER(s): &quot;, NUMBER(s));
    END;
    RETURN AllocateOpenArray(def, s);
  END NewTracedArray;
</PRE> NewUntracedArray returns a reference to a freshly allocated and
   initialized, untraced open array referent with typecode <CODE>tc</CODE> and sizes
   <CODE>s[0]</CODE>, ..., <CODE>s[LAST(s)]</CODE>.  It is a checked runtime error if <CODE>tc</CODE> does
   not name an untraced reference to an open array, if any s[i] is
   negative, or if <CODE>NUMBER(s)</CODE> does not equal the number of open
   dimensions of the array. 

<P><PRE>PROCEDURE <A NAME="NewUntracedArray"><procedure>NewUntracedArray</procedure></A>(tc: Typecode; READONLY s: Shape): ADDRESS =
  VAR def := RTType.Get(tc);
  BEGIN
    IF tc = 0 OR def.traced # 0 OR def.nDimensions = 0 THEN
      FatalErrorI(&quot;RTAllocator.NewUntracedArray: improper typecode: &quot;, tc);
    END;
    IF NUMBER(s) # def.nDimensions THEN
      FatalErrorI(&quot;RTAllocator.NewUntracedArray: bad NUMBER(s): &quot;, NUMBER(s));
    END;
    RETURN AllocateUntracedOpenArray(def, s);
  END NewUntracedArray;
</PRE>--------------------------------------------------------------- RTHooks ---

<P><PRE>VAR
  initCache: ARRAY [0 .. 4095] OF ADDRESS; (* initialized contents for
                                              freshly allocated objects *)

PROCEDURE <A NAME="Allocate"><procedure>Allocate</procedure></A> (defn: ADDRESS): REFANY =
  VAR
    def : RT0.TypeDefn := defn;
    tc  : Typecode := def.typecode;
    res : ADDRESS;
  BEGIN
    RTOS.LockHeap();
    BEGIN
      WITH z = RT0u.alloc_cnts[tc] DO z := Word.Plus (z, 1) END;
      res := AllocForNew(def.dataSize, def.dataAlignment);
      IF (tc &lt;= LAST (initCache)) AND (initCache[tc] # NIL) THEN
        RTMisc.Copy(initCache[tc], res - ADRSIZE(Header),
                    def.dataSize + BYTESIZE(Header));
      ELSE
        LOOPHOLE(res - ADRSIZE(Header), RefHeader)^ :=
          Header{typecode := tc, forwarded := FALSE};
        RTMisc.Zero(res, def.dataSize);
        IF def.defaultMethods # NIL THEN
          LOOPHOLE(res, UNTRACED REF ADDRESS)^ := def.defaultMethods;
        END;
        VAR d := def;
        BEGIN
          WHILE d # NIL DO
            IF d.initProc # NIL THEN d.initProc(res); END;
            d := d.parent;
          END;
        END;
        IF (def.dataSize &lt;= BYTESIZE(def^)) AND (tc &lt;= LAST (initCache)) THEN
          initCache[tc] := Malloc(def.dataSize + BYTESIZE(Header));
          RTMisc.Copy(res - ADRSIZE(Header), initCache[tc],
                      BYTESIZE(Header) + def.dataSize);
        END;
      END;
    END;
    RTOS.UnlockHeap();
    RETURN LOOPHOLE(res, REFANY);
  END Allocate;

PROCEDURE <A NAME="AllocateUntracedRef"><procedure>AllocateUntracedRef</procedure></A> (defn: ADDRESS): ADDRESS =
  VAR
    def : RT0.TypeDefn := defn;
    res := Malloc(def.dataSize);
    tc  : Typecode := def.typecode;
  BEGIN
    WITH z = RT0u.alloc_cnts[tc] DO z := Word.Plus (z, 1) END;
    IF def.initProc # NIL THEN def.initProc(res); END;
    RETURN res;
  END AllocateUntracedRef;

PROCEDURE <A NAME="AllocateUntracedObj"><procedure>AllocateUntracedObj</procedure></A> (defn: ADDRESS): UNTRACED ROOT =
  VAR
    def     : RT0.TypeDefn := defn;
    hdrSize := MAX(BYTESIZE(Header), def.dataAlignment);
    res     := Malloc(hdrSize + def.dataSize) + hdrSize;
    tc      : Typecode := def.typecode;
    (* res requires special treatment by DisposeUntracedObj *)
  BEGIN
    WITH z = RT0u.alloc_cnts[tc] DO z := Word.Plus (z, 1) END;
    LOOPHOLE(res - ADRSIZE(Header), RefHeader)^ :=
      Header{typecode := tc, forwarded := FALSE};
    IF def.defaultMethods # NIL THEN
      LOOPHOLE(res, UNTRACED REF ADDRESS)^ := def.defaultMethods;
    END;
    WHILE def # NIL DO
      IF def.initProc # NIL THEN def.initProc(res); END;
      def := def.parent;
    END;
    RETURN res;
  END AllocateUntracedObj;

PROCEDURE <A NAME="AllocateOpenArray"><procedure>AllocateOpenArray</procedure></A> (defn: ADDRESS; READONLY s: Shape): REFANY =
  VAR
    def     : RT0.TypeDefn := defn;
    res     : ADDRESS;
    nbElems := OpenArrayCount(s);
    nBytes  := def.dataSize + nbElems * def.elementSize;
    tc      : Typecode := def.typecode;
  BEGIN
    RTOS.LockHeap();
    BEGIN
      WITH z = RT0u.alloc_cnts[tc]  DO z := Word.Plus (z, 1) END;
      WITH z = RT0u.alloc_bytes[tc] DO z := Word.Plus (z, nBytes) END;
      res := AllocForNew(RTMisc.Upper(nBytes, BYTESIZE(Header)),
                                   def.dataAlignment);
      LOOPHOLE(res - ADRSIZE(Header), RefHeader)^ :=
        Header{typecode := tc, forwarded := FALSE};
      LOOPHOLE(res, UNTRACED REF ADDRESS)^ := res + def.dataSize;
      FOR i := 0 TO NUMBER(s) - 1 DO
        LOOPHOLE(res + ADRSIZE(ADDRESS) + i * ADRSIZE(INTEGER),
                 UNTRACED REF INTEGER)^ := s[i];
      END;
      RTMisc.Zero(res + def.dataSize, nbElems * def.elementSize);
      WHILE def # NIL DO
        IF def.initProc # NIL THEN def.initProc(res); END;
        def := def.parent;
      END;
    END;
    RTOS.UnlockHeap();
    RETURN LOOPHOLE(res, REFANY);
  END AllocateOpenArray;

PROCEDURE <A NAME="AllocateUntracedOpenArray"><procedure>AllocateUntracedOpenArray</procedure></A> (defn : ADDRESS;
                            READONLY s    : Shape): ADDRESS =
  VAR
    def     : RT0.TypeDefn := defn;
    nbElems := OpenArrayCount(s);
    nBytes  := def.dataSize + nbElems * def.elementSize;
    res     := Malloc(nBytes);
    tc      : Typecode := def.typecode;
  BEGIN
    WITH z = RT0u.alloc_cnts[tc]  DO z := Word.Plus (z, 1) END;
    WITH z = RT0u.alloc_bytes[tc] DO z := Word.Plus (z, nBytes) END;
    LOOPHOLE(res, UNTRACED REF ADDRESS)^ := res + def.dataSize;
    FOR i := 0 TO NUMBER(s) - 1 DO
      LOOPHOLE(res + ADRSIZE(ADDRESS) + i * ADRSIZE(INTEGER),
               UNTRACED REF INTEGER)^ := s[i];
    END;
    WHILE def # NIL DO
      IF def.initProc # NIL THEN def.initProc(res); END;
      def := def.parent;
    END;
    RETURN res;
  END AllocateUntracedOpenArray;

PROCEDURE <A NAME="DisposeUntracedRef"><procedure>DisposeUntracedRef</procedure></A> (VAR a: ADDRESS) =
  BEGIN
    IF a # NIL THEN Cstdlib.free(a); a := NIL; END;
  END DisposeUntracedRef;

PROCEDURE <A NAME="DisposeUntracedObj"><procedure>DisposeUntracedObj</procedure></A> (VAR a: UNTRACED ROOT) =
  VAR def: RT0.TypeDefn;
  BEGIN
    IF a # NIL THEN
      def := RTType.Get (TYPECODE (a));
      Cstdlib.free (a - MAX(BYTESIZE(Header), def.dataAlignment));
      a := NIL;
    END;
  END DisposeUntracedObj;
</PRE>-------------------------------------------------------------- internal ---

<P> OpenArrayCount computes the number of elements given by a Shape.  It
   also checks that all bounds are non-negative. 

<P><PRE>PROCEDURE <A NAME="OpenArrayCount"><procedure>OpenArrayCount</procedure></A> (READONLY s: Shape): CARDINAL =
  VAR n := 1;
  BEGIN
    FOR i := 0 TO NUMBER(s) - 1 DO
      WITH si = s[i] DO
        IF (si &lt; 0) THEN
          RTMisc.FatalErrorI(&quot;negative size passed to NEW (open array): &quot;, si);
        END;
        n := si * n;
      END;
    END;
    RETURN n;
  END OpenArrayCount;

BEGIN
END RTAllocator.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface RT0u is in:
</A><UL>
<LI><A HREF="../POSIX/RT0u.i3#0TOP0">runtime/src/POSIX/RT0u.i3</A>
<LI><A HREF="../WIN32/RT0u.i3#0TOP0">runtime/src/WIN32/RT0u.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
