<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTCollector.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTCollector.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>RTCollector</CODE> provides control over the Modula-3 garbage collector.
   \index{collector}
   \index{garbage collector!control over}


<P><PRE>INTERFACE <interface><A HREF="RTCollector.m3">RTCollector</A></interface>;
</PRE> The purpose of a garbage collector is to reclaim unreachable
   nodes on the traced heap; most Modula-3 programs could not run
   very long without a collector.  Even so, automatic garbage
   collection has some practical drawbacks.
<P>
   \begin{enumerate}
   \item
<P>
      The collector might move heap nodes to different addresses.  This is
      usually unnoticable to programs, but can cause problems when programs
      must work with the addresses of heap nodes, since it is not
      guaranteed that <CODE>ADR(x^)</CODE> is a constant over the lifetime of
      <CODE>x^</CODE>.  There are two main cases when programs must work with
      such addresses.
<P>
      \begin{enumerate}
      \item
<P>
         To implement hash tables, etc.
<P>
      \item
<P>
         To pass addresses to procedures written in other languages,
         which is inherently unportable.
<P>
      \end{enumerate}
<P>
   \item
<P>
      Unsafe code can put the traced heap temporarily into an
      inconsistent state.  If the collector happens to run then, it
      might delete nodes that seem unreachable but that in fact are
      accessible.  Of course, unsafe code itself is inherently unportable.
<P>
   \end{enumerate}
<P>
   This interface allows the program to control the Modula-3 collector
   to avoid such problems, as well as to pass hints to improve
   performance. 

<P>
\paragraph*{Disabling the collector.}
<P>
   The collector is initially enabled; the collector can reclaim
   storage, and move nodes in memory.  While the collector is
   disabled, there will be no time spent in the collector.  Allocation
   in the traced heap may proceed normally, although the heap will
   grow without bound.  Nodes unreachable by the Modula-3 rules will
   not be reclaimed, and no nodes will move.  

<P><PRE>PROCEDURE <A HREF="RTCollector.m3#Disable">Disable</A>();
</PRE><BLOCKQUOTE><EM> Disable the collector. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTCollector.m3#Enable">Enable</A>();
</PRE><BLOCKQUOTE><EM> Reenable the collector if <CODE>Enable</CODE> has been called as many times as
   <CODE>Disable</CODE>.  It is a checked runtime error to call <CODE>Enable</CODE> more times
   than <CODE>Disable</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE><P>
\paragraph*{Disabling motion.}
<P>
   Disabling motion gives fewer guarantees than disabling the
   collector; while motion is disabled, it is guaranteed only that no
   nodes will move.  Disabling motion is no more expensive than
   disabling the entire collector, and may be cheaper in some
   implementations.  

<P><PRE>PROCEDURE <A HREF="RTCollector.m3#DisableMotion">DisableMotion</A>();
</PRE><BLOCKQUOTE><EM> Disable motion. While motion is disabled, no nodes will
   move.</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTCollector.m3#EnableMotion">EnableMotion</A>();
</PRE><BLOCKQUOTE><EM> Reenable motion if <CODE>EnableMotion</CODE> has been called as many times as
   <CODE>DisableMotion</CODE>, and <CODE>Enable</CODE> has been called as many times as
   <CODE>Disable</CODE>.  It is a checked runtime error to call <CODE>EnableMotion</CODE>
   more times than <CODE>DisableMotion</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE><P>
\paragraph*{Collecting.}
<P>
   Calling <CODE>Collect</CODE> is a hint from the program that now would be a
   good time for a collection (for example, if a large amount of
   storage has become unreachable, or if the program expects to wait
   some time for an external event).


<P><PRE>PROCEDURE <A HREF="RTCollector.m3#Collect">Collect</A>();
</PRE><BLOCKQUOTE><EM> Maybe collect now. </EM></BLOCKQUOTE><PRE>

END RTCollector.
</PRE><P>
\paragraph*{Implementation notes.}
<P>
   This section describes the implementation of the SRC Modula-3
   collector, as a guide to SRC Modula-3 programmers and as an
   indication of how this interface is matched to a particular
   implementation.  Portable programs must not take advantage of
   implementation details of the SRC Modula-3 collector.
<P>
   The SRC Modula-3 collector is an incremental, generational,
   conservative mostly-copying collector that uses VM protection on
   heap pages to be notified of certain heap accesses.
   \index{garbage collector!properties of}
<P>
   Because the SRC collector is conservative, an inaccessible node may
   be considered reachable if a bit-pattern either on a thread's stack
   or in its registers might be a reference to or into the node.
   Experience to date has not shown accidental node retention to be a
   problem.
<P>
   The SRC collector will not collect or move a node while any
   thread's stack or registers contains a reference to or into the
   node.  The SRC Modula-3 system guarantees that this will include
   references passed as value parameters.  This guarantee is useful
   for calling foreign procedures.
<P>
   <CODE>Disable</CODE> completes the current incremental collection, if any, and
   unprotects all heap pages, so that no page faults will occur while
   collection is disabled.  No new collections will start while
   collection is disabled.  The next collection after collection is
   reenabled will be total, as opposed to partial, since unprotecting
   the heap loses generational information.
<P>
   <CODE>DisableMotion</CODE> disables further collections from beginning.
   <CODE>DisableMotion</CODE> does not finish the current incremental collection,
   since the collector already guarantees that the program will not
   see addresses in the previous space.  No new collections will start
   while motion is disabled, so that the current space will not become
   the previous space.  It is not necessary to unprotect the heap.
<P>
   <CODE>Collect</CODE> completes the current incremental collection, if any, then
   performs a total collection before returning to the caller.
<P>
   The <CODE>@M3nogc</CODE> flag performs an initial call to <CODE>Disable</CODE>.
   \index{{\tt @{}M3nogc} command-line flag}
<P>
   The SRC collector also supports additional operations for
   controlling the frequency of collection, disabling and reenabling
   incremental and generational collection, reporting on collector
   performance, and so on.  These operations are accessible through the
   implementation-dependent <CODE>RTCollectorSRC</CODE> interface.
   \index{RTCollectorSRC interface@{\tt RTCollectorSRC} interface}


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
