<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTCollectorSRC.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTCollectorSRC.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>RTCollectorSRC</CODE> is an extension of <CODE>RTCollector</CODE>, specific to the SRC
   Modula-3 implementation. 

<P><PRE>INTERFACE <interface><A HREF="RTCollector.m3">RTCollectorSRC</A></interface>;
</PRE> \paragraph*{When to collect.}
<P>
   <CODE>StartCollection</CODE> and <CODE>FinishCollection</CODE> allow the programmer direct
   control over when to collect. 

<P><PRE>PROCEDURE <A HREF="RTCollector.m3#StartCollection">StartCollection</A>();
</PRE><BLOCKQUOTE><EM> Start a total collection, if none is in progress and if collection and
   motion are enabled. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTCollector.m3#FinishCollection">FinishCollection</A>();
</PRE><BLOCKQUOTE><EM> Finish the current collection, if one is on progress. </EM></BLOCKQUOTE><PRE>
</PRE> \paragraph*{Disabling VM protection.}
<P>
   The SRC collector uses VM protection to implement incremental and
   generational collection.  The SRC collector's use of VM protection is
   normally invisible to programs, but can complicate debugging Modula-3
   programs.
<P>
   The <CODE>DisableVM</CODE> and <CODE>EnableVM</CODE> procedures are analogous to
   <CODE>RTCollector</CODE>'s <CODE>DisableMotion</CODE> and <CODE>EnableMotion</CODE>, and allow the
   programmer to disable the use of VM protection.  Disabling VM protection
   does not disable the collector, but collections will be neither
   incremental nor generational.
<P>
   The <CODE>@M3novm</CODE> flag performs an initial call to <CODE>DisableVM</CODE>.
<P>
   The SRC collector cannot use VM protection at all on some
   architectures. 

<P><PRE>PROCEDURE <A HREF="RTCollector.m3#DisableVM">DisableVM</A>();
</PRE><BLOCKQUOTE><EM> Disable the use of VM protection.  While VM protection is disabled, no
   objects on the heap will be protected.</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTCollector.m3#EnableVM">EnableVM</A>();
</PRE><BLOCKQUOTE><EM> Reenable the use of VM protection if <CODE>EnableVM</CODE> has been called as many
   times as <CODE>DisableVM</CODE>.  It is a checked runtime error to call <CODE>EnableVM</CODE>
   more times than <CODE>DisableVM</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTCollector.m3#FinishVM">FinishVM</A>();
</PRE><BLOCKQUOTE><EM> Equivalent to <CODE>DisableVM{}; EnableVM()</CODE>.  <CODE>FinishVM</CODE> unprotects all heap
   pages, and is intended for use from the debugger. </EM></BLOCKQUOTE><PRE>
</PRE> \paragraph*{Tuning the SRC collector.}
<P>
   The following read/write parameters tune the SRC collector's
   performance.  They may be set by the client at any point, although they
   may not have an immediate effect. 

<P><PRE>VAR gcRatio := 1.0;              (* collector work / mutator work *)
</PRE><BLOCKQUOTE><EM> On the average, for every page allocated by the mutator, the collector
   will copy <CODE>gcRatio</CODE> pages.  Increase the ratio to keep the heap smaller;
   decrease it to spend less time in the collector. </EM></BLOCKQUOTE><PRE>

VAR incremental := TRUE;         (* incremental collection *)
</PRE><BLOCKQUOTE><EM> The collector can be incremental or stop-and-copy.  Incremental
   collection has much smaller interruptions of service, but takes more
   total time and more space.
<P>
   Assume there are ``A'' pages of accessible objects.  If <CODE>incremental</CODE> is
   FALSE, the heap must contain up to A * (2 + 1 / gcRatio) pages.  If
   <CODE>incremental</CODE> is TRUE, the heap must contain up to A * (2 + 2 / gcRatio)
   pages.  In other words, to keep the same space bounds, <CODE>gcRatio</CODE> must be
   twice as large in the incremental case.
<P>
   If VM protection is disabled or not available on the current
   architecture, the collector will behave as if <CODE>incremental</CODE> = FALSE.
<P>
   Use incremental collection when the program is interactive.
   Stop-and-copy collection gives better performance. </EM></BLOCKQUOTE><PRE>

VAR generational := TRUE;        (* generational collection *)
</PRE><BLOCKQUOTE><EM> Generational collection causes most collections to take much less time
   than specified above, while using only a little more memory.
   Generational collection has the greatest benefit when the program has a
   large number of accessible objects, but most new objects are discarded
   shortly after they are allocated.
<P>
   If VM protection is disabled or not available on the current
   architecture, the collector will behave as if <CODE>generational</CODE> = FALSE.
<P>
   Generational collection almost always leads to performance
   improvement. </EM></BLOCKQUOTE><PRE>
</PRE> \paragraph{Background Collection.}
<P>
   There is an optional ``background'' mode, which extends incremental mode
   with a background thread that moves collection ahead in the absence of
   program activity.  The background thread is tuned to cause insignificant
   interruption of other activities, but may therefore move the collection
   forward quite slowly. 

<P><PRE>PROCEDURE <A HREF="RTCollector.m3#StartBackgroundCollection">StartBackgroundCollection</A>();
</PRE><BLOCKQUOTE><EM> Starts the background thread, if not already started </EM></BLOCKQUOTE><PRE>

END RTCollectorSRC.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
