<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTException.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTException.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

UNSAFE INTERFACE <interface><A HREF="#x1">RTException</A></interface>;
</PRE> This interface provides access to the runtime machinery that
   raises exceptions.  The values of the types defined in this
   interface are generated by the compiler.  Changing any of the
   types below is dangerous. 

<P><PRE>TYPE
  ExceptionName = UNTRACED REF UNTRACED REF (*ARRAY OF*) CHAR;
  ExceptionList = UNTRACED REF (*ARRAY OF*) ExceptionName;
  ExceptionArg  = ADDRESS; (* actually, it's an untyped 4-byte field *)

PROCEDURE <A HREF="#x2">Raise</A> (ex: ExceptionName;  arg: ExceptionArg) RAISES ANY;
</PRE><BLOCKQUOTE><EM> raise the exception ex passing arg as the associated value </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x3">ResumeRaise</A> (ex: ExceptionName;  arg: ExceptionArg) RAISES ANY;
</PRE><BLOCKQUOTE><EM> after a TRY-FINALLY handler has been executed, restart the processing
   of the execption. It is known that there is a handler for this exception </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x4">DumpStack</A> ();
</PRE><BLOCKQUOTE><EM> If possible, produce a diagnostic stack dump on stderr </EM></BLOCKQUOTE><PRE>

END RTException.
</PRE>
</inInterface>
<HR>
<A NAME="x1">RTException's implementation  is in:
</A><UL>
<LI><A HREF="../ex_frame/RTException.m3#0TOP0">runtime/src/ex_frame/RTException.m3</A>
<LI><A HREF="../ex_stack/RTException.m3#0TOP0">runtime/src/ex_stack/RTException.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure RTException.Raise is in:
</A><UL>
<LI><A HREF="../ex_frame/RTException.m3#Raise">runtime/src/ex_frame/RTException.m3</A>
<LI><A HREF="../ex_stack/RTException.m3#Raise">runtime/src/ex_stack/RTException.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure RTException.ResumeRaise is in:
</A><UL>
<LI><A HREF="../ex_frame/RTException.m3#ResumeRaise">runtime/src/ex_frame/RTException.m3</A>
<LI><A HREF="../ex_stack/RTException.m3#ResumeRaise">runtime/src/ex_stack/RTException.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure RTException.DumpStack is in:
</A><UL>
<LI><A HREF="../ex_frame/RTException.m3#DumpStack">runtime/src/ex_frame/RTException.m3</A>
<LI><A HREF="../ex_stack/RTException.m3#DumpStack">runtime/src/ex_stack/RTException.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
