<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTHeap.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTHeap.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>RTHeap</CODE> provides access to the layout of data on the heap.
   \index{heap}
   \index{storage allocator}
   \index{allocator}


<P> Each referent on the heap, and the heap data record for each object, is
   represented as a contiguous sequence of ``data bytes''.  Referents and
   data records may also contain other ``non-data'' bytes like headers,
   method suite pointers, or open array shapes.
<P>
   See <CODE>RTType</CODE> for related operations on types. 

<P><PRE>INTERFACE <interface><A HREF="RTHeap.m3">RTHeap</A></interface>;

PROCEDURE <A HREF="RTHeap.m3#GetDataAdr">GetDataAdr</A>(r: REFANY): ADDRESS;
</PRE><BLOCKQUOTE><EM> If <CODE>r</CODE> is a traced reference, returns the address of <CODE>r^</CODE>'s data
   bytes.  If <CODE>r</CODE> is a traced object, returns the address of the bytes
   of <CODE>r</CODE>'s data record.  It is a checked runtime error if <CODE>r</CODE> is
   <CODE>NIL</CODE>.  Note that the address can subsequently change unless object
   mobility is disabled using <CODE>RTCollector</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTHeap.m3#GetDataSize">GetDataSize</A>(r: REFANY): CARDINAL;
</PRE><BLOCKQUOTE><EM> If <CODE>r</CODE> is a traced reference, returns the number of <CODE>r^</CODE>'s data
   bytes.  If <CODE>r</CODE> is a traced object, returns the number of bytes of
   <CODE>r</CODE>'s data record.  It is a checked runtime error if <CODE>r</CODE> is <CODE>NIL</CODE>.
   </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTHeap.m3#GetArrayShape">GetArrayShape</A>(r: REFANY; VAR s: ARRAY OF INTEGER);
</PRE><BLOCKQUOTE><EM> If <CODE>r</CODE> is a traced reference to an open array, returns in <CODE>s[0 ..  n-1]</CODE>
   the size of each dimension of the n-dimensional open array <CODE>r^</CODE>.  If <CODE>s</CODE>
   is too large, the extra elements are ignored; if it's too small, the
   extra sizes are discarded.  It is a checked runtime error if <CODE>r</CODE> is
   <CODE>NIL</CODE>.  If <CODE>r</CODE> is not a reference to an open array, <CODE>s</CODE> is unchanged. </EM></BLOCKQUOTE><PRE>

END RTHeap.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
