<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTHeapDebug.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTHeapDebug.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM><PRE>
                                                                  
</EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module><implements><A HREF="RTHeapDebug.i3">RTHeapDebug</A></implements></module>;

IMPORT <A HREF="RT0.i3">RT0</A>, <A HREF="RTCollector.i3">RTCollector</A>, <A HREF="RTHeapRep.i3">RTHeapRep</A>, <A HREF="RTHeapMap.i3">RTHeapMap</A>, <A HREF="RTIO.i3">RTIO</A>, <A HREF="RTParams.i3">RTParams</A>, <A HREF="RTTypeSRC.i3">RTTypeSRC</A>;
IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../weakref/src/WeakRef.i3">WeakRef</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

CONST (* Log[n_bytes] = j  =&gt;  2^j = n_bits,  n_bits = 8 * n_bytes *)
  Log = ARRAY [4..16] OF INTEGER {
          5, -1, -1, -1, 6, -1, -1, -1, -1, -1, -1, -1, 7 };

CONST
  MapGrain = 2 * BYTESIZE (RT0.RefHeader);  (* = 1 bit in the map *)
  MapBitsPerHeapPage = RTHeapRep.BytesPerPage DIV MapGrain;
  MapWordsPerHeapPage = MapBitsPerHeapPage DIV BITSIZE (Word.T);
  LogWordSize = Log [BYTESIZE (Word.T)];
  LogMapGrain = Log [MapGrain];

TYPE
  Path    = ARRAY [0..1023] OF INTEGER;
  Map     = REF ARRAY OF Word.T;
  IntList = REF ARRAY OF INTEGER;
  WRList  = REF ARRAY OF WeakRef.T;

TYPE
  Visitor = RTHeapMap.Visitor OBJECT
    freeAddrs : IntList := NIL;
    visited   : Map     := NIL;
    n_to_find : INTEGER := 0;
    heap_min  : INTEGER := 0;
    heap_max  : INTEGER := 0;
    path_len  : INTEGER := 0;
    path      : Path;
  OVERRIDES
    apply := WalkRefAtAddress;
  END;

VAR
  maxFree  : CARDINAL := GetMaxFree ();
  n_free   : CARDINAL := 0;
  freeRefs := NEW (WRList, maxFree);

PROCEDURE <A NAME="Free"><procedure>Free</procedure></A>(r: REFANY) =
  BEGIN
    freeRefs[ n_free MOD maxFree ] := WeakRef.FromRef (r);
    INC (n_free);
  END Free;

PROCEDURE <A NAME="WalkRefAtAddress"><procedure>WalkRefAtAddress</procedure></A>(v: Visitor;  a: ADDRESS) =
  VAR
    ref := LOOPHOLE(a, UNTRACED REF INTEGER)^;
    optr, map_bit, map_word, mask, visited: INTEGER;
  BEGIN
    IF ref = LOOPHOLE (NIL, INTEGER) THEN RETURN END;
    IF (v.n_to_find &lt;= 0) THEN RETURN END;
    IF (ref &lt; v.heap_min) OR (v.heap_max &lt;= ref) THEN RETURN END;

    map_bit  := Word.RightShift (ref - v.heap_min, LogMapGrain);
    map_word := Word.RightShift (map_bit, LogWordSize);
    mask     := Word.LeftShift (1, Word.And (map_bit, BITSIZE(Word.T)-1));
    visited  := v.visited [map_word];

    IF (Word.And (mask, visited) # 0) THEN (*already visited*) RETURN END;
    v.visited[map_word] := Word.Or (visited, mask);

    IF v.path_len = 0 THEN
      v.path[0] := LOOPHOLE(a, INTEGER);
      v.path_len := 1;
    END;

      FOR i := 0 TO v.n_to_find - 1 DO
        IF (v.freeAddrs[i] = ref) THEN
          Dump (v, a, ref);
          DEC (v.n_to_find);
          v.freeAddrs[i] := v.freeAddrs[v.n_to_find];
        END;
      END;

      IF (v.path_len &lt;= LAST (v.path)) THEN v.path[v.path_len] := ref; END;
      INC (v.path_len);

        optr := ref - BYTESIZE(RT0.RefHeader);
        RTHeapMap.WalkRef (LOOPHOLE (optr, RTHeapMap.ObjectPtr), v);

      DEC (v.path_len);

    IF v.path_len = 1 THEN DEC (v.path_len); END;
  END WalkRefAtAddress;

PROCEDURE <A NAME="Dump"><procedure>Dump</procedure></A> (v: Visitor;  loc: ADDRESS;  ref: INTEGER) =
  VAR tc: INTEGER;
  BEGIN
    Out (&quot;Path to 'free' object:\n&quot;, &quot;   Ref in root&quot;, v.path[0]);
    FOR j := 1 TO MIN (v.path_len-1, LAST (v.path)) DO
      tc := TYPECODE (LOOPHOLE(v.path[j], REFANY));
      Out (&quot;   Object of type &quot;, RTTypeSRC.TypecodeName(tc), v.path[j]);
    END;
    tc := TYPECODE (LOOPHOLE(ref, REFANY));
    Out (&quot;   Free object of type &quot;, RTTypeSRC.TypecodeName(tc),
         LOOPHOLE (loc, INTEGER));
  END Dump;

PROCEDURE <A NAME="Out"><procedure>Out</procedure></A> (a, b: TEXT;  i: INTEGER) =
  BEGIN
    IF (a # NIL) THEN RTIO.PutText (a); END;
    IF (b # NIL) THEN RTIO.PutText (b); END;
    RTIO.PutText (&quot; at address &quot;);
    RTIO.PutHex  (i);
    RTIO.PutText (&quot;...\n&quot;);
  END Out;

PROCEDURE <A NAME="CheckHeap"><procedure>CheckHeap</procedure></A>() =
  VAR
    v       := NEW (Visitor);
    n_pages := RTHeapRep.p1 - RTHeapRep.p0;
    old_ref := freeRefs;
    new_ref := NEW (WRList, maxFree);
    n_alive : CARDINAL := 0;
    ref     : REFANY;
  BEGIN
    v.freeAddrs := NEW (IntList, maxFree);
    v.visited   := NEW (Map, n_pages * MapWordsPerHeapPage);

    RTCollector.Disable();

      v.heap_min := RTHeapRep.p0 * RTHeapRep.BytesPerPage;
      v.heap_max := v.heap_min + n_pages * RTHeapRep.BytesPerPage;
      (* == the limits of the heap described by &quot;v.visited&quot; *)

      FOR i := 0 TO MIN (n_free, maxFree) - 1 DO
        ref := WeakRef.ToRef (old_ref[i]);
        IF ref # NIL THEN
          new_ref[n_alive] := old_ref[i];
          v.freeAddrs[n_alive] := LOOPHOLE (ref, INTEGER);
          INC (n_alive);
        END;
      END;

      freeRefs := new_ref;
      n_free := n_alive;

      IF n_alive &gt; 0 THEN
        v.n_to_find := n_alive;
        RTHeapMap.WalkGlobals(v);
      END;

    RTCollector.Enable();
    RTIO.Flush ();

    (* give the collector a chance... *)
    v.freeAddrs := NIL;
    v.visited   := NIL;
    v := NIL;
  END CheckHeap;

PROCEDURE <A NAME="GetMaxFree"><procedure>GetMaxFree</procedure></A> (): CARDINAL =
  VAR
    txt : TEXT    := RTParams.Value (&quot;heapDebugMaxFree&quot;);
    n   : INTEGER := 0;
    ch  : INTEGER;
  BEGIN
    IF (txt = NIL) OR Text.Length (txt) = 0 THEN RETURN MaxFree END;
    FOR i := 0 TO Text.Length(txt)-1 DO
      ch := ORD (Text.GetChar (txt, i)) - ORD ('0');
      IF (ch &lt; 0) OR (9 &lt; ch) THEN RETURN MaxFree END;
      n := 10 * n + ch;
    END;
    IF (n &gt; 0)
      THEN RETURN n;
      ELSE RETURN MaxFree;
    END;
  END GetMaxFree;

BEGIN
  &lt;*ASSERT BYTESIZE (REFANY) = BYTESIZE (INTEGER)*&gt;
END RTHeapDebug.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
