<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTHeapMap.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTHeapMap.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> RTHeapMap provides the routines needed by the collector
   to walk runtime values.


<P><PRE>INTERFACE <interface><A HREF="RTHeapMap.m3">RTHeapMap</A></interface>;

IMPORT <A HREF="RT0.i3">RT0</A>;

TYPE <A HREF="RTHeapMap.m3#Visitor">Visitor</A> &lt;: V_;  V_ = OBJECT METHODS apply (a: ADDRESS) END;
TYPE ObjectPtr = UNTRACED REF RT0.RefHeader;

PROCEDURE <A HREF="RTHeapMap.m3#WalkRef">WalkRef</A> (h: ObjectPtr;  v: Visitor);
</PRE><BLOCKQUOTE><EM> For each traced reference at address 'x' in the object referenced by 'h',
   call 'v(x)'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTHeapMap.m3#WalkGlobals">WalkGlobals</A> (v: Visitor);
</PRE><BLOCKQUOTE><EM> For each traced reference at address 'x' in a global var, call 'v(x)'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTHeapMap.m3#WalkModuleGlobals">WalkModuleGlobals</A> (v: Visitor;  m: CARDINAL);
</PRE><BLOCKQUOTE><EM> For each traced reference at address 'x' in a global variable of
   module 'm' (RTModule.Get(m)), call 'v(x)' </EM></BLOCKQUOTE><PRE>

END RTHeapMap.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
