<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTHeapMap.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTHeapMap.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="RTHeapMap.i3">RTHeapMap</A></implements></module>;

IMPORT <A HREF="RT0.i3">RT0</A>, <A HREF="RTType.i3">RTType</A>, <A HREF="RTHeapRep.i3">RTHeapRep</A>, <A HREF="RTModule.i3">RTModule</A>, <A HREF="RTMapOp.i3">RTMapOp</A>, <A HREF="RTIO.i3">RTIO</A>;

VAR DEBUG := FALSE;

TYPE
  Byte = RTMapOp.Byte;
  BP   = RTMapOp.BP;
  IP   = RTMapOp.IP;
  AP   = RTMapOp.AP;
  PC   = RTMapOp.PC;
  Op   = RTMapOp.T;

REVEAL
  <A NAME="Visitor">Visitor</A> = V_ BRANDED &quot;RTHeapMap.Visitor&quot; OBJECT
    stack: RTMapOp.Stack;
  END;
</PRE>------------------------------------------------ walking of single refs ---

<P><PRE>PROCEDURE <A NAME="WalkRef"><procedure>WalkRef</procedure></A> (h: ObjectPtr;  v: Visitor) =
  VAR
    tc: RT0.Typecode := h.typecode;
    t: RT0.TypeDefn;
  BEGIN
    IF (tc # RTHeapRep.Fill_1_type) AND (tc # RTHeapRep.Fill_N_type) THEN
      &lt;* ASSERT tc # 0 *&gt;
      t := RTType.Get (tc);
      IF DEBUG THEN
        RTIO.PutText (&quot;Ref: tc=&quot;);
        RTIO.PutInt  (tc);
        RTIO.PutText (&quot; cell=&quot;);
        RTIO.PutAddr (t);
        RTIO.PutText (&quot; ref=&quot;);
        RTIO.PutAddr (h + ADRSIZE (h^));
        RTIO.PutText(&quot;\n&quot;);
        RTIO.Flush ();
      END;
      DoWalkRef (t, h+ADRSIZE (h^), v);
    END;
  END WalkRef;

PROCEDURE <A NAME="DoWalkRef"><procedure>DoWalkRef</procedure></A> (t: RT0.TypeDefn;  a: ADDRESS;  v: Visitor) =
  BEGIN
    IF (t.parent # NIL) THEN
      DoWalkRef (t.parent, a, v);
      INC (a, t.dataOffset);
    END;
    Walk (a, t.gc_map, v);
  END DoWalkRef;
</PRE>------------------------------------------------ walking of the globals ---

<P><PRE>TYPE ModuleMap = UNTRACED REF ARRAY OF RT0.ModulePtr;
VAR global_map: ModuleMap := NIL;

PROCEDURE <A NAME="WalkGlobals"><procedure>WalkGlobals</procedure></A> (v: Visitor) =
  VAR m: RT0.ModulePtr;
  BEGIN
    IF (global_map = NIL) THEN BuildGlobalMap () END;
    FOR i := 0 TO LAST (global_map^) DO
      m := global_map[i];
      IF DEBUG THEN
        RTIO.PutText (&quot;Module: &quot;);
        RTIO.PutInt  (i);
        RTIO.PutText (&quot;  &quot;);
        RTIO.PutAddr (m);
        RTIO.PutText (&quot;\n&quot;);
        RTIO.Flush ();
      END;
      Walk (m, m.gc_map, v);
    END;
  END WalkGlobals;

PROCEDURE <A NAME="BuildGlobalMap"><procedure>BuildGlobalMap</procedure></A> () =
  VAR n: INTEGER;  m: RT0.ModulePtr;  max := RTModule.Count()-1;
  BEGIN
    (* first, count the modules that qualify *)
    n := 0;
    FOR i := 0 TO max DO
      m := RTModule.Get (i);
      IF (m # NIL) AND (m.gc_map # NIL) THEN INC (n); END;
    END;

    (* allocate the space *)
    global_map := NEW (ModuleMap, n);

    (* and fill it in *)
    n := 0;
    FOR i := 0 TO max DO
      m := RTModule.Get (i);
      IF (m # NIL) AND (m.gc_map # NIL) THEN
        global_map[n] := m;
        INC (n);
      END;
    END;
  END BuildGlobalMap;

PROCEDURE <A NAME="WalkModuleGlobals"><procedure>WalkModuleGlobals</procedure></A> (v: Visitor;  mod: CARDINAL) =
  VAR m := RTModule.Get (mod);
  BEGIN
    IF (m # NIL) AND (m.gc_map # NIL) THEN
      Walk (m, m.gc_map, v);
    END;
  END WalkModuleGlobals;
</PRE>------------------------------------------------------- internal walker ---

<P><PRE>PROCEDURE <A NAME="Walk"><procedure>Walk</procedure></A> (x, pc: ADDRESS;  v: Visitor) =
  VAR op: Op;  n, m, z: INTEGER;  bottom := v.stack.top;
  BEGIN
    IF (x = NIL) OR (pc = NIL) THEN RETURN END;
    IF DEBUG THEN
      RTIO.PutText (&quot;Walk: map=&quot;);
      RTIO.PutAddr (pc);
      RTIO.PutText (&quot; val=&quot;);
      RTIO.PutAddr (x);
      RTIO.PutText (&quot; visitor=&quot;);
      RTIO.PutAddr (LOOPHOLE (v, ADDRESS));
      RTIO.PutText (&quot;\n&quot;);
      RTIO.Flush ();
    END;
    LOOP
      op := LOOPHOLE (pc, PC)^;
      IF DEBUG THEN
        RTIO.PutText (&quot;  pc=&quot;);
        RTIO.PutAddr (pc);
        RTIO.PutText (&quot;  op=&quot;);
        RTIO.PutInt  (ORD (op));
        RTIO.PutText (&quot;\n&quot;);
        RTIO.Flush ();
      END;
      INC (pc, ADRSIZE (Op));
      CASE op OF
      | Op.Mark =&gt;
          RTMapOp.Push (v.stack, pc, -1);

      | Op.Stop =&gt;
          LOOP
            IF (v.stack.top &lt;= bottom) THEN RETURN END;
            (* otherwise, resume a suspended walk *)
            WITH tos = v.stack.data [v.stack.top-1] DO
              pc := tos.pc;
              DEC (tos.count);
              IF (tos.count &gt;= 0) THEN EXIT END;
              DEC (v.stack.top);
            END;
          END;

      | Op.Array_1, Op.Array_2, Op.Array_3, Op.Array_4,
        Op.Array_5, Op.Array_6, Op.Array_7, Op.Array_8 =&gt;
          z := RTMapOp.OpArgBytes [op];
          n := RTMapOp.GetInt (pc, z); (* number of elements *)
          WITH tos = v.stack.data [v.stack.top-1] DO
            IF tos.count = -1 THEN (* first time *) tos.count := n END;
            DEC (tos.count);
            IF (tos.count &gt; 0) THEN  pc := tos.pc  ELSE  DEC (v.stack.top) END;
          END;

      | Op.OpenArray_1, Op.OpenArray_2 =&gt;
          z := RTMapOp.OpArgBytes [op];
          n := RTMapOp.GetInt (pc, z); (* open array depth *)
          VAR elts := LOOPHOLE (x, AP)^;  (* array elements *) BEGIN
            INC (x, ADRSIZE (ADDRESS));

            (* compute the total number of elements to visit *)
            m := 1;
            FOR j := 1 TO n DO
              m := m * LOOPHOLE (x, IP)^;
              INC (x, ADRSIZE (INTEGER));
            END;

            (* push the remainder of the map with the element count *)
            IF (m &lt;= 0) THEN RETURN END;
            RTMapOp.Push (v.stack, pc, m-1);
            x := elts;
          END;

      | Op.Ref =&gt;
          v.apply (x);
          INC (x, ADRSIZE (ADDRESS));

      | Op.PushPtr =&gt;
          RTMapOp.Push (v.stack, x + ADRSIZE (AP), -1);
          x := LOOPHOLE (x, AP)^;

      | Op.Return =&gt;
          DEC (v.stack.top);
          x := v.stack.data [v.stack.top].pc;

      | Op.Skip_1, Op.Skip_2, Op.Skip_3, Op.Skip_4,
        Op.Skip_5, Op.Skip_6, Op.Skip_7, Op.Skip_8 =&gt;
          INC (x, RTMapOp.OpSize [op]);

      | Op.SkipF_1 =&gt;
          INC (x, LOOPHOLE (pc, BP)^);
          INC (pc, ADRSIZE (Byte));

      | Op.SkipF_2, Op.SkipF_3, Op.SkipF_4,
        Op.SkipF_5, Op.SkipF_6, Op.SkipF_7, Op.SkipF_8 =&gt;
          z := RTMapOp.OpArgBytes [op];
          n := RTMapOp.GetInt (pc, z);
          INC (x, n);

      | Op.SkipB_1 =&gt;
          DEC (x, LOOPHOLE (pc, BP)^);
          INC (pc, ADRSIZE (Byte));

      | Op.SkipB_2, Op.SkipB_3, Op.SkipB_4,
        Op.SkipB_5, Op.SkipB_6, Op.SkipB_7, Op.SkipB_8 =&gt;
          z := RTMapOp.OpArgBytes [op];
          n := RTMapOp.GetInt (pc, z);
          DEC (x, n);

      ELSE
          &lt;*ASSERT FALSE*&gt;
      END;
    END;
  END Walk;

BEGIN
END RTHeapMap.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
