<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTHeapStats.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTHeapStats.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> The code below makes the following NASTY assumption:
      ThreadF.ProcessStacks calls its argument twice for
      each thread -- the first time for the stack, the
      second time for its registers. 

<P><PRE>UNSAFE MODULE <module><implements><A HREF="RTHeapStats.i3">RTHeapStats</A></implements></module>;

IMPORT <A HREF="RT0.i3">RT0</A>, <A HREF="#x1">RT0u</A>, <A HREF="RTCollector.i3">RTCollector</A>, <A HREF="RTModule.i3">RTModule</A>, <A HREF="RTIO.i3">RTIO</A>, <A HREF="RTHeapMap.i3">RTHeapMap</A>, <A HREF="RTHeapRep.i3">RTHeapRep</A>, <A HREF="RTMisc.i3">RTMisc</A>;
IMPORT <A HREF="RTOS.i3">RTOS</A>, <A HREF="RTType.i3">RTType</A>, <A HREF="RTTypeSRC.i3">RTTypeSRC</A>, <A HREF="RTProcedure.i3">RTProcedure</A>, <A HREF="RTProcedureSRC.i3">RTProcedureSRC</A>, <A HREF="#x2">RTMachine</A>;
IMPORT <A HREF="#x3">ThreadF</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../../../text/src/Text.i3">Text</A>;
FROM <A HREF="RTIO.i3">RTIO</A> IMPORT PutInt, PutAddr, PutText;

TYPE
  Info = RECORD
    module    : RT0.ModulePtr;
    stack_min : ADDRESS;
    stack_max : ADDRESS;
    location  : ADDRESS;
    ref       : ADDRESS;
    n_objects : INTEGER;
    n_bytes   : INTEGER;
  END;

TYPE
  InfoSet = RECORD
    count : INTEGER;
    info  : ARRAY [0..19] OF Info;
  END;

TYPE
  VisitStack = ARRAY [0..10000] OF ADDRESS;

CONST
  MapGrain = 2 * BYTESIZE (RT0.RefHeader);  (* = 1 bit in the map *)
  MapBitsPerHeapPage = RTHeapRep.BytesPerPage DIV MapGrain;
  MapWordsPerHeapPage = MapBitsPerHeapPage DIV BITSIZE (Word.T);

VAR
  units       : InfoSet;
  unit_roots  : InfoSet;
  stacks      : InfoSet;
  stack_roots : InfoSet;
  stack_pages : InfoSet;
  map         : UNTRACED REF ARRAY OF Word.T;
  heap_min    : ADDRESS;
  heap_max    : ADDRESS;
  visit       : Info;
  is_registers: BOOLEAN;
  visit_stack : UNTRACED REF VisitStack;
  top_of_stack: INTEGER;
  n_overflows : INTEGER;
  last_alloc  : ADDRESS;
  outerVisitor: RTHeapMap.Visitor := NIL;
  innerVisitor: RTHeapMap.Visitor := NIL;
  rootVisitor : RTHeapMap.Visitor := NIL;

PROCEDURE <A NAME="ReportReachable"><procedure>ReportReachable</procedure></A> () =
  CONST MByte = 1024 * 1024;
  BEGIN
    (* allocate space for the stats *)
    outerVisitor := NEW (RTHeapMap.Visitor, apply := Visit);
    innerVisitor := NEW (RTHeapMap.Visitor, apply := InnerVisit);
    rootVisitor  := NEW (RTHeapMap.Visitor, apply := VisitRoot);
    visit_stack  := NEW (UNTRACED REF VisitStack);
    map := NEW (UNTRACED REF ARRAY OF Word.T,
                 (RTHeapRep.p1 - RTHeapRep.p0) * MapWordsPerHeapPage);

    (* initialize the globals *)
    units.count       := 0;
    unit_roots.count  := 0;
    stacks.count      := 0;
    stack_roots.count := 0;
    stack_pages.count := 0;
    top_of_stack      := 0;
    n_overflows       := 0;

    (* freeze the world *)
    RTCollector.Disable ();
    RTOS.LockHeap (); (* freeze the heap *)

    (* capture the heap limits *)
    heap_min  := LOOPHOLE (RTHeapRep.p0 * RTHeapRep.BytesPerPage, ADDRESS);
    heap_max  := LOOPHOLE (RTHeapRep.p1 * RTHeapRep.BytesPerPage, ADDRESS);

    PutText (&quot;\nHEAP: &quot;);
    PutAddr (heap_min);
    PutText (&quot; .. &quot;);
    PutAddr (heap_max);
    PutText (&quot; =&gt; &quot;);
    PutInt ((heap_max - heap_min) DIV MByte);
    PutText (&quot;.&quot;);
    PutInt ((heap_max - heap_min) * 10 DIV MByte MOD 10);
    PutText (&quot; Mbytes\n&quot;);

    (* find the edge of the new space *)
    last_alloc := LOOPHOLE (NEW (REF INTEGER), ADDRESS);

    FOR i := 0 TO RTModule.Count() - 1 DO GetUnitStats (i); END;
    FOR i := 0 TO RTModule.Count() - 1 DO GetUnitRootStats (i); END;
    is_registers := FALSE;
    ThreadF.ProcessStacks (GetThreadStats);
    is_registers := FALSE;
    ThreadF.ProcessStacks (GetThreadRootStats);
    is_registers := FALSE;
    ThreadF.ProcessStacks (GetThreadPageStats);

    IF (n_overflows &gt; 0) THEN
      PutText (&quot;  ** warning: &quot;);
      PutInt (n_overflows);
      PutText (&quot; paths, longer than &quot;);
      PutInt (NUMBER (VisitStack));
      PutText (&quot; REFs, were truncated.\n&quot;);
    END;

    ReportUnits ();
    ReportUnitRoots ();

    ReportStacks ();
    ReportStackRoots ();
    ReportStackPages ();

    ReportStackPCs ();
    ReportStackRootPCs ();
    ReportStackPagePCs ();
    RTIO.Flush ();

    (* thaw the world *)
    DISPOSE (visit_stack);
    DISPOSE (map);
    RTOS.UnlockHeap (); (* unfreeze the heap *)
    RTCollector.Enable ();
  END ReportReachable;
</PRE>------------------------------------------------------------ REF visits ---

<P><PRE>PROCEDURE <A NAME="ResetVisitCounts"><procedure>ResetVisitCounts</procedure></A> () =
  BEGIN
    visit.n_objects := 0;
    visit.n_bytes   := 0;
    top_of_stack    := 0;
    RTMisc.Zero (ADR (map[0]), BYTESIZE (map^));
  END ResetVisitCounts;

PROCEDURE <A NAME="AddVisit"><procedure>AddVisit</procedure></A> (VAR s: InfoSet) =
  VAR n: INTEGER;
  BEGIN
    (* if the set isn't full, make room for this visit *)
    IF (s.count &lt; NUMBER (s.info)) THEN
      s.info[s.count].n_bytes := -1;
      INC (s.count);
    END;

    (* find where to insert this visit *)
    n := s.count-1;
    WHILE (n &gt;= 0) AND (s.info[n].n_bytes &lt; visit.n_bytes) DO
      IF (n &lt; LAST(s.info)) THEN s.info[n+1] := s.info[n]; END;
      DEC (n);
    END;
    INC (n);

    (* insert the new root *)
    IF (n &lt; s.count) THEN  s.info[n] := visit;  END;
  END AddVisit;

PROCEDURE <A NAME="Visit"><procedure>Visit</procedure></A> (&lt;*UNUSED*&gt; self: RTHeapMap.Visitor;  loc: ADDRESS) =
  BEGIN
    InnerVisit (NIL, loc);
    WHILE (top_of_stack &gt; 0) DO
      DEC (top_of_stack);
      RTHeapMap.WalkRef (visit_stack[top_of_stack], innerVisitor);
    END;
  END Visit;

PROCEDURE <A NAME="InnerVisit"><procedure>InnerVisit</procedure></A> (&lt;*UNUSED*&gt; self: RTHeapMap.Visitor;  loc: ADDRESS) =
  CONST Mask = ADRSIZE (RT0.RefHeader) - 1; (* assume it's 2^k-1 for some k *)
  VAR ptr : UNTRACED REF ADDRESS := loc;
  VAR ref : ADDRESS := ptr^;
  VAR header: RTHeapMap.ObjectPtr;
  VAR cell, word, bit, mask, typecode: INTEGER;
  BEGIN
    header := ref - ADRSIZE (RT0.RefHeader);
    IF (heap_min &lt;= ref) AND (ref &lt; heap_max)
      AND (Word.And (LOOPHOLE(ref, INTEGER), Mask) = 0) THEN
      typecode := header.typecode;
      IF (0 &lt; typecode) AND (typecode &lt; RT0u.nTypes) THEN
        cell := (ref - heap_min) DIV MapGrain;
        word := cell DIV BITSIZE (Word.T);
        bit  := cell - word * BITSIZE (Word.T);
        mask := Word.LeftShift (1, bit);
        IF (Word.And (mask, map[word]) = 0) THEN
          (* this is a new ref... *)
          map[word] := Word.Or (mask, map[word]);
          INC (visit.n_objects);
          INC (visit.n_bytes, DataSize (header) + BYTESIZE (RT0.RefHeader));
          IF (top_of_stack &lt; NUMBER (VisitStack)) THEN
            visit_stack [top_of_stack] := header;
            INC (top_of_stack);
          ELSE
            INC (n_overflows);
          END;
        END;
      END;
    END;
  END InnerVisit;

PROCEDURE <A NAME="DataSize"><procedure>DataSize</procedure></A> (h: RTHeapMap.ObjectPtr): CARDINAL =
  VAR
    res : INTEGER;
    tc  : RT0.Typecode := h.typecode;
    def : RT0.TypeDefn;
  BEGIN
    IF tc = RTHeapRep.Fill_1_type THEN RETURN 0; END;
    IF tc = RTHeapRep.Fill_N_type THEN
      res := LOOPHOLE(h + ADRSIZE(RT0.RefHeader), UNTRACED REF INTEGER)^;
      RETURN res - BYTESIZE(RT0.RefHeader);
    END;
    def := RTType.Get (tc);
    IF def.nDimensions = 0 THEN
      (* the typecell datasize tells the truth *)
      RETURN def.dataSize;
    END;
    (* ELSE, the referent is an open array; it has the following layout:
|         pointer to the elements (ADDRESS)
|         size 1
|         ....
|         size n
|         optional padding
|         elements
|         ....
       where n is the number of open dimensions (given by the definition)
       and each size is the number of elements along the dimension *)
    VAR
      sizes: UNTRACED REF INTEGER := h + ADRSIZE(RT0.RefHeader)
                                       + ADRSIZE(ADDRESS);  (* ^ elt pointer*)
    BEGIN
      res := 1;
      FOR i := 0 TO def.nDimensions - 1 DO
        res := res * sizes^;
        INC(sizes, ADRSIZE(sizes^));
      END;
      res := res * def.elementSize;
    END;
    res := RTMisc.Upper(res + def.dataSize, BYTESIZE(RT0.RefHeader));
    RETURN res;
  END DataSize;

PROCEDURE <A NAME="TypeName"><procedure>TypeName</procedure></A> (ref: ADDRESS): TEXT =
  VAR header: RTHeapMap.ObjectPtr;
  VAR typecode: INTEGER;
  BEGIN
    header := ref - ADRSIZE (RT0.RefHeader);
    IF (heap_min &lt;= ref) AND (ref &lt; heap_max) THEN
      typecode := header.typecode;
      IF (0 &lt; typecode) AND (typecode &lt; RT0u.nTypes) THEN
        RETURN RTTypeSRC.TypecodeName (typecode);
      END;
    END;
    RETURN &quot;?&quot;;
  END TypeName;
</PRE>----------------------------------------------------------------- units ---

<P><PRE>PROCEDURE <A NAME="GetUnitStats"><procedure>GetUnitStats</procedure></A> (n: CARDINAL) =
  BEGIN
    visit.module     := RTModule.Get (n);
    visit.stack_min  := NIL;
    visit.stack_max  := NIL;
    visit.location   := NIL;
    visit.ref        := NIL;
    ResetVisitCounts ();
    RTHeapMap.WalkModuleGlobals (outerVisitor, n);
    AddVisit (units);
  END GetUnitStats;

PROCEDURE <A NAME="GetUnitRootStats"><procedure>GetUnitRootStats</procedure></A> (n: CARDINAL) =
  BEGIN
    visit.module     := RTModule.Get (n);
    visit.stack_min  := NIL;
    visit.stack_max  := NIL;
    visit.location   := NIL;
    visit.ref        := NIL;
    RTHeapMap.WalkModuleGlobals (rootVisitor, n);
  END GetUnitRootStats;

PROCEDURE <A NAME="VisitRoot"><procedure>VisitRoot</procedure></A> (&lt;*UNUSED*&gt; self: RTHeapMap.Visitor;  root: ADDRESS) =
  VAR p: UNTRACED REF ADDRESS := root;
  BEGIN
    visit.location := root;
    visit.ref      := p^;
    ResetVisitCounts ();
    Visit (NIL, root);
    AddVisit (unit_roots);
  END VisitRoot;
</PRE>--------------------------------------------------------------- threads ---

<P><PRE>PROCEDURE <A NAME="GetThreadStats"><procedure>GetThreadStats</procedure></A> (start, stop: ADDRESS) =
  VAR fp := start;  p: ADDRESS;  page: INTEGER;
  BEGIN
    IF (NOT is_registers) THEN
      visit.module     := NIL;
      visit.stack_min  := start;
      visit.stack_max  := stop;
      visit.location   := NIL;
      visit.ref        := NIL;
      ResetVisitCounts ();
    END;

    (* scan the stack or registers *)
    WHILE fp &lt;= stop DO
      p := LOOPHOLE(fp, UNTRACED REF ADDRESS)^;
      IF heap_min &lt;= p AND p &lt; heap_max THEN
        page := (p - heap_min) DIV RTHeapRep.BytesPerPage;
        IF RTHeapRep.desc[page].space = RTHeapRep.Space.Current THEN
          VisitPage (page);
        END;
      END;
      INC(fp, RTMachine.PointerAlignment);
    END;

    IF (is_registers) THEN AddVisit (stacks); END;
    is_registers := NOT is_registers;
  END GetThreadStats;

PROCEDURE <A NAME="GetThreadRootStats"><procedure>GetThreadRootStats</procedure></A> (start, stop: ADDRESS) =
  VAR fp := start;  p: ADDRESS;  page: INTEGER;
  BEGIN
    IF (is_registers) THEN
      visit.location   := NIL;
    ELSE
      visit.module     := NIL;
      visit.stack_min  := start;
      visit.stack_max  := stop;
    END;

    (* scan the stack *)
    WHILE fp &lt;= stop DO
      p := LOOPHOLE(fp, UNTRACED REF ADDRESS)^;
      IF heap_min &lt;= p AND p &lt; heap_max THEN
        page := (p - heap_min) DIV RTHeapRep.BytesPerPage;
        IF RTHeapRep.desc[page].space = RTHeapRep.Space.Current THEN
          IF (NOT is_registers) THEN visit.location := fp; END;
          visit.ref      := p;
          ResetVisitCounts ();
          Visit (NIL, fp);
          AddVisit (stack_roots);
        END;
      END;
      INC(fp, RTMachine.PointerAlignment);
    END;

    is_registers := NOT is_registers;
  END GetThreadRootStats;

PROCEDURE <A NAME="GetThreadPageStats"><procedure>GetThreadPageStats</procedure></A> (start, stop: ADDRESS) =
  VAR fp := start;  p: ADDRESS;  page: INTEGER;
  BEGIN
    IF (is_registers) THEN
      visit.location   := NIL;
    ELSE
      visit.module     := NIL;
      visit.stack_min  := start;
      visit.stack_max  := stop;
    END;

    (* scan the stack *)
    WHILE fp &lt;= stop DO
      p := LOOPHOLE(fp, UNTRACED REF ADDRESS)^;
      IF heap_min &lt;= p AND p &lt; heap_max THEN
        page := (p - heap_min) DIV RTHeapRep.BytesPerPage;
        IF RTHeapRep.desc[page].space = RTHeapRep.Space.Current THEN
          IF (NOT is_registers) THEN visit.location := fp; END;
          visit.ref      := p;
          ResetVisitCounts ();
          VisitPage (page);
          AddVisit (stack_pages);
        END;
      END;
      INC(fp, RTMachine.PointerAlignment);
    END;

    is_registers := NOT is_registers;
  END GetThreadPageStats;

PROCEDURE <A NAME="VisitPage"><procedure>VisitPage</procedure></A> (page: INTEGER) =
  VAR start, stop: ADDRESS;  h: RTHeapMap.ObjectPtr;  ref: ADDRESS;
  BEGIN
    (* find the address limits of this &quot;page&quot; *)
    WHILE (page &gt; 0)
      AND (RTHeapRep.desc[page].space = RTHeapRep.Space.Current)
      AND (RTHeapRep.desc[page].continued) DO
      DEC (page);
    END;
    start := heap_min + page * RTHeapRep.BytesPerPage;
    REPEAT
      INC (page);
    UNTIL (page &gt;= RTHeapRep.p1-RTHeapRep.p0)
       OR (RTHeapRep.desc[page].space # RTHeapRep.Space.Current)
       OR (NOT RTHeapRep.desc[page].continued);
    stop := heap_min + page * RTHeapRep.BytesPerPage;

    IF (start &lt;= last_alloc) AND (last_alloc &lt; stop) THEN
      (* we're on the allocator's partial page... *)
      stop := last_alloc;
    END;

    (* visit each object on the page *)
    h := start;
    WHILE (h &lt; stop) AND (h.typecode # 0) DO
      ref := h + ADRSIZE (RT0.RefHeader);
      Visit (NIL, ADR (ref));
      INC (h, DataSize (h) + ADRSIZE (RT0.RefHeader));
    END;
  END VisitPage;
</PRE>--------------------------------------------------------------- reports ---

<P><PRE>PROCEDURE <A NAME="ReportUnits"><procedure>ReportUnits</procedure></A> () =
  BEGIN
    PutText (&quot;\nModule globals:\n&quot;);
    PutText (&quot; # objects   # bytes  unit\n&quot;);
    PutText (&quot; ---------  --------  -----------------\n&quot;);
    FOR i := 0 TO units.count-1 DO
      WITH m = units.info[i] DO
        IF (m.n_bytes &gt; 0) THEN
          PutInt (m.n_objects, 10);
          PutInt (m.n_bytes, 10);
          PutText (&quot;  &quot;);
          PutStr  (PathTail (m.module.file));
          PutText (&quot;\n&quot;);
        END;
      END;
    END;
  END ReportUnits;

PROCEDURE <A NAME="ReportUnitRoots"><procedure>ReportUnitRoots</procedure></A> () =
  BEGIN
    PutText (&quot;\nGlobal variable roots:\n&quot;);
    PutText (&quot; # objects   # bytes         ref type                location\n&quot;);
    PutText (&quot; ---------  --------  ---------- -----------------   ------------------------\n&quot;);
    FOR i := 0 TO unit_roots.count-1 DO
      WITH r = unit_roots.info[i] DO
        IF (r.n_bytes &gt; 0) THEN
          PutInt  (r.n_objects, 10);
          PutInt  (r.n_bytes, 10);
          PutText (&quot;  &quot;);
          PutAddr (r.ref);
          PutText (&quot; &quot;);
          PadText (TypeName (r.ref), 18);
          PutText (&quot;  &quot;);
          PutStr  (PathTail (r.module.file));
          PutText (&quot; + &quot;);
          PutInt (r.location - r.module);
          PutText (&quot;\n&quot;);
        END;
      END;
    END;
  END ReportUnitRoots;

PROCEDURE <A NAME="ReportStacks"><procedure>ReportStacks</procedure></A> () =
  BEGIN
    PutText (&quot;\nThread stacks (conservative page scan):\n&quot;);
    PutText (&quot; # objects   # bytes  stack bounds\n&quot;);
    PutText (&quot; ---------  --------  ------------------------\n&quot;);
    FOR i := 0 TO stacks.count-1 DO
      WITH t = stacks.info[i] DO
        IF (t.n_bytes &gt; 0) THEN
          PutInt (t.n_objects, 10);
          PutInt (t.n_bytes, 10);
          PutText (&quot;  [&quot;);
          PutAddr (t.stack_min);
          PutText (&quot;..&quot;);
          PutAddr (t.stack_max);
          PutText (&quot;]\n&quot;);
        END;
      END;
    END;
  END ReportStacks;

PROCEDURE <A NAME="ReportStackPCs"><procedure>ReportStackPCs</procedure></A> () =
  VAR stack_mid: ADDRESS;
  BEGIN
    PutText (&quot;\nThread stack PCs:\n&quot;);
    PutText (&quot;     SP         PC     procedure\n&quot;);
    PutText (&quot;----------  ---------  ------------------------\n&quot;);
    FOR i := 0 TO stacks.count-1 DO
      WITH t = stacks.info[i] DO
        IF (t.n_bytes &gt; 0) THEN
          PutText (&quot;                          [&quot;);
          PutAddr (t.stack_min);
          PutText (&quot;..&quot;);
          PutAddr (t.stack_max);
          PutText (&quot;]\n&quot;);
          stack_mid := t.stack_min + (t.stack_max - t.stack_min) DIV 2;
          ReportPCs (t.stack_min, stack_mid, 5, +1);
          PutText (&quot;  ...\n&quot;);
          ReportPCs (t.stack_max, stack_mid, 5, -1);
          PutText (&quot;\n&quot;);
        END;
      END;
    END;
  END ReportStackPCs;

PROCEDURE <A NAME="ReportStackRoots"><procedure>ReportStackRoots</procedure></A> () =
  BEGIN
    PutText (&quot;\nThread stack roots (optimistic):\n&quot;);
    ReportStackInfo (stack_roots);
  END ReportStackRoots;

PROCEDURE <A NAME="ReportStackPages"><procedure>ReportStackPages</procedure></A> () =
  BEGIN
    PutText (&quot;\nThread stack roots (conservative page scan):\n&quot;);
    ReportStackInfo (stack_pages);
  END ReportStackPages;

PROCEDURE <A NAME="ReportStackInfo"><procedure>ReportStackInfo</procedure></A> (READONLY s: InfoSet) =
  BEGIN
    PutText (&quot; # objects   # bytes         ref type                location\n&quot;);
    PutText (&quot; ---------  --------  ---------- -----------------   ------------------------\n&quot;);
    FOR i := 0 TO s.count-1 DO
      WITH r = s.info[i] DO
        IF (r.n_bytes &gt; 0) THEN
          PutInt  (r.n_objects, 10);
          PutInt  (r.n_bytes, 10);
          PutText (&quot;  &quot;);
          PutAddr (r.ref);
          PutText (&quot; &quot;);
          PadText (TypeName (r.ref), 18);
          PutText (&quot;  &quot;);
          IF (r.location # NIL) THEN
            PutText (&quot;sp+&quot;);
            PutInt  (r.location - r.stack_min);
          ELSE
            PutText (&quot;register&quot;);
          END;
          PutText (&quot; in [&quot;);
          PutAddr (r.stack_min);
          PutText (&quot;..&quot;);
          PutAddr (r.stack_max);
          PutText (&quot;]&quot;);
          PutText (&quot;\n&quot;);
        END;
      END;
    END;
  END ReportStackInfo;

PROCEDURE <A NAME="ReportStackRootPCs"><procedure>ReportStackRootPCs</procedure></A> () =
  BEGIN
    PutText (&quot;\nThread stack root PCs (optimistic):\n&quot;);
    ReportStackInfoPCs (stack_roots);
  END ReportStackRootPCs;

PROCEDURE <A NAME="ReportStackPagePCs"><procedure>ReportStackPagePCs</procedure></A> () =
  BEGIN
    PutText (&quot;\nThread stack root PCs (conservative page scan):\n&quot;);
    ReportStackInfoPCs (stack_pages);
  END ReportStackPagePCs;

PROCEDURE <A NAME="ReportStackInfoPCs"><procedure>ReportStackInfoPCs</procedure></A> (READONLY s: InfoSet) =
  VAR m: ARRAY [0..LAST(s.info)] OF INTEGER;  xx, xy: ADDRESS;
  BEGIN
    (* first, sort the set by location *)
    m[0] := 0;
    FOR i := 1 TO s.count-1 DO
      VAR j := i-1; key := s.info[i].location;  BEGIN
        WHILE (j &gt;= 0) AND (s.info[m[j]].location &gt; key) DO
          m[j+1] := m[j];
          DEC (j);
        END;
        m[j+1] := i;
      END;
    END;

    PutText (&quot;     SP         PC     location\n&quot;);
    PutText (&quot;----------  ---------  ------------------------\n&quot;);
    FOR i := 0 TO s.count-1 DO
      WITH r = s.info[m[i]] DO
        IF (r.n_bytes &gt; 0) AND (r.location # NIL) THEN
          xy := r.location - RTMachine.PointerAlignment;
          IF (i = 0) OR (s.info[m[i-1]].location = NIL) OR
            (s.info[m[i-1]].stack_min # r.stack_min) THEN
            (* this is the first entry on this stack *)
            xx := xy + (r.stack_min - xy) DIV 2;
            PutAddr (r.stack_min, 10);
            PutText (&quot;              [&quot;);
            PutAddr (r.stack_min);
            PutText (&quot;..&quot;);
            PutAddr (r.stack_max);
            PutText (&quot;]\n&quot;);
            ReportPCs (r.stack_min, xx, 3, +1);
          ELSE
            xx := xy + (s.info[m[i-1]].location - xy) DIV 2;
          END;
          PutText (&quot;...\n&quot;);
          ReportPCs (xy, xx, 3, -1);
          PutAddr (r.location, 10);
          PutText (&quot;                &quot;);
          PutText (&quot;sp+&quot;);
          PutInt (r.location - r.stack_min);
          PutText (&quot;\n&quot;);
          xy := r.location + RTMachine.PointerAlignment;
          IF (i = s.count-1) OR (s.info[m[i+1]].location = NIL) OR
            (s.info[m[i+1]].stack_min # r.stack_min) THEN
            (* this is the last entry on this stack *)
            xx := xy + (r.stack_max - xy) DIV 2;
            ReportPCs (xy, xx, 3, +1);
            PutText (&quot;...\n&quot;);
            ReportPCs (r.stack_max, xx, 3, -1);
            PutAddr (r.stack_max, 10);
            PutText (&quot;\n\n&quot;);
          ELSE
            xx := xy + (s.info[m[i+1]].location - xy) DIV 2;
            ReportPCs (xy, xx, 3, +1);
          END;
        END;
      END;
    END;
  END ReportStackInfoPCs;
</PRE>--------------------------------------------------------------- PC info ---

<P><PRE>CONST
  Max_proc = 4096;  (* good enough for 99% of the procedures *)

TYPE
  PCInfo = RECORD
    loc  : ADDRESS;
    pc   : ADDRESS;
    proc : RTProcedure.Proc;
    file : RTProcedureSRC.Name;
    name : RTProcedureSRC.Name;
  END;

PROCEDURE <A NAME="ReportPCs"><procedure>ReportPCs</procedure></A> (start, stop: ADDRESS;  max, dir: INTEGER) =
  VAR
    x   : ARRAY [0..9] OF PCInfo;
    cnt := FindPCs (start, stop, SUBARRAY (x, 0, MIN (max, NUMBER(x))));
    a, b: INTEGER;
  BEGIN
    a := 0;
    b := cnt-1;
    IF (dir &lt; 0) THEN a := b; b := 0; END;
    FOR i := a TO b BY dir DO
      WITH p = x[i] DO
        PutAddr (p.loc, 10);
        PutText (&quot; &quot;);
        PutAddr (p.pc, 10);
        PutText (&quot;  &quot;);
        PutStr  (p.name);
        IF (p.pc # p.proc) THEN
          PutText (&quot; + &quot;);
          PutInt (p.pc - p.proc);
        END;
        IF (p.file # NIL) THEN
          PutText (&quot; in &quot;);
          PutStr  (PathTail (p.file));
        END;
        PutText (&quot;\n&quot;);
      END;
    END;
  END ReportPCs;

PROCEDURE <A NAME="FindPCs"><procedure>FindPCs</procedure></A> (start, stop: ADDRESS;  VAR x: ARRAY OF PCInfo): INTEGER =
  VAR n := 0;  fp: UNTRACED REF ADDRESS := start;
  BEGIN
    IF (start &lt; stop) THEN
      WHILE (fp &lt; stop) AND (n &lt; NUMBER (x)) DO
        WITH p = x[n] DO
          p.loc := fp;
          p.pc  := fp^;
          RTProcedureSRC.FromPC (p.pc, p.proc, p.file, p.name);
          IF (p.proc # NIL) AND (p.pc - p.proc &lt; Max_proc) THEN INC (n) END;
        END;
        INC (fp, RTMachine.PointerAlignment);
      END;
    ELSE
      WHILE (fp &gt; stop) AND (n &lt; NUMBER (x)) DO
        WITH p = x[n] DO
          p.loc := fp;
          p.pc := fp^;
          RTProcedureSRC.FromPC (p.pc, p.proc, p.file, p.name);
          IF (p.proc # NIL) AND (p.pc - p.proc &lt; Max_proc) THEN INC (n) END;
        END;
        DEC (fp, RTMachine.PointerAlignment);
      END;
    END;
    RETURN n;
  END FindPCs;
</PRE>--------------------------------------------------------- low-level I/O ---

<P><PRE>PROCEDURE <A NAME="PathTail"><procedure>PathTail</procedure></A> (a: ADDRESS): ADDRESS =
  VAR p0 : UNTRACED REF CHAR := a;  p := p0;
  BEGIN
    IF (p0 = NIL) THEN RETURN NIL END;
    WHILE (p^ # '\000') DO
      IF (p^ = '/') THEN p0 := p + ADRSIZE (p^); END;
      INC (p, ADRSIZE (p^));
    END;
    RETURN p0;
  END PathTail;

PROCEDURE <A NAME="PutStr"><procedure>PutStr</procedure></A> (s: ADDRESS) =
  BEGIN
    IF (s = NIL) THEN RETURN END;
    RTIO.PutString (s);
  END PutStr;

PROCEDURE <A NAME="PadText"><procedure>PadText</procedure></A> (t: TEXT;  width := 0) =
  VAR len := Text.Length (t);
  BEGIN
    RTIO.PutText (t);
    WHILE (len &lt; width) DO
      RTIO.PutChar (' ');
      INC (len);
    END;
  END PadText;

BEGIN
END RTHeapStats.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface RT0u is in:
</A><UL>
<LI><A HREF="../POSIX/RT0u.i3#0TOP0">runtime/src/POSIX/RT0u.i3</A>
<LI><A HREF="../WIN32/RT0u.i3#0TOP0">runtime/src/WIN32/RT0u.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface RTMachine is in:
</A><UL>
<LI><A HREF="../AIX386/RTMachine.i3#0TOP0">runtime/src/AIX386/RTMachine.i3</A>
<LI><A HREF="../ALPHA_OSF/RTMachine.i3#0TOP0">runtime/src/ALPHA_OSF/RTMachine.i3</A>
<LI><A HREF="../AP3000/RTMachine.i3#0TOP0">runtime/src/AP3000/RTMachine.i3</A>
<LI><A HREF="../ARM/RTMachine.i3#0TOP0">runtime/src/ARM/RTMachine.i3</A>
<LI><A HREF="../DS3100/RTMachine.i3#0TOP0">runtime/src/DS3100/RTMachine.i3</A>
<LI><A HREF="../FreeBSD/RTMachine.i3#0TOP0">runtime/src/FreeBSD/RTMachine.i3</A>
<LI><A HREF="../FreeBSD2/RTMachine.i3#0TOP0">runtime/src/FreeBSD2/RTMachine.i3</A>
<LI><A HREF="../HP300/RTMachine.i3#0TOP0">runtime/src/HP300/RTMachine.i3</A>
<LI><A HREF="../HPPA/RTMachine.i3#0TOP0">runtime/src/HPPA/RTMachine.i3</A>
<LI><A HREF="../IBMR2/RTMachine.i3#0TOP0">runtime/src/IBMR2/RTMachine.i3</A>
<LI><A HREF="../IBMRT/RTMachine.i3#0TOP0">runtime/src/IBMRT/RTMachine.i3</A>
<LI><A HREF="../IRIX5/RTMachine.i3#0TOP0">runtime/src/IRIX5/RTMachine.i3</A>
<LI><A HREF="../LINUX/RTMachine.i3#0TOP0">runtime/src/LINUX/RTMachine.i3</A>
<LI><A HREF="../LINUXELF/RTMachine.i3#0TOP0">runtime/src/LINUXELF/RTMachine.i3</A>
<LI><A HREF="../NEXT/RTMachine.i3#0TOP0">runtime/src/NEXT/RTMachine.i3</A>
<LI><A HREF="../NT386/RTMachine.i3#0TOP0">runtime/src/NT386/RTMachine.i3</A>
<LI><A HREF="../OKI/RTMachine.i3#0TOP0">runtime/src/OKI/RTMachine.i3</A>
<LI><A HREF="../SEQUENT/RTMachine.i3#0TOP0">runtime/src/SEQUENT/RTMachine.i3</A>
<LI><A HREF="../SOLgnu/RTMachine.i3#0TOP0">runtime/src/SOLgnu/RTMachine.i3</A>
<LI><A HREF="../SOLsun/RTMachine.i3#0TOP0">runtime/src/SOLsun/RTMachine.i3</A>
<LI><A HREF="../SPARC/RTMachine.i3#0TOP0">runtime/src/SPARC/RTMachine.i3</A>
<LI><A HREF="../SUN3/RTMachine.i3#0TOP0">runtime/src/SUN3/RTMachine.i3</A>
<LI><A HREF="../SUN386/RTMachine.i3#0TOP0">runtime/src/SUN386/RTMachine.i3</A>
<LI><A HREF="../UMAX/RTMachine.i3#0TOP0">runtime/src/UMAX/RTMachine.i3</A>
<LI><A HREF="../VAX/RTMachine.i3#0TOP0">runtime/src/VAX/RTMachine.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface ThreadF is in:
</A><UL>
<LI><A HREF="../../../thread/src/NOOP/ThreadF.i3#0TOP0">thread/src/NOOP/ThreadF.i3</A>
<LI><A HREF="../../../thread/src/POSIX/ThreadF.i3#0TOP0">thread/src/POSIX/ThreadF.i3</A>
<LI><A HREF="../../../thread/src/WIN32/ThreadF.i3#0TOP0">thread/src/WIN32/ThreadF.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
