<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTIO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTIO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                          </EM></BLOCKQUOTE><PRE>
</PRE> RTIO is a simple low-level interface for I/O used by the
   runtime.  None of its routines do any locking or require
   any memory allocation.  Output is buffered internally
   until <CODE>Flush</CODE> is called or the internal buffer overflows.
<P>
   Clients beware, this interface may change at any time.


<P><PRE>INTERFACE <interface><A HREF="RTIO.m3">RTIO</A></interface>;

PROCEDURE <A HREF="RTIO.m3#PutChar">PutChar</A> (c: CHAR);
</PRE><BLOCKQUOTE><EM> Write <CODE>c</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTIO.m3#PutChars">PutChars</A> (a: ADDRESS;  n: INTEGER);
</PRE><BLOCKQUOTE><EM> Write characters <CODE>a[0..n-1]</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTIO.m3#PutString">PutString</A> (s: ADDRESS);
</PRE><BLOCKQUOTE><EM> Write the null terminated string beginning at <CODE>s</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTIO.m3#PutText">PutText</A> (t: TEXT);
</PRE><BLOCKQUOTE><EM> Write text <CODE>t</CODE> on file <CODE>f</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTIO.m3#PutInt">PutInt</A> (i: INTEGER;  width := 0);
</PRE><BLOCKQUOTE><EM> Convert integer <CODE>i</CODE> to decimal digits and write it right-justified
   in a field of <CODE>width</CODE> characters. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTIO.m3#PutHex">PutHex</A> (i: INTEGER;  width := 0);
</PRE><BLOCKQUOTE><EM> Convert unsigned integer <CODE>i</CODE> to hexidecimal digits with a <CODE>0x</CODE> prefix
   and write it right-justified in a field of <CODE>width</CODE> characters. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTIO.m3#PutAddr">PutAddr</A> (a: ADDRESS;  width := 0);
</PRE><BLOCKQUOTE><EM> == PutHex (LOOPHOLE (a, INTEGER), width) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTIO.m3#Flush">Flush</A> ();
</PRE><BLOCKQUOTE><EM> Flush any buffered characters to the operating system. </EM></BLOCKQUOTE><PRE>

END RTIO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
